var cVideoList = {
	arrVideoList: null,
	URL: null,
	currentURL: null,
	XHRTool: null,
	
	basePage: null,
	currentPage: null,
	totalPage: null,
	totalCount: null,
	perPage: null,
	
	currentVideo: null,
	
	catalogName: null,
	
	myTimer: null,
	timerCount: 0
}


cVideoList.create = function( extraURL, newPage, newIndex ) {
	arrVideoList = new Array;
	
	currentURL = extraURL;
	//URL = Define.BASE_URL + extraURL;
	URL = extraURL;
	
	if ( newPage > 0 ) {
		currentPage = newPage;
		URL += "/page/" + newPage.toString();
	} else currentPage = 0;
	//alert( "URL: " + URL );
	
	currentVideo = newIndex;
	totalCount = 0;
	
	cVideoList.XHRTool = new XHRToolKit(URL, function (result) {
        cVideoList.onReceiveData(result);
    });
	
	Define.wait_flag = true;
	widgetAPI.putInnerHTML( $('videoList'), '' );
	//$( 'videoList' ).class = 'hidden';
	$( 'videoListLoad' ).class = '';
	$( 'videoListError' ).class = 'hidden';
	cVideoList.XHRTool.sendXHRRequest();
}


cVideoList.onReceiveData = function(bSuccess) {
	if (bSuccess) {
		var responseXML = cVideoList.XHRTool.getResponseXML();
		var responseDoc = responseXML.documentElement;
		
		if ( responseDoc.getAttribute("name") ) catalogName = responseDoc.getAttribute("name");//.toString();
		if ( responseDoc.getAttribute("page") ) currentPage = responseDoc.getAttribute("page");
		if ( responseDoc.getAttribute("perpage") ) perPage = responseDoc.getAttribute("perpage");
		if ( responseDoc.getAttribute("totalcount") ) totalCount = responseDoc.getAttribute("totalcount");
		
		totalPage = Math.ceil( totalCount / perPage );
		
		if (responseDoc) {
			var itemElements = responseDoc.getElementsByTagName("folder");
			if ( itemElements && itemElements.length > 0 ) {
				for ( var i = 0; i < itemElements.length; i++ ) {
					if ( cVideoList.isValidNormalFolder( itemElements[i] ) ) {
						var tName = cVideoList.getElementData(itemElements[i], "name");
						var tThumbnail = cVideoList.getElementData(itemElements[i], "thumbnail");
						var tLink = cVideoList.getElementData(itemElements[i], "link");
						//var tLength = cVideoList.getElementData(itemElements[i], "length");
						//var tDate = cVideoList.getElementData(itemElements[i], "date");
						
						//alert( "folder: " + tName + " " + tThumbnail + " " + tLink + " " + tLength + " " + tDate );
						arrVideoList[arrVideoList.length] = new Video(tName, tThumbnail, tLink, tLength, tDate, true );
					}
				}
			}
			
			itemElements = responseDoc.getElementsByTagName("item");
			if ( itemElements && itemElements.length > 0 ) {
				for ( var i = 0; i < itemElements.length; i++ ) {
					if ( cVideoList.isValidNormalArticle( itemElements[i] ) ) {
						var tName = cVideoList.getElementData(itemElements[i], "name");
						var tThumbnail = cVideoList.getElementData(itemElements[i], "thumbnail");
						var tLink = cVideoList.getElementData(itemElements[i], "link");
						var tLength = cVideoList.getElementData(itemElements[i], "length");
						var tDate = cVideoList.getElementData(itemElements[i], "date");
						
						//alert( "item: " + tName + " " + tThumbnail + " " + tLink + " " + tLength + " " + tDate );
						arrVideoList[arrVideoList.length] = new Video( tName, tThumbnail, tLink, tLength, tDate, false );
					}
				}
			}
		}
		cVideoList.initView();
		Define.wait_flag = false;
	} else {
		//cant get data!!!
		//$( 'videoListError' ).class = '';
		Define.wait_flag = false;
		alertNew( Define.ERROR0, Define.ERROR1, 'menu' );
		//cKeyHandler.focusToMenuList();
		
		currentIndex = lastIndex;
		cMenuList.initView();
	}
}


cVideoList.getElementData = function (itemElement, element) {
	if ( itemElement.getElementsByTagName(element)[0].firstChild ) return itemElement.getElementsByTagName(element)[0].firstChild.data;
	else return "";
}

cVideoList.isValidNormalFolder = function (itemElement) {
	if ( itemElement.getElementsByTagName("name")[0] 
		&& itemElement.getElementsByTagName("thumbnail")[0] 
		&& itemElement.getElementsByTagName("link")[0] ) {
		return true;
	}
	return false;
}

cVideoList.isValidNormalArticle = function (itemElement) {
	if ( itemElement.getElementsByTagName("name")[0] 
		&& itemElement.getElementsByTagName("thumbnail")[0] 
		&& itemElement.getElementsByTagName("link")[0]
		&& itemElement.getElementsByTagName("length")[0]
		&& itemElement.getElementsByTagName("date")[0] ) {
		return true;
	}
	return false;
}


cVideoList.initView = function() {
	var listHtml = '';
	
	var feed = '';
	for ( var i = Math.max( 1, currentPage - 3 ), len = Math.min( totalPage + 1, parseInt(currentPage) + 4 ); i < len; i++ ) {
		if ( i != currentPage ) feed += '&nbsp;' + i + '&nbsp;';
		else {
			feed += '<span style="color:#cf1111; font-size:18px; font-family:Arial;">&nbsp;' + i + '&nbsp;</span>';
		}
	}
	if ( currentPage*1 + 3 < totalPage ) feed += '&nbsp;...&nbsp;' + totalPage;
	if ( currentPage*1 > 4 ) feed = '1&nbsp;...&nbsp;' + feed;
	feed = Define.PAGE + '&nbsp;' + feed;
	if ( totalPage <= 1 ) feed = '&nbsp;';
	
	listHtml += '<div id="pageData" class="pageData">' + feed + '</div>';
	$('tempTitle').className = 'style_videoTitle';
	
	for( var i = 0; i < 6 && i < arrVideoList.length; i++ ){
		//base div
		listHtml += '<div id="video' + i + '" class="video">';
		
		//img
		listHtml += '<div id="img' + i;
		listHtml += '" class="img" align="center"></div>';
		
		//title
		var txtArray = arrVideoList[ i ].text.split( ' ' );
		var resultTxt = '';
		var index = 0;
		
		while ( index < txtArray.length ) {
			//widgetAPI.putInnerHTML( $('tempTitle'), resultTxt + txtArray[index] + ( index != 0 ? '' : ( index < txtArray.length - 1 ? ' ...' : ' ' ) ) );
			widgetAPI.putInnerHTML( $('tempTitle'), resultTxt + ' ' + txtArray[index] );
			//$('tempTitle').innerText = resultTxt + txtArray[index];
			
			//alert( $('tempTitle').style.fontSize + ' # ' + $('tempTitle').offsetHeight + ' # ' + $('tempTitle').style.lineHeight );
			
			if ( $('tempTitle').offsetHeight <= 38 ) {
				if ( index != 0 ) resultTxt += ' ';
				resultTxt += txtArray[index];
				index++;
			} else {
				widgetAPI.putInnerHTML( $('tempTitle'), resultTxt + ' ...' );
				
				if ( $('tempTitle').offsetHeight <= 38 ) {
					resultTxt += ' ...';
				} else {
					resultTxt = resultTxt.slice( 0, -3 ) + '...';
				}
				break;
			}
		}
		//if ( index < txtArray.length ) resultTxt += ' ...';
		
		listHtml += '<div id="title' + i;
		listHtml += '" class="' + ( arrVideoList[i].folder ? "style_videoTitleFolder" : "style_videoTitle" ) + '"';
		if ( $( 'path' ).innerText == 'Каналы' ) {
			listHtml += ' style="padding-top:5px;width:200px;font-size:20px;text-align:center;">';
		} else if ( $('tempTitle').offsetHeight == 19 && arrVideoList[i].folder ) {
			listHtml += ' style="padding-top:10px;">';
		} else {			
			listHtml += '>';
		}
		
		listHtml += resultTxt;
		//listHtml += arrVideoList[ i ].text;
		listHtml += '</div>';
		
		
		//timing
		if ( !arrVideoList[i].folder && arrVideoList[ i ].lngth != '' ) {
			listHtml += '<div id="timing' + i;
			listHtml += '" class="style_videoTiming">';
			listHtml += Define.VIDEO_LENGTH + arrVideoList[ i ].lngth;
			listHtml += '</div>';
		}
		
		listHtml += '</div>';
	}

	timerCount = 0;
	myTimer = setTimeout( "cVideoList.imageTimer()", Define.TIME_OUT );
	
	widgetAPI.putInnerHTML( $('videoList'), listHtml );
	cVideoList.changeSelect();
	
	for( var i = 0; i < 6 && i < arrVideoList.length; i++ ){
		cVideoList.getImage( arrVideoList[i].thumbnail, $( "img" + i.toString() ), i );
	}
	
}


cVideoList.changeSelect = function() {
	if ( arrVideoList.length == 0 ) currentVideo = -1;
	if ( currentVideo >= arrVideoList.length ) currentVideo = arrVideoList.length - 1;
	
	for( var i = 0; i < 6 && i < arrVideoList.length; i++ ){
		if ( i !== currentVideo ) str = "un";
		else str = "";
		
		if ( arrVideoList[i].folder )
			$( "video" + i.toString() ).style.backgroundImage = "url(image/" + str + "selectFolder.png)";
		else 
			$( "video" + i.toString() ).style.backgroundImage = "url(image/" + str + "selectVideo.png)";
	}
	
	$( 'videoList' ).class = '';
	$( 'videoListLoad' ).class = 'hidden';
	
	if ( currentVideo == -1 ) {
		cKeyHandler.focusToMenuList();
		
		currentIndex = lastIndex;
		cMenuList.initView();
	}
}


cVideoList.getImage = function( imgUrl, object, i ) {
	//imgUrl = 'image/57.png';
	//var feed = "<img src='image/tempImg.png' width=" + Define.IMAGE_WIDTH + "px height=" + Define.IMAGE_HEIGHT + "px/>";
	var feed = "<img src='image/tempImg.png' width='166px' height='120px'/>";
	widgetAPI.putInnerHTML( object, feed );
	
	if ( arrVideoList[i].folder ) object.class = 'img_folder';
	else object.class = 'img';
	
	var imag = new Image();
	imag.src = imgUrl;
	
	var imgWidth = imag.width;
	var imgHeight = imag.height;
	//alert( "imgWidth " + imgWidth + "   imgHeight " + imgHeight );
	
	var koeff = 1;
	if ( imgWidth != 0 && imgHeight != 0 ) {
		var kWidth = Define.IMAGE_WIDTH / imgWidth;
		var kHeight = Define.IMAGE_HEIGHT / imgHeight;
		
		koeff = ( kWidth < kHeight ? kWidth : kHeight );
		
		var newFeed = "<img src='" + imgUrl + "' width=" + ( imgWidth * koeff ) + "px height=" + ( imgHeight  * koeff ) + "px/>";
		widgetAPI.putInnerHTML( object, newFeed );
		
		arrVideoList[ i ].set = true;
	} else {
		//object.innerHTML = "";
		//object.innerHTML = "<img src='image/noImg.png' width=" + Define.IMAGE_WIDTH + "px height=" + Define.IMAGE_HEIGHT + "px/>";
		arrVideoList[ i ].set = false;
	}
}


cVideoList.imageTimer = function() {
	var tempFlag = true;
	timerCount++;
	//alert( "imageTimer: " + timerCount );
	
	for( var i = 0; i < 6; i++ ){
		if ( i < arrVideoList.length ) {
			if ( !arrVideoList[i].set ) cVideoList.getImage( arrVideoList[i].thumbnail, $( "img" + i.toString() ), i );
		}
	}
	for( var i = 0; i < arrVideoList.length; i++ ){
		if ( !arrVideoList[i].set ) {
			tempFlag = false;
			break;
		}
	}
	
	if ( !tempFlag && timerCount < Define.IMAGE_TIMER_COUNT ) myTimer = setTimeout( "cVideoList.imageTimer()", Define.TIME_OUT );
}


cVideoList.leftIndex = function() {
	if ( currentVideo == -1 ) return;
	
	if ( currentVideo != 0 && currentVideo != 3 ) {
		currentVideo--;
		cVideoList.changeSelect();
	} else {
		currentVideo = -1;
		cVideoList.changeSelect();
		cKeyHandler.focusToMenuList();
		
		currentIndex = lastIndex;
		cMenuList.initView();
	}
}


cVideoList.rightIndex = function() {
	if ( currentVideo == -1 ) return;
	
	if ( currentVideo != 2 && currentVideo != 5 ) {
		currentVideo++;
		cVideoList.changeSelect();
	}
}


cVideoList.upIndex = function( index ) {
	if ( currentVideo == -1 ) return;
	//alert( index );
	
	if ( currentVideo > 2 && !index ) {
		currentVideo -= 3;
		cVideoList.changeSelect();
	} else if ( currentPage > 1 ) {
		if ( index ) currentPage = Math.max( 0, currentPage*1 - index );
		else {
			currentPage--;
			currentVideo += 3;
		}
		
		cVideoList.create( currentURL, currentPage, currentVideo );
	}
}


cVideoList.downIndex = function( index ) {
	if ( currentVideo == -1 ) return;
	//alert( index );
	
	if ( currentVideo < 3 && !index ) {
		currentVideo += 3;
		cVideoList.changeSelect();
	} else if ( currentPage < totalPage ) {
		if ( index ) currentPage = Math.min( totalPage, currentPage*1 + index );
		else {
			currentPage++;
			currentVideo -= 3;
		}
		cVideoList.create( currentURL, currentPage, currentVideo );
	}
}


cVideoList.setIndex = function() {
	if ( currentVideo == -1 ) return;
	
	if ( arrVideoList[ currentVideo ].folder ) {
		$( 'path' ).innerText += '    |    ' + arrVideoList[ currentVideo ].text;
		
		cVideoList.create( arrVideoList[ currentVideo ].link, 0, 0 );
	} else {
		//alert( '///////////////////////////////////////////////////////////Lets PLAY!!!');
		$( 'main' ).class = 'hidden';
		$( 'player' ).class = '';
		$( 'windowScreen' ).class = '';
		
		cKeyHandler.focusToPlayer();
		Player.getLink( arrVideoList[ currentVideo ].link, arrVideoList[ currentVideo ].thumbnail, arrVideoList[ currentVideo ].lngth );
	}
}