﻿var cKeyHandler = {
    tvKey : null,
    menuListAnchor : null,
    videoListAnchor : null,
	searchAnchor: null,
    playerAnchor : null,
	errorAnchor : null
}

cKeyHandler.create = function() {
    this.menuListAnchor = $("menuListAnchor");
    this.videoListAnchor = $("videoListAnchor");
    this.searchAnchor = $("searchAnchor");
    this.playerAnchor = $("playerAnchor");
	this.errorAnchor = $("errorAnchor");
	
    this.tvKey = new Common.API.TVKeyValue();
}


cKeyHandler.menuListKeyDown = function() {
	if ( Define.wait_flag ) return;
	if ( $( 'error' ).class == '' ) {
		window.close();
	}
	
    var menuListKeyCode = event.keyCode;
	//alert( "//////////////////////////////////menuListKeyCode = " + menuListKeyCode );
    
    switch(menuListKeyCode) {
		case this.tvKey.KEY_RETURN:
			//alert( '#########################this.tvKey.KEY_RETURN pressed' );
			//widgetAPI.blockNavigation(event);
			widgetAPI.sendReturnEvent(); 
			break;
        case this.tvKey.KEY_UP:
            cMenuList.upIndex();
            break;
        case this.tvKey.KEY_DOWN:
            cMenuList.downIndex();
            break;
        case this.tvKey.KEY_ENTER:
            cMenuList.setIndex();
            break;
		case 35:
			//TODO temp disable. not for this vesion
			//Search.start( 'menu' );
			break;
			
			
			
		case tvKey.KEY_VOL_UP:
        case tvKey.KEY_PANEL_VOL_UP:
            //alert("VOL_UP");
            Audio.setRelativeVolume(0);
            break;
            
        case tvKey.KEY_VOL_DOWN:
        case tvKey.KEY_PANEL_VOL_DOWN:
            //alert("VOL_DOWN");
            Audio.setRelativeVolume(1);
            break;      
			
		case tvKey.KEY_MUTE:
            //alert("MUTE");
            Audio.muteMode();
            break;

    }
}

cKeyHandler.videoListKeyDown = function() {
	if ( Define.wait_flag ) return;
	
    var videoListKeyCode = event.keyCode;
	//alert( "//////////////////////////////////videoListKeyCode = " + videoListKeyCode );
    
    switch(videoListKeyCode) {
		case this.tvKey.KEY_RETURN:
			//alert( '#########################this.tvKey.KEY_RETURN pressed' );
			//widgetAPI.blockNavigation(event);
			widgetAPI.sendReturnEvent(); 
			break;
			
        case this.tvKey.KEY_LEFT:
			cVideoList.leftIndex();
            break;
        case this.tvKey.KEY_RIGHT:
			cVideoList.rightIndex();
            break;
			
		case this.tvKey.KEY_RED:
			cVideoList.upIndex(10);
			break;
		case this.tvKey.KEY_GREEN:
			cVideoList.upIndex(3);
			break;
        case this.tvKey.KEY_UP:
            cVideoList.upIndex();
            break;
			
        case this.tvKey.KEY_BLUE:
			cVideoList.downIndex(10);
			break;
		case this.tvKey.KEY_YELLOW:
			cVideoList.downIndex(3);
			break;
		case this.tvKey.KEY_DOWN:
            cVideoList.downIndex();
            break;
        case this.tvKey.KEY_ENTER:
            cVideoList.setIndex();
            break;
			
		case 35:
			//TODO temp disable. not for this vesion
			//Search.start( 'video' );
			break;
			
			
			
		case tvKey.KEY_VOL_UP:
        case tvKey.KEY_PANEL_VOL_UP:
            //alert("VOL_UP");
            Audio.setRelativeVolume(0);
            break;
            
        case tvKey.KEY_VOL_DOWN:
        case tvKey.KEY_PANEL_VOL_DOWN:
            //alert("VOL_DOWN");
            Audio.setRelativeVolume(1);
            break;      
			
		case tvKey.KEY_MUTE:
            //alert("MUTE");
            Audio.muteMode();
            break;


    }
}

cKeyHandler.searchKeyDown = function() {
 	if ( Define.wait_flag ) return;
	
	var searchKeyCode = event.keyCode;
	//alert( "//////////////////////////////////searchKeyDown = " + searchKeyCode );
	
	switch( searchKeyCode ) {
		case this.tvKey.KEY_RETURN:
			//alert( '#########################this.tvKey.KEY_RETURN pressed' );
			widgetAPI.blockNavigation(event);
			Search.goBack();
			break;
			
		case this.tvKey.KEY_1:
			Search.pressKey( 1 );
			break;
		case this.tvKey.KEY_2:
			Search.pressKey( 2 );
			break;
		case this.tvKey.KEY_3:
			Search.pressKey( 3 );
			break;
		case this.tvKey.KEY_4:
			Search.pressKey( 4 );
			break;
		case this.tvKey.KEY_5:
			Search.pressKey( 5 );
			break;
		case this.tvKey.KEY_6:
			Search.pressKey( 6 );
			break;
		case this.tvKey.KEY_7:
			Search.pressKey( 7 );
			break;
		case this.tvKey.KEY_8:
			Search.pressKey( 8 );
			break;
		case this.tvKey.KEY_9:
			Search.pressKey( 9 );
			break;
		case this.tvKey.KEY_PRECH:
			Search.pressKey( 0 );
			break;
			
		 case this.tvKey.KEY_ENTER:
            Search.startSearch();
            break;
			
			
			
		case tvKey.KEY_VOL_UP:
        case tvKey.KEY_PANEL_VOL_UP:
            //alert("VOL_UP");
            Audio.setRelativeVolume(0);
            break;
            
        case tvKey.KEY_VOL_DOWN:
        case tvKey.KEY_PANEL_VOL_DOWN:
            //alert("VOL_DOWN");
            Audio.setRelativeVolume(1);
            break;      
			
		case tvKey.KEY_MUTE:
            //alert("MUTE");
            Audio.muteMode();
            break;

	}
}

cKeyHandler.playerKeyDown = function() {
	if ( Define.wait_flag ) return;
	
    var playerKeyCode = event.keyCode;
	//alert( "//////////////////////////////////playerKeyCode = " + playerKeyCode );

	switch(playerKeyCode) {
		case this.tvKey.KEY_RETURN:
			if ( Player.regime != 'window') {
				//alert( 'windows' );
				widgetAPI.blockNavigation(event);
				Player.setIndex();
			} else {
				//alert( '#########################this.tvKey.KEY_RETURN pressed' );
				widgetAPI.blockNavigation(event);
				Player.backToVideo();
			}
			break;
			
        case this.tvKey.KEY_LEFT:
			if ( Player.regime == 'window' ) Player.leftIndex();
            break;
        case this.tvKey.KEY_RIGHT:
			if ( Player.regime == 'window' ) Player.rightIndex();
            break;
			
        case this.tvKey.KEY_ENTER:
            if ( Player.regime == 'window' ) {
				Player.setIndex();
			}
            break;
			
			
			
		case tvKey.KEY_VOL_UP:
        case tvKey.KEY_PANEL_VOL_UP:
            //alert("VOL_UP");
            Audio.setRelativeVolume(0);
            break;
            
        case tvKey.KEY_VOL_DOWN:
        case tvKey.KEY_PANEL_VOL_DOWN:
            //alert("VOL_DOWN");
            Audio.setRelativeVolume(1);
            break;      
			
		case tvKey.KEY_MUTE:
            //alert("MUTE");
            Audio.muteMode();
            break;
			
			
		case tvKey.KEY_RW:
			Player.skipBackwardVideo();
			break;
		case tvKey.KEY_PAUSE:
			if ( Player.state == Player.PLAYING ) Player.pauseVideo();
			break;
		case tvKey.KEY_FF:
			Player.skipForwardVideo();
			break;
		case tvKey.KEY_PLAY:
			if ( Player.state == Player.STOPPED ) Player.playVideo();
			else if ( Player.state == Player.PAUSED ) Player.resumeVideo();
			break;
		case tvKey.KEY_STOP:
			Player.stopVideo();
			break;
			
		case tvKey.KEY_INFO:
			Player.showInfo();
			break;
    }
}

cKeyHandler.errorKeyDown = function() {
	if ( Define.wait_flag ) return;
	
    var errorKeyCode = event.keyCode;
	//alert( "//////////////////////////////////playerKeyCode = " + playerKeyCode );

	if ( errorKeyCode != this.tvKey.KEY_RETURN ) return;
	
	switch( returnTo ) {
		case 'exit':
			widgetAPI.sendReturnEvent(); 
			break;
		case 'menu':
			widgetAPI.blockNavigation(event);
			cKeyHandler.focusToMenuList();
			$( 'videoListLoad' ).class = 'hidden';
			$( 'error' ).class = 'hidden';
			break;
		case 'video':
			widgetAPI.blockNavigation(event);
			cKeyHandler.focusToVideoList();
			$( 'main' ).class = '';
			$( 'player' ).class = 'hidden';
			$( 'windowScreen' ).class = 'hidden';
		
			$( 'videoListLoad' ).class = 'hidden';
			$( 'error' ).class = 'hidden';
			break;
		case 'player':
			widgetAPI.blockNavigation(event);
			cKeyHandler.focusToPlayer();
			$( 'error' ).class = 'hidden';
			break;
		
		case tvKey.KEY_VOL_UP:
        case tvKey.KEY_PANEL_VOL_UP:
            //alert("VOL_UP");
            Audio.setRelativeVolume(0);
            break;
            
        case tvKey.KEY_VOL_DOWN:
        case tvKey.KEY_PANEL_VOL_DOWN:
            //alert("VOL_DOWN");
            Audio.setRelativeVolume(1);
            break;      
			
		case tvKey.KEY_MUTE:
            //alert("MUTE");
            Audio.muteMode();
            break;

    }
}



cKeyHandler.focusToMenuList = function() {
	//alert( 'focusToMenuList();' );
    this.menuListAnchor.focus();
}

cKeyHandler.focusToVideoList = function() {
	//alert( 'focusToVideoList();' );
    this.videoListAnchor.focus();
}

cKeyHandler.focusToPlayer = function() {
	//alert( 'focusToPlayer();' );
    this.playerAnchor.focus();
}

cKeyHandler.focusToSearch = function() {
	//alert( 'focusToSearch();' );
    this.searchAnchor.focus();
}

cKeyHandler.focusToError = function() {
	//alert( 'focusToError();' );
    this.errorAnchor.focus();
}
