var Player =
{
    plugin : null,
    state : -1,
    skipState : -1,
    stopCallback : null,    /* Callback function to be set by client */
    originalSource : null,
	
	videoWidth: null,
	videoHeight: null,
	koeff: null,
	
    XHRTool: null,
	baseURL: null,
	
	regime: 'window',
	
	title: '',
	image: '',
	lngth: '',
	description: '',
	
    STOPPED : 0,
    PLAYING : 1,
    PAUSED : 2,  
    FORWARD : 3,
    REWIND : 4,
	
	totalTime: '',
	buttonNames: null,
	currentKey: 0,
	
	sendClick: false,
	videoId: ''
}

Player.init = function()
{
    var success = true;
    Player.state = Player.STOPPED;
    Player.plugin = $("pluginObjectPlayer");
    
    if (!Player.plugin)
    {
         success = false;
    }
    else
    {
        var mwPlugin = $("pluginObjectTVMW");
        
        if (!mwPlugin)
        {
            success = false;
        }
        else
        {
            /* Save current TV Source */
            Player.originalSource = mwPlugin.GetSource();
            
            /* Set TV source to media player plugin */
            mwPlugin.SetMediaSource();
        }
    }
    
    //Player.setWindow();
    Player.plugin.OnStreamNotFound = 'Player.onStreamNotFound';
	
    Player.plugin.OnStreamInfoReady = 'Player.setTotalTime';
	Player.plugin.OnCurrentPlayTime = 'Player.setCurTime';
	
    Player.plugin.OnBufferingStart = 'Player.onBufferingStart';
    Player.plugin.OnBufferingProgress = 'Player.onBufferingProgress';
    Player.plugin.OnBufferingComplete = 'Player.onBufferingComplete';           
	
	Player.plugin.OnRenderError = 'Player.OnRenderError';
	Player.plugin.OnRenderingComplete = 'Player.OnRenderingComplete';
	
	Player.plugin.OnResolutionChanged = 'Player.OnResolutionChanged';
	
	Player.plugin.OnConnectionFailed = 'Player.OnConnectionFailed';
	Player.plugin.OnNetworkDisconnected = 'Player.OnNetworkDisconnected';
	
    return success;
}

Player.deinit = function()
{
	Player.stopVideo();
	
    var mwPlugin = $("pluginTVMW");
	
    if (mwPlugin && (Player.originalSource != null) )
    {
		/* Restore original TV source before closing the widget */
        mwPlugin.SetSource(Player.originalSource);
		//alert("Restore source to " + Player.originalSource);
	}
}

Player.setWindow = function()
{
	Player.regime = 'window';
	
	$( 'main' ).class = 'hidden';
	$( 'player' ).class = '';
	$( 'windowScreen' ).class = '';
	$( 'fullScreen' ).class = 'hidden';
	
	if ( Player.koeff != null ) {
		var k = 360 / Player.videoHeight;
		Player.plugin.SetDisplayArea( 20 + ( 640 - Player.videoWidth * k ) / 2, 40, Player.videoWidth * k, Player.videoHeight * k);
	} else {
		Player.plugin.SetDisplayArea( 100, 40, 480, 360 );
	}
	
	if ( Player.state == Player.PAUSED ) Player.pauseVideo();
}

Player.setFullscreen = function()
{
	Player.regime = 'full';

	
	$( 'main' ).class = 'hidden';
	$( 'player' ).class = '';
	$( 'windowScreen' ).class = 'hidden';
	$( 'fullScreen' ).class = '';
	$( 'fullBack' ).class = '';
	
	if ( Player.koeff != null ) {
		Player.plugin.SetDisplayArea( ( 960 - Player.videoWidth * Player.koeff ) / 2, 0, Player.videoWidth * Player.koeff, Player.videoHeight * Player.koeff );
	} else {
		var k = 540 / 480;
		Player.plugin.SetDisplayArea( ( 960 - 640 * k ) / 2, 0, 640 * k, 480 * k );
	}
	
	if ( Player.state == Player.PAUSED ) Player.pauseVideo();
}

Player.showInfo = function()
{
	if ( $('fullBack').class == '' ) {
		$( 'fullBack' ).class = 'hidden';
	} else {
		$( 'fullBack' ).class = '';
	}
}


Player.getLink = function( url, imgURL, lgnth ) {
	$('status').class = 'hidden';
	$("progressBar").style.width = '0%';
	$("progressBar1").style.width = '0%';
	
	Player.sendClick = false;
	Player.videoId = url.substr( url.lastIndexOf('/') + 1 );
	
	//Player.baseURL = Define.BASE_URL + url;
	Player.baseURL = url;
	//alert( "getLinkURL: " + Player.baseURL );
	Player.image = imgURL;
	Player.lngth = lgnth;
	
	//background-image
	widgetAPI.putInnerHTML( $('playerTitle'), '' );
	widgetAPI.putInnerHTML( $('playerLngth'), '' );
	widgetAPI.putInnerHTML( $('playerText'), '' );
	//$( "playerImg" ).style.backgroundImage = "url(none)";
	widgetAPI.putInnerHTML( $('playerImg'), '' );
	
	widgetAPI.putInnerHTML( $('timeInfo'), Player.lngth != '' ? '0:00:00/' + Player.lngth : '0:00:00/0:00:00' );
	widgetAPI.putInnerHTML( $('timeInfo1'), Player.lngth != '' ? '0:00:00/' + Player.lngth : '0:00:00/0:00:00' );
	
	
	Player.XHRTool = new XHRToolKit( Player.baseURL, function (result) {
        Player.onReceiveData(result);
    });
	
	Player.XHRTool.sendXHRRequest();
	Define.wait_flag = true;
	
	Player.currentKey = 0;
	
	Player.setWindow();
	Player.setButtons();
}

Player.onReceiveData = function(bSuccess) {
	if (bSuccess) {
		var responseXML = Player.XHRTool.getResponseXML();
		var responseDoc = responseXML.documentElement;
		
		if (responseDoc) {
			//img
			//$( "playerImg" ).style.backgroundImage = "url(" + Player.image + ")";
			widgetAPI.putInnerHTML( $('playerImg'), '<img width="100%" height="100%" src="' + Player.image + '">' );
			//alert( 'Player.image:' + Player.image );
            
			//title
			Player.title = cVideoList.getElementData( responseDoc, 'name' );
			widgetAPI.putInnerHTML( $('playerTitle'), Player.title != undefined ? Player.title : '' );
			
			$('tempTitle').class = 'tempDoc';
			var offsetTop = $('playerText').offsetTop;
			//description
			var txtArray = cVideoList.getElementData( responseDoc, 'description' ).split( ' ' );
			var resultTxt = '';
			var index = 0;
			
			while ( index < txtArray.length ) {
				widgetAPI.putInnerHTML( $('tempTitle'), resultTxt + txtArray[index] + ' ...' );
				if ( $('tempTitle').offsetHeight*1 + offsetTop < 445 ) {
					resultTxt += txtArray[index] + ' ';
					index++;
				} else {
					//resultTxt += ' ...';
					resultTxt = resultTxt.substr(0, resultTxt.length - 3) + ' ...';
					break;
				}
			}
			Player.description = resultTxt;
			//Player.description = cVideoList.getElementData( responseDoc, 'description' );
			
			widgetAPI.putInnerHTML( $('playerLngth'), Player.lgnth != undefined ? Player.lngth : '' );
			widgetAPI.putInnerHTML( $('playerText'), Player.description != undefined ? Player.description : '' );
			
			var itemElement = responseDoc.getElementsByTagName("video");
			if ( itemElement ) {
				var tType = itemElement[0].getAttribute("type").toString();
				var tLink = itemElement[0].firstChild.data;
				//alert( tType + " " + tLink );
				Player.setVideoURL( tLink );
				
				//Player.playVideo();
				Define.wait_flag = false;
			}
		}
	} else {
		Define.wait_flag = false;
		alertNew( Define.ERROR0, Define.ERROR1, 'video' );
	}
}



Player.setVideoURL = function(url)
{
    //var url1 = url.replace( "samsung", "player");
    Player.url = url;
    
	//alert("URL = " + Player.url );
}

Player.playVideo = function()
{
    if (Player.url == null)
    {
		alertNew( 'Ошибка', 'Не получен адрес видеофрагмента.', 'player' );
        //alert("No videos to play");
    }
    else
    {
		//screenSaver!!!
		pluginAPI.setOffScreenSaver();
		
        Player.state = Player.PLAYING;
        if ( Player.regime == 'window' ) Player.setWindow();
		if ( Player.regime == 'full' ) Player.setFullscreen();
		
        Player.plugin.Play( Player.url );
		
		
		if ( !Player.sendClick ) {
			Player.sendClick = true;
			
			var url = 'http://pics.vesti.ru/counter/video_counter.gif?vid=' + Player.videoId + '&time=0&playerMode=vh';
			Player.XHRTool = new XHRToolKit( url, function (result) {
				//alert( '#####################################result: ' + result );
			});
			
			Player.XHRTool.sendXHRRequest();
		}
		
       	if ( Audio.mute == Audio.YMUTE ) {
			Audio.plugin.SetSystemMute(true);
			Audio.plugin.SetUserMute(true);
		}
		//else Audio.plugin.SetSystemMute(false);
    }
	
	Player.currentKey = 1;
	Player.setButtons();
}

Player.pauseVideo = function()
{
	$('status').class = 'hidden';
	
	//screenSaver!!!
	pluginAPI.setOnScreenSaver();

	
    Player.state = Player.PAUSED;
    Player.plugin.Pause();
	
	Player.currentKey = 1;
	Player.setButtons();
}

Player.stopVideo = function()
{
	$('status').class = 'hidden';
	
    if (Player.state != Player.STOPPED)
    {
		//screenSaver!!!
		pluginAPI.setOnScreenSaver();
		
		
        Player.state = Player.STOPPED;
        Player.plugin.Stop();
        Player.setTime(0);
        
		if (Player.stopCallback)
        {
            Player.stopCallback();
        }
    }
    else
    {
		//alert("Ignoring stop request, not in correct state");
    }
	
	$('progressBar').style.width = '0%';
	$('progressBar1').style.width = '0%';
	Player.currentKey = 3;
	Player.setButtons();
}

Player.resumeVideo = function()
{
    Player.state = Player.PLAYING;
    Player.plugin.Resume();
	
	if ( Audio.mute == Audio.YMUTE ) {
		Audio.plugin.SetSystemMute(true);
		Audio.plugin.SetUserMute(true);
	}
	//else Audio.plugin.SetSystemMute(false);
	
	Player.currentKey = 1;
	Player.setButtons();
}

Player.skipForwardVideo = function()
{
    Player.skipState = Player.FORWARD;
    Player.plugin.JumpForward( 300 );
	
	Player.currentKey = 2;
	Player.setButtons();
}

Player.skipBackwardVideo = function()
{
    Player.skipState = Player.REWIND;
    Player.plugin.JumpBackward( 300 );
	
	Player.currentKey = 0;
	Player.setButtons();
}

Player.getState = function()
{
    return Player.state;
}



Player.backToVideo = function()
{
	Player.stopVideo();
	cKeyHandler.focusToVideoList();
	
	$( 'main' ).class = '';
	$( 'player' ).class = 'hidden';
}

/////////////////////////////////////////////////////////////////
/////////////////////////////DISPLAY/////////////////////////////
/////////////////////////////////////////////////////////////////

Player.setTime = function(time)
{
    var timePercent = (100 * time) / Player.totalTime;
    var timeElement = $("timeInfo");
    var timeHTML = "";
    var timeHour = 0; var timeMinute = 0; var timeSecond = 0;
    var totalTimeHour = 0; var totalTimeMinute = 0; var totalTimesecond = 0;
    
    $('progressBar').style.width = timePercent + "%";
    $('progressBar1').style.width = timePercent + "%";
	
	
    if(Player.state == Player.PLAYING)
    {
        totalTimeHour = Math.floor(Player.totalTime/3600000);
        timeHour = Math.floor(time/3600000);
        
        totalTimeMinute = Math.floor((Player.totalTime%3600000)/60000);
        timeMinute = Math.floor((time%3600000)/60000);
        
        totalTimeSecond = Math.floor((Player.totalTime%60000)/1000);
        timeSecond = Math.floor((time%60000)/1000);
        
        timeHTML = timeHour + ":";
		
        if(timeMinute == 0)
            timeHTML += "00:";
        else if(timeMinute <10)
            timeHTML += "0" + timeMinute + ":";
        else
            timeHTML += timeMinute + ":";
            
        if(timeSecond == 0)
            timeHTML += "00/";
        else if(timeSecond <10)
            timeHTML += "0" + timeSecond + "/";
        else
            timeHTML += timeSecond + "/";
        
        timeHTML += totalTimeHour + ":";
        
        if(totalTimeMinute == 0)
            timeHTML += "00:";
        else if(totalTimeMinute <10)
            timeHTML += "0" + totalTimeMinute + ":";
        else
            timeHTML += totalTimeMinute + ":";
            
        if(totalTimeSecond == 0)
            timeHTML += "00";
        else if(totalTimeSecond <10)
            timeHTML += "0" + totalTimeSecond;
        else
            timeHTML += totalTimeSecond;
    }
    else {
        //timeHTML = "0:00:00/0:00:00";     
		timeHTML = (Player.lngth != '' ? '0:00:00/' + Player.lngth : '0:00:00/0:00:00');
		
		$('progressBar').style.width = '0%';
		$('progressBar1').style.width = '0%';
	}
	
    widgetAPI.putInnerHTML(timeElement, timeHTML);
	widgetAPI.putInnerHTML($("timeInfo1"), timeHTML);
}



/////////////////////////////////////////////////////////////////
//////////////////////////////INPUT//////////////////////////////
/////////////////////////////////////////////////////////////////


Player.leftIndex = function() 
{
	Player.setButtons();
	
	if ( Player.currentKey > 0 ) {
		Player.currentKey--;
		Player.setButtons();
	}
}

Player.rightIndex = function() 
{
	Player.setButtons();
	
	if ( Player.currentKey < 4 ) {
		Player.currentKey++;
		Player.setButtons();
	}
}

Player.setIndex = function() 
{
	if ( Player.regime == 'window' ) {
		//check for current key
		
		switch( Player.currentKey ) {
			case 0://rewind
				Player.skipBackwardVideo();
				break;
			case 1://play\pause
				if ( Player.state == Player.PAUSED ) {
					Player.resumeVideo();
				} else if ( Player.state == Player.PLAYING ) {
					Player.pauseVideo();
				} else if ( Player.state == Player.STOPPED ) {
					Player.playVideo();
				}
				break;
			case 2://forward
				Player.skipForwardVideo();
				break;
			case 3://stop
				Player.stopVideo();
				break;
			case 4://fullscreen
				Player.setFullscreen();
				break;
		}
	} else {
		//goto window screen;
		Player.setWindow();
	}
}



Player.setButtons = function()
{
	for ( var i = 0; i < 5; i++ ) {
		$( 'btn' + i.toString() ).style.backgroundImage = 'url(image/' + Player.buttonNames[ i ] + ( i == Player.currentKey ? '_hlt' : '' ) + '.png);';
	}
	
	if ( Player.state == Player.PLAYING ) {
		$( 'btn1' ).style.backgroundImage = 'url(image/btn_pause' + ( 1 == Player.currentKey ? '_hlt' : '' ) + '.png);';
	}
}


////////////////////////////////////////////////////
// Global functions called directly by the player //
////////////////////////////////////////////////////
Player.onStreamNotFound = function() 
{
	alertNew( 'Ошибка', 'Видео неподдерживаемого формата.', 'player' );
	Player.stopVideo();
}

Player.OnRenderError = function(renderErrorType)
{
	alertNew( 'Ошибка', 'Видео неподдерживаемого формата.', 'player' );
	//alert( 'OnRenderError ' + renderErrorType );
	Player.stopVideo();
}


Player.OnRenderingComplete = function() {
	//alert( 'OnRenderingComplete' );
	Player.stopVideo();
}

Player.OnResolutionChanged = function() {
	//alert( 'OnResolutionChanged' );
}


Player.OnConnectionFailed = function()
{
	alertNew( 'Ошибка соединения.', 'Невозможно получить данные с сервера.', 'player' );
	//alert( 'OnConnectionFailed' );
	Player.stopVideo();
}


Player.OnNetworkDisconnected = function() {
	alertNew( 'Ошибка соединения.', 'Разрыв соединения с сервером.', 'player' );
	//alert( 'OnNetworkDisconnected' );
	Player.stopVideo();
}


Player.onBufferingStart = function()
{
	widgetAPI.putInnerHTML( $('status'), 'Buffering...' );
	$('status').class = '';
	//alert("Buffering...");
}

Player.onBufferingProgress = function(percent)
{
	widgetAPI.putInnerHTML( $('status'), 'Buffering:' + percent + '%' );
	$('status').class = '';
	//alert("Buffering:" + percent + "%");
    //Display.status("Buffering:" + percent + "%");
}

Player.onBufferingComplete = function()
{
	$('status').innerHTML = '';
	$('status').class = 'hidden';
	//alert("onBufferingComplete =-> Play");
    //Display.status("Play");
}

Player.setCurTime = function(time)
{
    Player.setTime(time);
}

Player.setTotalTime = function()
{
    Player.totalTime = Player.plugin.GetDuration();
	
	/*if ( Player.plugin.GetVideoWidth() != 0 && Player.plugin.GetVideoHeight() != 0 ) {
		Player.videoWidth = Player.plugin.GetVideoWidth();
		Player.videoHeight = Player.plugin.GetVideoHeight();
		Player.koeff = 540 / Player.videoHeight;
	} else {
		Player.videoWidth = null;
		Player.videoHeight = null;
		Player.koeff = null;
	}*/
}


Player.buttonNames = [ 'btn_rw', 'btn_play', 'btn_ff', 'btn_stop', 'btn_fullscreen' ];