/**
 *@file            Plugin.js
 *@brief         TV Plugin 함수를 rapping 한 파일
 *@author      삼성 SDS, ESDM개발, 김성태선임
 *@date         2009.03.24
 */
if (this.Common == null) {
    this.Common = new Object();
}
if (this.Common.API == null) {
    this.Common.API = new Object();
}

//Common.API.Widget 의 이벤트들과 중복되면 안됨(100보다 큰 값 사용)
Common.API.EVENT_RETURN_WIDGETID = "100" ;		// TOOL 표시하는 위젯ID 저장을 위한 이벤트
Common.API.EVENT_RETURN_TO_WIDGET = "101" ;		// TOOL -> Widget 복귀시 전달되는 이벤트
Common.API.EVENT_IDLE_ON = "102" ;				// registerIdleEvent
Common.API.EVENT_IDLE_OFF = "103" ;				// unregisterIdleEvent

Common.API.Plugin = function(){
    var $THIS$ = this;
    var bWatchDog = true;
    
    var widgetAPIKey = null;

    var PLR_TRUE = 1;
    var PLR_FALSE = 0;
	var PL_CMN_INFO_VERSION = 0;
	var PL_DTVAPP_TOOL = 18 ;		// Tool 관련  apptype
	
	var EVENT_TO_DEVICE_SCREEN_SAVER_ON = 3 ;
	var EVENT_TO_DEVICE_SCREEN_SAVER_OFF = 4 ;
	var EVENT_TO_DEVICE_RESTART_WM = 5 ;	// 실제 각 위젯에서는 사용하지 않음
	var EVENT_TO_DEVICE_HIDE_TOOLS = 6 ;
    var PL_PRFID_AUTO_PROTECTION_TIME = 13;
	
	var Plugin = {
		TVMW : 				{		'nEnum' : 0,		'Object' : null,		'strVersion' : null		}
		, VIDEO : 				{		'nEnum' : 1,		'Object' : null,		'strVersion' : null		}
		, NNAVI : 				{		'nEnum' : 2,		'Object' : null,		'strVersion' : null		}
		, APPCOMMON : 	{		'nEnum' : 3,		'Object' : null,		'strVersion' : null		}
	}
    
    var KeyValue = {
		// 이시형 선임 지정 값 : plugin manual 참고할 것
        PL_TVMW_KEY_GRP_ALL : 0,
        PL_TVMW_KEY_GRP_NUMBER : 1,
        PL_TVMW_KEY_GRP_NAVI : 4,
        PL_TVMW_KEY_GRP_COLOR : 5,
        PL_TVMW_KEY_GRP_PLAYBACK : 6,
        PL_TVMW_KEY_HYPHEN : 10,
        PL_TVMW_KEY_11     : 11,
		
        PL_TVMW_KEY_CH_PREV : 102,
        PL_TVMW_KEY_CH_FAV : 103,
        PL_TVMW_KEY_CH_LIST : 104,
        PL_TVMW_KEY_CH_PANNEL_UP : 105,
        PL_TVMW_KEY_CH_PANNEL_DOWN : 106,
        
        PL_TVMW_KEY_VOL_UP : 200,
        PL_TVMW_KEY_VOL_DOWN : 201,
        PL_TVMW_KEY_MUTE : 202,
        PL_TVMW_KEY_VOL_PANNEL_UP : 203,
        PL_TVMW_KEY_VOL_PANNEL_DOWN : 204,
        
        PL_TVMW_KEY_ENTER : 300,
        PL_TVMW_KEY_RETURN : 301,
        PL_TVMW_KEY_EXIT : 302,
        PL_TVMW_KEY_WHEEL_LEFT : 307,
        PL_TVMW_KEY_WHEEL_RIGHT : 308,
        PL_TVMW_KEY_PANNEL_ENTER : 309,
        
        PL_TVMW_KEY_INFO : 600,
        PL_TVMW_KEY_TOOLS : 601,
        PL_TVMW_KEY_INFOLINK : 602,
        PL_TVMW_KEY_EMODE : 603,
        PL_TVMW_KEY_DATA : 604,
        PL_TVMW_KEY_DMA : 605,
        PL_TVMW_KEY_MENU : 607,
        PL_TVMW_KEY_PANNEL_SOURCE : 612,
        PL_TVMW_KEY_PANNEL_MENU : 613,
        PL_TVMW_KEY_TTX_MIX : 650,
        PL_TVMW_KEY_GUIDE : 651,
        PL_TVMW_KEY_SUBTITLE : 652,
        PL_TVMW_KEY_ASPECT : 653,
        PL_TVMW_KEY_DOLBY_SRR : 654,
        PL_TVMW_KEY_MTS : 655,
		PL_TVMW_KEY_REPEAT : 656,
		PL_TVMW_KEY_12 : 1057,
		PL_TVMW_KEY_DISC_MENU : 1086,
		PL_TVMW_KEY_GREEN : 401,
		PL_TVMW_KEY_CYAN : 403,		
		PL_TVMW_KEY_3D : 1219,
		PL_TVMW_KEY_PIP_ONOFF : 1032,
		PL_TVMW_KEY_AD : 1039,
		PL_TVMW_KEY_PMODE : 1040,
		PL_TVMW_KEY_SMODE : 1043,
		PL_TVMW_KEY_PIP_CHUP : 1050,
		PL_TVMW_KEY_PIP_CHDOWN : 1051,
		PL_TVMW_KEY_FF_ : 1078,
		PL_TVMW_KEY_REWIND_ : 1080,
		PL_TVMW_KEY_SUB_TITLE : 1089,
		PL_TVMW_KEY_SLEEP : 1097,
		PL_TVMW_KEY_D_AUDIO : 1236,
		PL_TVMW_KEY_D_VIEW_MODE : 1249,
		PL_TVMW_KEY_STEP : 1023,			// REC PAUSE(BD)
		PL_TVMW_KEY_CALLER_ID : 1128,		// FULL SCREEN TV SOURCE (BD)
		PL_TVMW_KEY_ZOOM1 : 1083,			// YAHOO, BestBuy
		PL_TVMW_KEY_ANTENA : 1054			// for CN
    }
	
	function checkInit(pEnumPlugin) {
		var bRetValue = false;
		switch(pEnumPlugin) {
			case Plugin.TVMW.nEnum : 
				if (Plugin.TVMW.Object) {
					bRetValue = true;
				}
				break;
			case Plugin.VIDEO.nEnum :
				if (Plugin.VIDEO.Object) {
					bRetValue = true;
				}
				break;
			case Plugin.NNAVI.nEnum :
				if (Plugin.NNAVI.Object) {
					bRetValue = true;
				}
				break;
			case Plugin.APPCOMMON.nEnum :
				if (Plugin.APPCOMMON.Object) {
					bRetValue = true;
				}
			default : 
				break;
		}
		if (!bRetValue) {
			bRetValue = init(pEnumPlugin);
		}
		return bRetValue;
	}
	
	function init(pEnumPlugin) {
		var bRetValue = true;
		switch(pEnumPlugin) {
			case Plugin.TVMW.nEnum : 
				Plugin.TVMW.Object = document.getElementById("pluginObjectTVMW");
				if (!Plugin.TVMW.Object) {
					bRetValue = false;
				} else {
					Plugin.TVMW.strVersion = Plugin.TVMW.Object.GetPluginInfo(PL_CMN_INFO_VERSION);
				}
				break;
			case Plugin.VIDEO.nEnum:
				Plugin.VIDEO.Object  = document.getElementById("pluginObjectVideo");
				if (!Plugin.VIDEO.Object) {
					bRetValue = false;
				} else {
					Plugin.VIDEO.strVersion = Plugin.VIDEO.Object.GetPluginInfo(PL_CMN_INFO_VERSION);
				}
				break;
			case Plugin.NNAVI.nEnum:
				Plugin.NNAVI.Object  = document.getElementById("pluginObjectNNavi");
				if (!Plugin.NNAVI.Object) {
					bRetValue = false;
				} else {
					Plugin.NNAVI.strVersion = Plugin.NNAVI.Object.GetPluginInfo(PL_CMN_INFO_VERSION);
				}
				break;
			case Plugin.APPCOMMON.nEnum:
				Plugin.APPCOMMON.Object  = document.getElementById("pluginObjectAppCommon");
				if (!Plugin.APPCOMMON.Object) {
					bRetValue = false;
				} else {
					Plugin.APPCOMMON.strVersion = Plugin.APPCOMMON.Object.GetPluginInfo(PL_CMN_INFO_VERSION);
				}
				break;
			default : 
				break;
		}
		if (!bRetValue) {
			alert("Common.API.PlugIn >> Plugin is not embeded yet. Check out index.html", 0);
		}
		return bRetValue;
	}
    
    /**
     * @brief		Convert User Key Code to Plugin Key Code
     * @remarks	Convert User Key Code to Plugin Key Code
     */
    function convertUserKeyToPluginKey(pNumUserKey){
        var tNumPluginKey = 0;
        
        if (!widgetAPIKey) {
    		widgetAPIKey = new Common.API.TVKeyValue();
    	}
    	
        switch (pNumUserKey) {
            case widgetAPIKey.KEY_TOOLS:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_TOOLS;
                break;
            case widgetAPIKey.KEY_MUTE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_MUTE;
                break;
            case widgetAPIKey.KEY_RETURN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_RETURN;
                break;
            case widgetAPIKey.KEY_UP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_ARROW_UP;
                break;
            case widgetAPIKey.KEY_DOWN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_ARROW_DOWN;
                break;
            case widgetAPIKey.KEY_LEFT:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_ARROW_LEFT;
                break;
            case widgetAPIKey.KEY_RIGHT:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_ARROW_RIGHT;
                break;
            case widgetAPIKey.KEY_WHEELDOWN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_WHEEL_RIGHT;
                break;
            case widgetAPIKey.KEY_WHEELUP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_WHEEL_LEFT;
                break;
            case widgetAPIKey.KEY_ENTER:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_ENTER;
                break;
            case widgetAPIKey.KEY_INFO:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_INFO;
                break;
            case widgetAPIKey.KEY_EXIT:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_EXIT;
                break;
            case widgetAPIKey.KEY_RED:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_RED;
                break;
            case widgetAPIKey.KEY_GREEN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_GREEN;
                break;
            case widgetAPIKey.KEY_YELLOW:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_YELLOW;
                break;
            case widgetAPIKey.KEY_BLUE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CYAN;
                break;
            case widgetAPIKey.KEY_INFOLINK:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_INFOLINK;
                break;
            case widgetAPIKey.KEY_RW:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_REWARD;
                break;
            case widgetAPIKey.KEY_PAUSE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PAUSE;
                break;
            case widgetAPIKey.KEY_FF:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_FOWARD;
                break;
            case widgetAPIKey.KEY_PLAY:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PLAY;
                break;
            case widgetAPIKey.KEY_STOP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_STOP;
                break;
            case widgetAPIKey.KEY_1:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_1;
                break;
            case widgetAPIKey.KEY_2:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_2;
                break;
            case widgetAPIKey.KEY_3:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_3;
                break;
            case widgetAPIKey.KEY_4:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_4;
                break;
            case widgetAPIKey.KEY_5:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_5;
                break;
            case widgetAPIKey.KEY_6:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_6;
                break;
            case widgetAPIKey.KEY_7:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_7;
                break;
            case widgetAPIKey.KEY_8:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_8;
                break;
            case widgetAPIKey.KEY_9:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_9;
                break;
            case widgetAPIKey.KEY_0:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_0;
                break;
            case widgetAPIKey.KEY_EMPTY:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_HYPHEN;
                break;
            case widgetAPIKey.KEY_PRECH:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CH_PREV;
                break;
            case widgetAPIKey.KEY_SOURCE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_SOURCE;
                break;
            case widgetAPIKey.KEY_CHLIST:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CH_LIST;
                break;
            case widgetAPIKey.KEY_MENU:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_MENU;
                break;
            case widgetAPIKey.KEY_WLINK:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_WISELINK;
                break;
            case widgetAPIKey.KEY_CC:
                tNumPluginKey = 1;
                break;
            case widgetAPIKey.KEY_CONTENT:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CONTENTS;
                break;
            case widgetAPIKey.KEY_FAVCH:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CH_FAV;
                break;
            case widgetAPIKey.KEY_REC:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_REC;
                break;
            case widgetAPIKey.KEY_EMODE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_EMODE;
                break;
            case widgetAPIKey.KEY_DMA:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_DMA;
                break;
            case widgetAPIKey.KEY_PANEL_CH_UP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CH_PANNEL_UP;
                break;
            case widgetAPIKey.KEY_PANEL_CH_DOWN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CH_PANNEL_DOWN;
                break;
            case widgetAPIKey.KEY_PANEL_VOL_UP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_VOL_PANNEL_UP;
                break;
            case widgetAPIKey.KEY_PANEL_VOL_DOWN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_VOL_PANNEL_DOWN;
                break;
            case widgetAPIKey.KEY_PANEL_ENTER:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PANNEL_ENTER;
                break;
            case widgetAPIKey.KEY_PANEL_SOURCE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PANNEL_SOURCE;
                break;
            case widgetAPIKey.KEY_PANEL_MENU:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PANNEL_MENU;
                break;
            case widgetAPIKey.KEY_PANEL_POWER:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PANNEL_POWER;
                break;
    		case widgetAPIKey.KEY_TTX_MIX:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_TTX_MIX;
                break;	
    		case widgetAPIKey.KEY_GUIDE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_GUIDE;
                break;		
    		case widgetAPIKey.KEY_SUBTITLE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_SUBTITLE;
                break;	
    		case widgetAPIKey.KEY_SUB_TITLE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_SUB_TITLE;
                break;
    		case widgetAPIKey.KEY_ASPECT:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_ASPECT;
                break;	
    		case widgetAPIKey.KEY_DOLBY_SRR:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_DOLBY_SRR;
                break;	
    		case widgetAPIKey.KEY_MTS:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_MTS;
                break;		
    		case widgetAPIKey.KEY_POWER:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_POWER;
                break;		
    		case widgetAPIKey.KEY_VOL_UP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_VOL_UP;
                break;	
    		case widgetAPIKey.KEY_VOL_DOWN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_VOL_DOWN;
                break;	
    		case widgetAPIKey.KEY_12:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_12;
                break;		
    		case widgetAPIKey.KEY_DISC_MENU:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_DISC_MENU;
                break;	
    		case widgetAPIKey.KEY_TTX_MIX:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_TTX_MIX;
                break;	
    		case widgetAPIKey.KEY_3D:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_3D;
                break;
    		case widgetAPIKey.KEY_PIP_ONOFF:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PIP_ONOFF;
                break;
    		case widgetAPIKey.KEY_AD:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_AD;
                break;
    		case widgetAPIKey.KEY_PMODE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PMODE;
                break;
    		case widgetAPIKey.KEY_SMODE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_SMODE;
                break;
    		case widgetAPIKey.KEY_PIP_CHUP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PIP_CHUP;
                break;
    		case widgetAPIKey.KEY_PIP_CHDOWN:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_PIP_CHDOWN;
                break;																				
    		case widgetAPIKey.KEY_D_AUDIO:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_D_AUDIO;
                break;	
    		case widgetAPIKey.KEY_D_VIEW_MODE:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_D_VIEW_MODE;
                break;					
    		case widgetAPIKey.KEY_FF_:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_FF_;
                break;	
    		case widgetAPIKey.KEY_REWIND_:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_REWIND_;
                break;					
    		case widgetAPIKey.KEY_SLEEP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_SLEEP;
                break;
    		case widgetAPIKey.KEY_STEP:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_STEP;
                break;
    		case widgetAPIKey.KEY_CALLER_ID:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_CALLER_ID;
                break;				
    		case widgetAPIKey.KEY_ZOOM1:
                tNumPluginKey = KeyValue.PL_TVMW_KEY_ZOOM1;
                break;	
            default:
    			tNumPluginKey = -1;
                break;
        }
        return tNumPluginKey;
    }    
	
    //=============================================
    // TVMW 플러그인 : Watch Dog
    //=============================================
    /**
     * @brief             WatchDog 기능을 On 한다.
     * @remarks       WatchDog 기능을 On 한다.
     */
    this.setOnWatchDog = function(){
		if (!checkInit(Plugin.TVMW.nEnum)) return;
        alert("Common.API.PlugIn >> setOnWatchDog");
        if (!bWatchDog) {
            Plugin.TVMW.Object.SetWatchDog(PLR_FALSE);
        }
        bWatchDog = true;
    }
    
    /**
     * @brief             WatchDog 기능을 Off 한다.
     * @remarks       WatchDog 기능을 Off 한다.
     */
    this.setOffWatchDog = function(){
		if (!checkInit(Plugin.TVMW.nEnum)) return;
        alert("Common.API.PlugIn >> setOffWatchDog");
        if (bWatchDog) {
            Plugin.TVMW.Object.SetWatchDog(PLR_TRUE);
        }
        bWatchDog = false;
    }

    //=============================================
    // TVMW 플러그인 : Key 등록/해제
    //=============================================
    /**
     * @brief            Regist Key
     * @remarks       Let the widget manager regist specific key
     */    
	this.registKey = function(pNumKeyCode) {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
        var tNumKeyCode = convertUserKeyToPluginKey(pNumKeyCode);

    	if (tNumKeyCode != -1) {
    		Plugin.TVMW.Object.RegisterKey(tNumKeyCode);
    		alert("Common.API.PlugIn[REGIST KEY] >> Regist Key : " + tNumKeyCode);
			
    	} else {
    		alert("Common.API.PlugIn[REGIST KEY] >> Invalid Key code : " + tNumKeyCode);
    	}
        
	}
	
    /**
     * @brief            Unregist Key
     * @remarks       Let the widget manager unregist specific key
     */    
	this.unregistKey = function(pNumKeyCode) {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
        var tNumKeyCode = convertUserKeyToPluginKey(pNumKeyCode);
    	if (tNumKeyCode != -1) {
    		Plugin.TVMW.Object.UnregisterKey(tNumKeyCode);
    		alert("Common.API.PlugIn[UNREGIST KEY] >> Unregister Key : " + tNumKeyCode);
    	} else {
    		alert("Common.API.PlugIn[UNREGIST KEY] >> Invalid Key code : " + tNumKeyCode);
    	}
	}

    /**
     * @brief            Regist IME Key
     * @remarks       Let the widget manager regist IME key
     */    
	this.registIMEKey = function() {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
    	Plugin.TVMW.Object.RegisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_NUMBER);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_HYPHEN);	
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_CH_PREV);
		Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_12);
		Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_DISC_MENU);
		Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_TTX_MIX);
		Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_GREEN);
		Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_CYAN);		// BLUE
		Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_TOOLS);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_D_AUDIO);		
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_D_VIEW_MODE);		
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_SUBTITLE);		
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_SUB_TITLE);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_REPEAT);		
        alert("Common.API.PlugIn[REGIST IME KEY] >> Register IME Key");
	}

    /**
     * @brief            Regist IME Key
     * @remarks       Let the widget manager regist IME key
     */    
	this.unregistIMEKey = function() {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
    	Plugin.TVMW.Object.UnregisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_NUMBER);
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_HYPHEN);	
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_CH_PREV);
		Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_12);
		Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_DISC_MENU);
		Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_TTX_MIX);
//		Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_GREEN);
//		Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_CYAN);	// BLUE
//		Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_TOOLS);
//    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_D_AUDIO);		
//    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_D_VIEW_MODE);		
//    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_SUBTITLE);		
//    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_SUB_TITLE);
//    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_REPEAT);
        alert("Common.API.PlugIn[UNREGIST IME KEY] >> Unregister IME Key");
	}

    /**
     * @brief            
     * @remarks       
     */    
	this.registAllKey = function() {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
    	Plugin.TVMW.Object.RegisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_ALL);
        alert("Common.API.PlugIn[REGIST ALL KEY] >> Register ALL Key");
	}

    /**
     * @brief            
     * @remarks       
     */    
	this.unregistAllKey = function() {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
    	Plugin.TVMW.Object.UnregisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_ALL);
        alert("Common.API.PlugIn[UNREGIST ALL KEY] >> Unregister ALL Key");
	}

    /**
     * @brief            
     * @remarks       
     */    
	this.registFullWidgetKey = function() {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
        //Register Manager Key
        $THIS$.registManagerWidgetKey();
        
        //Register Normal Key
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_VOL_UP);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_VOL_DOWN);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_MUTE);
    	
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_TOOLS);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_INFO);
    	
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_EMODE);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_DMA);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_MENU);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_CH_PREV);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_CH_FAV);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_CH_LIST);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_DATA);
    		
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_DMA);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_TTX_MIX);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_GUIDE);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_ASPECT);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_DOLBY_SRR);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_MTS);

        $THIS$.registIMEKey();
        alert("Common.API.PlugIn[REGIST FULL WIDGET KEY] >> Register FULL WIDGET Key");
	}

    /**
     * @brief            
     * @remarks       
     */
	this.registPartWidgetKey = function() {
        if (!checkInit(Plugin.TVMW.nEnum)) return;
        //Register Manager Key
        $THIS$.registManagerWidgetKey();
        
        //Register Part Key
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_ENTER);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_RETURN);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_INFOLINK);
    
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_CH_PANNEL_UP);
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_CH_PANNEL_DOWN);
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_VOL_PANNEL_UP);
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_VOL_PANNEL_DOWN);
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_PANNEL_SOURCE);
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_PANNEL_MENU);
    	Plugin.TVMW.Object.UnregisterKey(KeyValue.PL_TVMW_KEY_PANNEL_ENTER);

        alert("Common.API.PlugIn[REGIST PART WIDGET KEY] >> Register PART WIDGET Key");
	}

    /**
     * @brief            
     * @remarks       
     */
	this.registManagerWidgetKey = function() {
    	Plugin.TVMW.Object.UnregisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_ALL);
    	
    	Plugin.TVMW.Object.RegisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_PLAYBACK);
    	Plugin.TVMW.Object.RegisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_NAVI);
    	Plugin.TVMW.Object.RegisterKeyGroup(KeyValue.PL_TVMW_KEY_GRP_COLOR);
    	
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_ENTER);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_RETURN);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_INFOLINK);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_EXIT);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_WHEEL_LEFT);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_WHEEL_RIGHT);
    
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_CH_PANNEL_UP);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_CH_PANNEL_DOWN);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_VOL_PANNEL_UP);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_VOL_PANNEL_DOWN);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_PANNEL_SOURCE);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_PANNEL_MENU);
    	Plugin.TVMW.Object.RegisterKey(KeyValue.PL_TVMW_KEY_PANNEL_ENTER);
    }
	
    //=============================================
    // VIDEO 플러그인 : FRC 관련
    //=============================================
    /**
     * @brief			Set OSDState On
     * @remarks		Set OSDState On
     */
	this.setOnOSDState = function(left, top, width, height){
		if (!checkInit(Plugin.VIDEO.nEnum)) return;
        if (Plugin.VIDEO.strVersion > "VIDEO-0002") {
            var handlerKeyword = "$" + left + top + width + height + "$";
            if (this.SetOSDStateHandler.check(handlerKeyword, PLR_TRUE)) {
                var nHandler = this.SetOSDStateHandler.getHandler(handlerKeyword);
				alert("Common.API.PlugIn >> setOnOSDState - nHandler : " + nHandler + ", SetOSDState : " + left + ", " + top + ", " + width + ", " + height);
                Plugin.VIDEO.Object.SetOSDState(nHandler, left, top, width, height, PLR_TRUE);
            }
        } else if (Plugin.VIDEO.strVersion == "VIDEO-0002"){
			$PLUGIN$.SetOSDState(left, top, width, height, option);
		}
    }
	
    /**
     * @brief			Set OSDState Off
     * @remarks		Set OSDState Off
     */
	this.setOffOSDState = function(left, top, width, height){
		if (!checkInit(Plugin.VIDEO.nEnum)) return;
        if (Plugin.VIDEO.strVersion > "VIDEO-0002") {
            var handlerKeyword = "$" + left + top + width + height + "$";
            if (this.SetOSDStateHandler.check(handlerKeyword, PLR_FALSE)) {
				var nHandler = this.SetOSDStateHandler.getHandler(handlerKeyword);
				alert("Common.API.PlugIn >> setOffOSDState - nHandler : " + nHandler + ", SetOSDState : " + left + ", " + top + ", " + width + ", " + height);
				Plugin.VIDEO.Object.SetOSDState(nHandler, left, top, width, height, PLR_FALSE);
				this.SetOSDStateHandler.removeHandler(handlerKeyword);
			}
        } else if (Plugin.VIDEO.strVersion == "VIDEO-0002"){
			$PLUGIN$.SetOSDState(left, top, width, height, PLR_FALSE);
		}
    }

    /**
     * @brief			SetOSDStateHandler
     * @remarks
     */
    this.SetOSDStateHandler = {
        handlerPool : new Array(1,2,3,4,5,6,7,8,10,11,12,13,14,15,16,17,18,19,20),
        pool: new Object(),

	    /**
	     * @brief			SetOSDStateHandler
	     * @remarks
	     */
        getHandler: function(keywordHandler){
            var retHandler = this.pool[keywordHandler];
            if (retHandler != null) {
                return retHandler;
            }
            else {
                return 0;
            }
        },

	    /**
	     * @brief			SetOSDStateHandler
	     * @remarks
	     */
		removeHandler : function(keywordHandler) {
			var handlerItem = this.pool[keywordHandler];
			this.handlerPool.push(handlerItem);
			delete this.pool[keywordHandler];
		},
		
	    /**
	     * @brief			SetOSDStateHandler
	     * @remarks
	     */
        check: function(keywordHandler, option){
			var bRetValue = null;
            switch (option) {
                case PLR_TRUE:
					var handlerValue = this.handlerPool.pop();
                    if (this.pool[keywordHandler] == null) {
						// Error handling for no handler pool
                        this.pool[keywordHandler] = (handlerValue != null) ? handlerValue : 0;
                        bRetValue = true;
                    }
                    else bRetValue = false;
                     break;
                case PLR_FALSE:
                    if (this.pool[keywordHandler] == null) 
						bRetValue = false;
                    else 
						bRetValue = true;
                    break;
				default :
					alert("SetOSDStateHandler > option is invalid");
					bRetValue = false;
					break;
            }
			return bRetValue;
        }
    }

	// 위젯에서 화면설정 변경이 가능한 Tool 화면 보여주기
    this.ShowTools = function( pSetting ){
		if (!checkInit(Plugin.NNAVI.nEnum)) return;
		
        if (Plugin.NNAVI.strVersion > "NNAVI-0004") {
			// 돌아갈 위젯 ID 저장
	        var type = Common.API.EVENT_RETURN_WIDGETID;
			var data = curWidget.id;
			var widgetEvent = new WidgetEvent(type, data);
			sendWidgetEvent("", widgetEvent, false);		// async call
			
			Plugin.NNAVI.Object.ActivateWithData(PL_DTVAPP_TOOL, pSetting );
		}
		else{
			alert("invalid nnavi plugin version : "+ Plugin.NNAVI.strVersion );
		}
	}

	// 위젯에서 화면설정 변경이 가능한 Tool 화면 숨기기
    this.HideTools = function(){
		alert("Common.API.Plugin.HideTools() id: "+curWidget.id );

		if (!checkInit(Plugin.NNAVI.nEnum)) return;
		
        if (Plugin.NNAVI.strVersion > "NNAVI-0003") {
			// SendEventToDevice 는 2개의 인자를 가져야 함. 2nd 파리미터 의미없음.
			Plugin.NNAVI.Object.SendEventToDevice( EVENT_TO_DEVICE_HIDE_TOOLS, 0 );
		}
		else{
			alert("invalid nnavi plugin version : "+ Plugin.NNAVI.strVersion );
		}
	}
		
	// Vol, Mute, Channel 배너 상태 결정
    this.SetBannerState = function( pState ){
		if (!checkInit(Plugin.NNAVI.nEnum)) return;
		
        if (Plugin.NNAVI.strVersion > "NNAVI-0003") {
			Plugin.NNAVI.Object.SetBannerState( pState );
		}
		else{
			alert("invalid nnavi plugin version : "+ Plugin.NNAVI.strVersion );
		}
	}
	
	// Netflix 등 장시간 video play 가 가능한 위젯 지원
	this.setOnIdleEvent = function(){
		alert("Common.API.Plugin.setOnIdleEvent()" );
					
			// idleEvent 설정
	        var type = Common.API.EVENT_IDLE_ON;
			var data = curWidget.id;
			var widgetEvent = new WidgetEvent(type, data);
			sendWidgetEvent("", widgetEvent, false);		// async call. NFLX onLoad 시 show와 함께 block 문제 발생
    }
	
	this.setOffIdleEvent = function(){
		alert("Common.API.Plugin.setOffIdleEvent() id: "+curWidget.id );

			// idleEvent 해제
	        var type = Common.API.EVENT_IDLE_OFF;
			var data = curWidget.id;
			var widgetEvent = new WidgetEvent(type, data);
			sendWidgetEvent("", widgetEvent, false);		// async call. NFLX 종료시 hide와 함께 block 문제 발생
    }	

	this.setOnScreenSaver = function(pSecond){
		alert("Common.API.Plugin.setOnScreenSaver() id: "+curWidget.id );

		if (!checkInit(Plugin.NNAVI.nEnum)) return;
        if (!checkInit(Plugin.TVMW.nEnum)) return;

        if (Plugin.NNAVI.strVersion > "NNAVI-0003") {

			// 위젯에서 시간을 넘겨주지 않은 경우
			if (pSecond == null || pSecond == undefined) {

				// 프로파일  확인
		    	var tmpIdx = Plugin.TVMW.Object.GetProfile(PL_PRFID_AUTO_PROTECTION_TIME);
				var tmpTime = 0 ;
			
				switch(parseInt(tmpIdx)) {
					case 0 : //PROFILE_DURATION_10MIN : 
						tmpTime = 10 * 60;
						break;
					case 1 : //PROFILE_DURATION_20MIN : 
						tmpTime = 20 * 60;
						break;
					case 2 : //PROFILE_DURATION_40MIN : 
						tmpTime = 40 * 60;
						break;
					case 3 : //PROFILE_DURATION_1HOUR : 
						tmpTime = 1 * 60 * 60;
						break;
					case 4 : //PROFILE_DURATION_2HOUR : 
						tmpTime = 2 * 60 * 60;
						break;
					case 5 : //PROFILE_DURATION_4HOUR : 
						tmpTime = 4 * 60 * 60;
						break;
					case 6 : //PROFILE_DURATION_8HOUR : 
						tmpTime = 8 * 60 * 60;
						break;
					case 7 : //PROFILE_DURATION_10HOUR : 
						tmpTime = 10 * 60 * 60;
						break;
					case 8 : //PROFILE_DURATION_ALWAYS : 
						// do nothing
						alert( "PROFILE_DURATION_ALWAYS is set. do nothing..");
						return;
					default : 
						tmpTime = 1 * 60 * 60;
						break;
				}
				pSecond = tmpTime ;
			}
			alert( "screen saver time(sec) : "+ pSecond );
			
			Plugin.NNAVI.Object.SendEventToDevice( EVENT_TO_DEVICE_SCREEN_SAVER_ON, pSecond);
		}
		else{
			alert("invalid nnavi plugin version : "+ Plugin.NNAVI.strVersion );
		}
    }
	
	this.setOffScreenSaver = function(){
		alert("Common.API.Plugin.setOffScreenSaver() id: "+curWidget.id );

		if (!checkInit(Plugin.NNAVI.nEnum)) return;
		
        if (Plugin.NNAVI.strVersion > "NNAVI-0003") {
			// SendEventToDevice 는 2개의 인자를 가져야 함. 2nd 파리미터 의미없음.
			Plugin.NNAVI.Object.SendEventToDevice( EVENT_TO_DEVICE_SCREEN_SAVER_OFF, 0 );
		}
		else{
			alert("invalid nnavi plugin version : "+ Plugin.NNAVI.strVersion );
		}
    }

	/**
	  * @brief			isViewerKey
	  * @remarks		If pressed key is for TV Viewer, send key code to TV Viewer. If not, return false
	*/
	this.isViewerKey = function(pKeyCode) {
		alert("Common.API.Plugin.isViewerKey() id: "+curWidget.id );
		
		if (!checkInit(Plugin.APPCOMMON.nEnum)) return;
		
		var retValue = false;
		
		// If remocon key map is not match with APPCOMMON key map(ex: PL_APPCOMMON_KEY_JOYSTICK_OK)
		// Mapping table or function is needed
		if (Plugin.APPCOMMON.strVersion > 'APPCOMMON-0009' && 1 == Plugin.APPCOMMON.Object.CheckReservedKey(pKeyCode)) {
			Plugin.APPCOMMON.Object.SendKeyToTVViewer(pKeyCode);
			retValue = true;
		}
		return retValue;
	}
}
