﻿var cMenuList = {
	arrCategoryList : null,
	URL: null,
	XHRTool: null,
	
	currentIndex:null,
	lastIndex:null,
	maxIndex:null
}


cMenuList.create = function() {
	arrCategoryList = new Array;
	URL = Define.BASE_URL;
	currentIndex = 0;
	maxIndex = 8;
	
	cMenuList.XHRTool = new XHRToolKit(URL, function (result) {
        cMenuList.onReceiveData(result);
    });
	
	$( 'videoListLoad' ).class = '';
}


cMenuList.start = function() { 
	cMenuList.XHRTool.sendXHRRequest();
	Define.wait_flag = true;
}


cMenuList.onReceiveData = function(bSuccess) {
	if (bSuccess) {
		var responseXML = cMenuList.XHRTool.getResponseXML();
		var responseDoc = responseXML.documentElement;
		
		if (responseDoc) {
			var itemElements = responseDoc.getElementsByTagName("submenu");
			if ( itemElements && itemElements.length > 0 ) { // more than 1 article
				for ( var i = 0; i < itemElements.length; i++ ) {
					if ( cMenuList.isValidNormalArticle( itemElements[i] ) ) {
						var tName = itemElements[i].getAttribute("name");//.toString();
						var tLink = itemElements[i].getAttribute("link");//.toString();
						var tLevel = itemElements[i].getAttribute("level");//.toString();
						
						//alert( tName + " " + tLink + " " + tLevel );
						arrCategoryList[arrCategoryList.length] = new Category( tName, tLink, tLevel );
					}
				}
			}
		}
		cMenuList.initView();
		Define.wait_flag = false;
		$( 'main' ).class = '';
		
		//load channels at the start;
		cMenuList.setIndex();
		$( 'videoListLoad' ).class = 'hidden';
	} else {
		//exit... cant connect to server;
		Define.wait_flag = false;
		alertNew( Define.ERROR0, Define.ERROR1, 'exit' );
	}
}


cMenuList.isValidNormalArticle = function (itemElement) {
	if ( itemElement.getAttribute("name") && itemElement.getAttribute("link") && itemElement.getAttribute("level") ) {
		return true;
	}
	return false;
}


cMenuList.initView = function() {
	for( var i = 0; i < 8; i++ ){
		var tempIndex = $( "menu" + i.toString() );
		
		if ( i < arrCategoryList.length ) {
			widgetAPI.putInnerHTML( tempIndex, arrCategoryList[ i ].text );
			
			if ( i == currentIndex ) $( "menu" + i.toString() ).style.backgroundImage = "url(image/selectMenu.png)";
			else $( "menu" + i.toString() ).style.backgroundImage = "url(image/unselectMenu.png)";
		} else {
			tempIndex.innerText = "";
			$( "menu" + i.toString() ).style.backgroundImage = "url(none)";
		}
		
	}
}

////////////////////////////////////////////////

cMenuList.upIndex = function() {
	if ( currentIndex > 0 ) {
		currentIndex--;
		cMenuList.initView();
	}
}


cMenuList.downIndex = function() {
	if ( currentIndex < arrCategoryList.length - 1 ) {
		currentIndex++;
		cMenuList.initView();
	}
}


cMenuList.setIndex = function() {
	//$( 'path' ).innerText = arrCategoryList[ currentIndex ].text;
	widgetAPI.putInnerHTML( $( 'path' ), arrCategoryList[ currentIndex ].text );
	
	cVideoList.create( arrCategoryList[ currentIndex ].link, 0, 0 );
	cKeyHandler.focusToVideoList();
	
	lastIndex = currentIndex;
	currentIndex = -1;
	cMenuList.initView();
}