﻿var Search = {
	returnTo: '',
	
	lastKey: -1,
	keyOption: 0,
	searchValue: '',
	
	timerFlag: false,
	
	
	myTimer: null,
	keyArray: null
}

Search.init = function(){
	Search.toggleButtons();
	Search.searchValue = 'поиск';
	widgetAPI.putInnerHTML( $('inputText'), Search.searchValue );
}


Search.start = function( returnTo ){
	Search.returnTo = returnTo;
	cKeyHandler.focusToSearch();
	
	$('search').class = '';
}


Search.goBack = function() {
	$('search').className = 'hidden';
	
	if ( Search.returnTo == 'menu' ) {
		cKeyHandler.focusToMenuList();
	} else {
		cKeyHandler.focusToVideoList();
	}
}



Search.pressKey = function( key ) {
	Search.timerFlag  = false;
	
	if ( key == 0 ) {//delete
		if ( Search.searchValue.length ) Search.searchValue = Search.searchValue.substr( 0, Search.searchValue.length - 1 )
		
		Search.lastKey = -1;
	} else if ( key == Search.lastKey && Search.lastKey != -1 ) {//same button - change last symbol
		Search.keyOption = ( Search.keyOption + 1 >= Search.keyArray[ Search.lastKey - 1 ].length ? 0 : Search.keyOption + 1 );
		Search.searchValue = Search.searchValue.substr( 0, Search.searchValue.length - 1 ) + Search.keyArray[ Search.lastKey - 1 ].charAt( Search.keyOption );
		
		Search.restartTimer();
	} else {//new button
		Search.lastKey = key;
		Search.keyOption = 0;
		if ( Search.searchValue.length < 18 ) Search.searchValue += Search.keyArray[ Search.lastKey - 1 ].charAt( Search.keyOption );
		
		Search.restartTimer();
	}
	
	widgetAPI.putInnerHTML( $('inputText'), Search.searchValue );
	
	Search.toggleButtons();
}


Search.restartTimer = function() {
	myTimer = setTimeout( "Search.stopTimer()", Define.INPUT_TIME_OUT );
	Search.timerFlag = true;
}

Search.stopTimer = function() {
	if ( Search.timerFlag  ) {
		Search.lastKey = -1;
		Search.keyOption = 0;
		Search.timerFlag  = false;
		Search.toggleButtons();
	}
}


Search.toggleButtons = function() {
	for ( var i = 0; i < 10; i++ ) {
		$( 'sBut' + i ).style.backgroundImage = "url( image/btn_" + i + ( i == Search.lastKey ? "_hlt" : "" ) + ".png)";
	}
}


Search.startSearch = function() {
	if ( Search.searchValue.length == 0 ) return;
	
	//http://samsung.rutv.ru/episode/search/query/КАРМЕЛИТА/page/1/perpage/10
	var URL = Define.BASE_URL + '/episode/search/query/' + encodeURI(Search.searchValue);
	
	cVideoList.create( URL, 0, 0 );
	cKeyHandler.focusToVideoList();
	$( 'search' ).class = 'hidden';
	
	//alert( "startSearchURL: " + URL );
}


Search.keyArray = [ " ", "абвг", "дежз", "ийкл", "мноп", "рсту", "фхцч", "шщъы", "ьэюя" ];
