var Main = {}

widgetAPI = new Common.API.Widget();
pluginAPI = new Common.API.Plugin();
tvKey = new Common.API.TVKeyValue();


loadTimeOut = null;
loadCount = 1;
returnTo = '';

srcArray = new Array([
	'image/selectVideo.png',
	'image/unselectVideo.png',
	'image/selectFolder.png',
	'image/unselectFolder.png'
	]);

Main.onUnload = function()
{
	Player.deinit();
	Audio.deinit();
}

Main.preloadImages = function() {
	imgArray = new Array;
	
	for ( var i = 0; i < srcArray.length; i++ ) {
		imgArray[i] = new Image;
		imgArray[i].src = srcArray[i];
	}
}

Main.loading = function() {
	loadCount = ( loadCount + 1 ) % 16 + 1;
	$( "videoListLoad" ).style.backgroundImage = "url(image/load/loading_" + loadCount + ".png)";
	
	loadTimeOut = setTimeout( "Main.loading()", 500 );
}

Main.onLoad = function()
{
	loadTimeOut = setTimeout( "Main.loading()", 500 );
	
	Main.preloadImages();
	
	cKeyHandler.create();
	cMenuList.create();
	
	Player.init();
	Audio.init();
	Search.init();
	
	
	window.onShow = Main.onShow();
	initPreload();
	
	
	widgetAPI.sendReadyEvent();
}

Main.onShow = function()
{
	cKeyHandler.focusToMenuList();
	cMenuList.start();
	
	Main.initKeys();
}

Main.initKeys = function()
{
	//get Nav plugin
	var NNaviPlugin = $( 'pluginObjectNNavi' );
	
	pluginAPI.SetBannerState(1);
	NNaviPlugin.SetBannerState(2);
	// For volume OSD
	pluginAPI.unregistKey(tvKey.KEY_VOL_UP);
	pluginAPI.unregistKey(tvKey.KEY_VOL_DOWN);
	pluginAPI.unregistKey(tvKey.KEY_MUTE);
	
	pluginAPI.unregistKey(262); //unregister MENU key
	pluginAPI.unregistKey(147); //unregister INFO.L key
	pluginAPI.unregistKey(222); //unregister KEY_SOURCE key
	
	pluginAPI.unregistKey( tvKey.KEY_EXIT );  //unregister EXIT key
	pluginAPI.unregistKey( tvKey.KEY_RETURN );  //unregister RETURN key
}


alertNew = function( title, txt, _returnTo ) {
	cKeyHandler.focusToError();
	
	widgetAPI.putInnerHTML( $('error_title'), title );
	widgetAPI.putInnerHTML( $('error_txt'), txt );
	
	returnTo = _returnTo;
	$( 'error' ).class = '';
}




imagesList = new Array;

pushImage = function( imgUrl ) {
	for ( var i = 0; i < imagesList.length; i++ ) {
		if ( imagesList[i].src == imgUrl ) return;
	}
	
	var tempImg = new Image();
	tempImg.src = imgUrl;
	imagesList.push( tempImg );
}

preloadList = new Array( 
						"image/audio/volume_0.png",
						"image/audio/volume_1.png",
						"image/audio/volume_2.png",
						"image/audio/volume_3.png",
						"image/audio/volume_4.png",
						"image/audio/volume_5.png",
						"image/audio/volume_6.png",
						"image/audio/volume_7.png",
						"image/audio/volume_8.png",
						"image/audio/volume_9.png",
						"image/audio/volume_10.png"
						); 

initPreload = function() {
	 for ( var i = 0; i < preloadList.length; i++ ) {
	 	pushImage( preloadList[i] );
	 }
}
