﻿var Audio =
{
    plugin : null,
	
	hideTimer: null,
	changeVolumeCount: null,
	
	mute : 0,
	NMUTE : 0,
    YMUTE : 1
}

Audio.init = function()
{
    var success = true;
    
    Audio.plugin = $("pluginObjectAudio");
    
    if (!Audio.plugin)
    {
        success = false;
    }

    Audio.changeVolumeCount = 0;
	
	if ( Audio.plugin.GetUserMute() ) {
		Audio.setMuteMode();
	} else {
		Audio.noMuteMode();
	}
	
	return success;
}

Audio.deinit = function() 
{
	if ( Audio.mute == Audio.NMUTE ) {
		Audio.plugin.SetSystemMute(false); 
		Audio.plugin.SetUserMute(false);
	} else {
		Audio.plugin.SetSystemMute(true); 
		Audio.plugin.SetUserMute(true);
	}
}



Audio.getVolume = function()
{
    return Audio.plugin.GetVolume();
}


Audio.setRelativeVolume = function(delta)
{
	Audio.plugin.SetVolumeWithKey(delta);
	Audio.noMuteMode();
	
	Audio.showVolume();
}

Audio.showVolume = function()
{
	Audio.changeVolumeCount++;
	Audio.hideTimer = null;
	
	var currentVolume = Audio.getVolume();
	var volumeIndex = Math.floor( currentVolume / 10 );
	//alert( '########################' + currentVolume + '###' + volumeIndex );
	
	var lstHtml = '';
	
	if ( Audio.mute != Audio.YMUTE ) {
		lstHtml += '<img id="audioImg" "src="image/audio/volume_' + volumeIndex + '.png">';
		lstHtml += '<div id="audioTxt">' + Audio.getVolume() + '</div>';
	} else {
		lstHtml += '<img id="audioImg" "src="image/audio/volume_12.png">';
		lstHtml += '<div id="audioTxt"></div>';
	}
	
	widgetAPI.putInnerHTML( $('audioData'), lstHtml );
	$( 'audioData' ).class = '';
	
	Audio.hideTimer = setTimeout( "Audio.hideData()", Define.TIME_OUT );
}


Audio.hideData = function() 
{
	Audio.changeVolumeCount--;
	if ( Audio.changeVolumeCount == 0 ) $( 'audioData' ).class = 'hidden';
}




Audio.setMuteMode = function()
{
	Audio.plugin.SetSystemMute(true);
	Audio.plugin.SetUserMute(true);
	Audio.mute = Audio.YMUTE;
	
	Audio.showVolume();
}

Audio.noMuteMode = function()
{
	Audio.plugin.SetSystemMute(false); 
    Audio.plugin.SetUserMute(false);
	Audio.mute = Audio.NMUTE;
	
	Audio.showVolume();
}

Audio.muteMode = function()
{
    switch (Audio.mute)
    {
        case Audio.NMUTE:
            Audio.setMuteMode();
            break;
            
        case Audio.YMUTE:
            Audio.noMuteMode();
            break;
            
        default:
            //alert("ERROR: unexpected mode in muteMode");
            break;
    }
}
