/**
 * @author EvgeniyV
 */

Updater = {};

/*Update Info xml*/
Updater.updateUrl = "http://www.rumote.com/plugins/samsung/2011/update.xml?1367113959" ;
Updater.changesUrl = "http://www.rumote.com/plugins/samsung/2011/changes.xml?1367113959";
Updater.manualUrl = "http://www.rumote.com/plugins/samsung/2011/manual.xml?1367113959";

/*Current version of App*/
Updater.currentVersion = "1.7";

Updater.updateAvailable = false;

/*
* Checks updates of App
*/
Updater.checkUpdate = function() {
    var cb = function(xml) {
		var versionNumber = 0;
		var upgradeUrl = "";
		var message = "";
			  
		$(xml).find('ViaMediaSamsung').each(function () {
			$(this).find('version').each(function () {
				versionNumber = $(this).text();
			});
			$(this).find('url').each(function () {
				upgradeUrl = $(this).text();
			});
			$(this).find('message').each(function () {
				message = $(this).text();
			});
		});    
					
		if (Updater.currentVersion != versionNumber) {
			Logger.write("[Updater] Update available", "Update");
			Updater.updateAvailable = true;
			SceneUpdatePopUp.active = true;
			Updater.message = message;
			if (AppContext.CurrentScene === "MainMenu") {
				SceneUpdatePopUp.show(message, "MainMenu");
			}
		}
    }
    
    var errCb = function() {
        Logger.write("[Updater] Error while checking update", "Update");
    }
    
    Helpers.loadXML(Updater.updateUrl, cb, errCb);
}

Updater.loadChangesList = function (completeCallback) {
	var cb = function (xml) {
		var versionNumber = 0;
		var changes = {};
			  
		$(xml).find('ViaMediaSamsung').each(function () {
			$(this).find('version').each(function () {
				versionNumber = $(this).text();
			});
			$(this).find('changes').each(function () {
				for (var i = 0; i < AppContext.Languages.length; i++) {
					var culture = AppContext.Languages[i].cultureInfo;
					$(this).find(culture).each(function () {
						changes[culture] = $(this).text();
					});
				}
			});
		});    
		
		Logger.write("changes: " + changes, "Update", true);
		if (Updater.currentVersion != versionNumber) {
			Logger.write("[Updater] Changes list available: " + changes.toSource(), "Update");
			completeCallback(changes);
		}
	};
	
	var errCb = function () {
        Logger.write("[Updater] Error while checking changes list", "Update");
    };
	
	Helpers.loadXML(Updater.changesUrl, cb, errCb);
}

Updater.loadManual = function (completeCallback) {
	var cb = function (xml) {
		var versionNumber = 0;
		var manual = {};
			  
		$(xml).find('ViaMediaSamsung').each(function () {
			$(this).find('version').each(function () {
				versionNumber = $(this).text();
			});
			$(this).find('manual').each(function () {
				for (var i = 0; i < AppContext.Languages.length; i++) {
					var culture = AppContext.Languages[i].cultureInfo;
					$(this).find(culture).each(function () {
						manual[culture] = $(this).text();
					});
				}
			});
		});    
		
		Logger.write("manual: " + manual, "Update", true);
		if (Updater.currentVersion != versionNumber) {
			Logger.write("[Updater] Manual available: " + manual.toSource(), "Update");
			completeCallback(manual);
		}
	};
	
	var errCb = function () {
        Logger.write("[Updater] Error while checking manual", "Update");
    };
	
	Helpers.loadXML(Updater.manualUrl, cb, errCb);
}