/**
 * @author VasiliyK
 */

var Resources = {
    resourcesData: null,
    currentLang: null,
    resourceUrl: "Resources/*.js"
}

/*
    Initializes resources
*/
Resources.initResources = function()
{
    Logger.write("Init resources", "Resources");
    getResources(AppContext.ClientSettings.Language.cultureInfo);
}

/*
    Gets resources for selected language
    
    *lang - language name
*/
Resources.getResources = function(lang)
{
    if (arguments.length == 0)
    {
        if (this.currentLang == null)
        {
            this.currentLang = AppContext.ClientSettings.Language.cultureInfo;
        }
        lang = this.currentLang;
    }
    
    //Logger.write("getting resources", "Resources");
    if (this.resourcesData == null || this.currentLang != lang)
    {
        var url = this.resourceUrl.replace(/\*/, lang);
        //Logger.write("URL:"+url, "Resources");
        this.resourcesData = $.parseJSON($.ajax(
        {
            type: "GET",
            url: url,
            dataType: "text",
            async: false,
        }).responseText);
        //Logger.write("result: "+this.resourcesData, "Resources");
        this.currentLang = lang;
    }
    
    return this.resourcesData;
}