/**
 * @author EvgeniyV
 */
 
Network = {};

/*
* Initializes network plugin
*/
Network.init = function() {
    networkPlugin = document.getElementById("pluginObjectNetwork");
    networkPlugin.CreatePlugin();
}

/*
* Types of device's network interfaces
*/
Network.interfacesTypes = {wireless:0, wired:1, noConnection:-1};

/*
* States of network connection
*/
Network.states = {ok:1, failure:0, error:-1};

/*
* Types of network check
*/
Network.checkTypes = {physicalConnection:0, gateway:1, http:2, dns:3};

/*
* Checks network state by level
*/
Network.checkByType = function(iType, checkType){
    var state = "";
    switch(checkType)
    {
        case Network.checkTypes.dns:
            state = networkPlugin.CheckDNS(iType);
            break;
        case Network.checkTypes.gateway:
            state = networkPlugin.CheckGateway(iType);
            break;
        case Network.checkTypes.physicalConnection:
            state = networkPlugin.CheckPhysicalConnection(iType);
            break;
        case Network.checkTypes.http:
            state = networkPlugin.CheckHTTP(iType);
            break;
    }    
    
    Logger.write("[Network] iType=" + iType + " | checkType=" + checkType + " | state=" + state, "Network");
    return state;
}   

/*
* Checks network state
*/
Network.check = function(){
        Network.activeType = networkPlugin.GetActiveType();
        
        for(key in Network.checkTypes)
        {
            var state = Network.checkByType(Network.activeType, Network.checkTypes[key]);
            if (state != Network.states.ok)
            {
                Network.handleError(Network.checkTypes[key], state);
                break;
            }
        }
        
     Logger.write("[Network] Check completed", "Network");
}

/*
* Handles network error
*/
Network.handleError = function(checkType, state){
    var errorMessage = "";
    switch(Network.activeType)
    {
        case Network.interfacesTypes.wired:
            errorMessage += "Wired Connection. ";
            break;
        case Network.interfacesTypes.wireless:
            errorMessage += "Wireless Connection. ";
            break;
        case Network.interfacesTypes.noConnection:
            return;
            break;
    }
    switch(checkType)
    {
        case Network.checkTypes.dns:
            errorMessage += "Check DNS ";
            break;
        case Network.checkTypes.gateway:
            errorMessage += "Check gateway ";
            break;
        case Network.checkTypes.physicalConnection:
            errorMessage += "Check physical connection ";
            break;
        case Network.checkTypes.http:
            errorMessage += "Check HTTP ";
            break;
    }        
    switch(state)
    {
        case Network.states.failure:
            errorMessage += "Failure. ";
            break;
        case Network.states.error:
            errorMessage += "Error. ";
            break;
    }
    
    if  (ScenePlayer.isPlaying == true)
    {
        ScenePlayer.stopAndReturn();
    }
    ErrorHandler.HandleError(errorMessage, AppContext.CurrentScene);
}