Models = {
}

Models.ContentGenre = function (genre, parent) {
	parent = parent || null;
	this.id = genre.id;
	this.name = genre.name;
	this.parent = parent;
	this.hasSubCategories = genre.childrenIDs.length > 0;
	this.subCategories = [];
}

Models.ContentGenresTree = function (genres, parent) {
	parent = parent || null;
	
	var parentId = parent != null ? parseInt(parent.id) : 0;

	var children = [];
	for (var i = 0; i < genres.length; i++) {
		if (parseInt(genres[i].parentID) == parentId) {
			var newGenre = new Models.ContentGenre(genres.splice(i--, 1)[0], parent);
			newGenre.subCategories = Models.ContentGenresTree(genres, newGenre);
			children.push(newGenre);
		}
	}
	
	return children;
}

Models.Category = function (id, name, hasSubCategories, parent, tag, displayOptions) {
	this.id = id;
	this.name = name;
	this.hasSubCategories = hasSubCategories;
	this.subCategories = hasSubCategories ? [] : null;
	this.parent = parent;
	this.tag = tag;
	this.displayOptions = displayOptions;
}

Models.ChannelCategory = function (channel) {
	this.id = parseInt(channel.id);
	this.name = channel.name;
	this.hasSubCategories = true;
	this.subCategories = [];
	this.parent = null;
	this.isChannel = true;
	this.advisory = channel.advisory;
	if (channel.arX && channel.arY) {
		this.ar = {
			x: channel.arX,
			y: channel.arY
		};
	}
	
	var self = this;
	this.updateSubCategoriesParent = function () {
		for (var i = 0; i < self.subCategories.length; i++) {
			self.subCategories[i].parent = self;
		}
	}
}

Models.CategoriesFromChannelsCollection = function (channels) {
	var outChannels = [];
	for (var i = 0; i < channels.length; i++) {
		outChannels[i] = new Models.ChannelCategory(channels[i]);
	}
	
	return outChannels;
}

Models.ArchPlusRequest = function (requestType, channelId, dateFrom, dateTill, genreId, keyWord, orderBy) {
	this.requestType = requestType;
	this.channelId = channelId;
	this.dateFrom = dateFrom ? new Date(dateFrom.getTime()) : null;
	this.dateTill = dateTill ? new Date(dateTill.getTime()) : null;
	this.genreId = genreId;
	this.keyWord = keyWord;
	this.orderBy = orderBy;
	
	this._getDateValue = function (date) {
		if (date) {
			return date.getTime();
		}
		
		return null;
	};
	
	this.equals = function (request) {
		if (!request) {
			return false;
		}
		return  this.requestType === request.requestType &&
				this.channelId === request.channelId &&
				this._getDateValue(this.dateFrom) == this._getDateValue(request.dateFrom) &&
				this._getDateValue(this.dateTill) == this._getDateValue(request.dateTill) &&
				this.genreId === request.genreId &&
				this.keyWord === request.keyWord &&
				this.orderBy === request.orderBy;
	}
}

Models.TimeZone = function (uglyTimeZone) {
	this.id = uglyTimeZone.id;
	this.name = uglyTimeZone.name;
	this.stream = uglyTimeZone.stream;
	this.userName = uglyTimeZone.userName;
	this.utcOffset = parseInt(uglyTimeZone.utcOffset);
	var fullName = "(UTC";
	if (this.utcOffset != 0) {
		fullName += " ";
		fullName += this.utcOffset > 0 ? "+" : "-";
		var utcOffset = Math.abs(this.utcOffset);
		fullName += Math.floor(utcOffset / 60) + ":";
		var minutes = utcOffset % 60;
		minutes = minutes < 10 ? "0" + minutes : minutes;
		fullName += minutes;
	}
	fullName += ") " + this.userName;
	this.fullName = fullName;
}

Models.TimeZonesFromCollection = function (uglyTimeZones) {
	if (!uglyTimeZones) {
		return;
	}
	
	var timeZones = [];
	for (var i = 0; i < uglyTimeZones.length; i++) {
		timeZones.push(new Models.TimeZone(uglyTimeZones[i]));
	}
	
	return timeZones;
}