/**
 * @author EvgeniyV
 */
 
Login = {};

Login.completeLogin = function (DUID, login, passwd, successCb, errCb) {
    var successLogin = function () {
		Logger.write("Login successful, DUID: " + DUID, "initjs", true);
        Login.getClientSettings(successCb, errCb);
    }
    
    try {
        Login.login(DUID, login, passwd, successLogin, errCb);
    } catch (error) {
        errCb();
    }
}

/*
    Try to login with selected login and password
    
    *login - user login
    *passwd - user password
    *DUID - device unique id
*/
Login.login = function (DUID, login, passwd, successCb, errCb) {
    Logger.write("=========1===========Login: " + login + "  Password: " + passwd, "Loginjs");

    var success = successCb || function(){};
    var err = errCb || function(){};
    var tmpLoginCallback = function (result) {
        try {
			if (result) {
			    AppContext.user.login = result[0].UserLogin[0].Text;
                AppContext.user.password = result[0].UserPassword[0].Text;
                AppContext.user.sid = result[0].sessionID[0].Text;
                AppContext.user.userSystemPassword = result[0].UserSystemPassword[0].Text;
                AppContext.user.siteId = 15;

				Logger.write("siteId: " + AppContext.user.siteId, "Login", true);
				if (AppContext.user.sid.length > 0) {
					success();
				} else {
					err(Resources.getResources().SceneLoginWrongLoginError);
				}
			} else {
				  err(Resources.getResources().SceneLoginLoginError)
			}
        } catch (error) {
			err(ErrorHandler.HandleError(error,"Login"));
        }
    }
    var errorCallback = function (jqXHR, textStatus, error) {
		err(ErrorHandler.HandleError(error, "Login", true, textStatus, jqXHR));  
		err(error, textStatus);
    }
    JsonServices.client.Login(AppContext.appName, DUID, login, passwd, tmpLoginCallback, errorCallback);
}
    
/*
    Gets clients settings from web service
*/
Login.getClientSettings = function (successCb, errCb) {
    var success = successCb || function(){};
    var err = errCb || function(){};
    
    var callbackIvs = function (result) {
		AppContext.ClientSettings.services = result.clientServices || [];
		AppContext.ClientSettings.shiftTimeZoneName = result.streamPreference.shiftTimeZoneName || "";
		AppContext.ClientSettings.bAId = result.streamPreference.balancingArea.id || "";
		AppContext.ClientSettings.cdnId = result.streamPreference.cdn.id || "";
		var qp = result.streamPreference.qualityPreset;
		for (var key in JsonServices.StreamQualityPreset) {
			if (qp == JsonServices.StreamQualityPreset[key]) {
				AppContext.ClientSettings.qualityPreset = key;
				break;
			}
		}
		AppContext.ClientSettings.timeZoneName = result.timeZoneName || ""; 
		
		var lang = false;
		Logger.write("Language: " + result.language, "Loginjs", true);
		for (var i = 0; i < AppContext.Languages.length; i++) {
			if(result.language == AppContext.Languages[i].id) {
				AppContext.ClientSettings.Language = AppContext.Languages[i];
				lang = true;
			}
		}
		if (!lang) {
			AppContext.ClientSettings.Language = AppContext.Languages[0];
		}
		Resources.getResources(AppContext.ClientSettings.Language.cultureInfo);
		
		JsonServices.media.MediaImageUrlTemplate(
			AppContext.user.siteId,
			function (result) {
				AppContext.ImageUrlTemplate = result;
				JsonServices.media.GetMediaZoneInfo(
					function (result) {
						var timeZones = Models.TimeZonesFromCollection(result);
						AppContext.loadTimeZones(timeZones);
						success();
						Updater.checkUpdate();
				}, errCallback);
			}, errCallback);
    }
    
    var errCallback = function (jqXHR, textStatus, error) {
		err(ErrorHandler.HandleError(error, "Login", true, textStatus, jqXHR));  
    }
    
    JsonServices.client.GetSettings(AppContext.user.sid, callbackIvs, errCallback);
}