/**
 * @author Samsung
 */
ErrorHandler={};

ErrorHandler.NeedToRefresh = {"LiveTv": false,"ArchTv":false, "ArchPlus": false, "FavMovies": false, "Movies2":false, "Radio": false,"Settings": false, "MainMenu": false, "Favorites": false};
/*
    Handles errors, that occurs in application
*/
ErrorHandler.HandleError = function (error, sender, isOnServer, textStatus, jqXHR, info) {
    var errorMessage = "";
    var isServerError = isOnServer||false;
    var backTo = sender;
    var info = info || false;
    if (isServerError) {
		if ((sender != "Login") && (sender.indexOf("Search") == -1)) {
			backTo = "MainMenu";
		}
		if (textStatus == "timeout") {
			errorMessage = Resources.getResources().TimeoutError;
		} else {
		    if (jqXHR.status == 401) {
				errorMessage = Resources.getResources().SceneLoginLoginError;
			} else {
				errorMessage = Resources.getResources().ServiceError;
				Logger.write("errorMessage=" + errorMessage,"ErrorHandler", true);
				if (typeof(error) != "undefined") {
					errorMessage += " " + Resources.getResources().Message + ": " + error.toString();
				}
			}
			Logger.write("errorMessage=" + errorMessage,"ErrorHandler", true);
		}
    } else {
		 errorMessage = Resources.getResources().AnErrorOccured;
		 if (typeof(error) != "undefined") {
			errorMessage += "&nbsp;" + Resources.getResources().Message + ": " + error.toString();
			Logger.write("error=" + error.toString(), "ErrorHandler");
			Logger.write("fileName=" + error.fileName, "ErrorHandler");
			Logger.write("lineNumber=" + error.lineNumber, "ErrorHandler");
			Logger.write("stack trace: " + error.stack, "ErrorHandler");
		 }            
    } 
    
    if (sender == "Login") {
            $("#SceneLogin #lblError").sfLabel({text: errorMessage});
            return;
    }
        
    if ((sender == "PopUp") || (AppContext.CurrentScene == "PopUp")) {
            ScenePopUp.close();
            backTo = ScenePopUp.sender;
    }
    
	var prevState = ErrorHandler.NeedToRefresh[sender];
    ErrorHandler.NeedToRefresh[sender] = true;
    
    if (sender == "ServicePlayer") {
            errorMessage = error.toString();
            ErrorHandler.NeedToRefresh[sender] = false;
    }
    
    if (info && !prevState) {
            errorMessage = error.toString();
            ErrorHandler.NeedToRefresh[sender] = false;
    }
        
    $.sfScene.show('ErrorPopUp');
    $('#SceneErrorPopUp').data("error", errorMessage);
    $('#SceneErrorPopUp').data("sender", backTo);         
    $.sfScene.focus('ErrorPopUp'); 
}