/**
 * @author EvgeniyV
 */

ChannelPicker = function(maxChannels, setCallback){
    this.setCallback = setCallback || function(){};
    this.maxChannels = maxChannels;
    this.channelToSet = "";
    this.settedChannel = "";
    this.setted = false;
    
    /*
    * Gets current channel
    */
    this.getCurrentChannel = function(){
        var currentChannel = this.channelToSet;
        var length = (this.maxChannels + "").length;
        while (currentChannel.length != length)
        {
            currentChannel += "-";
        }
        return currentChannel;
    }    
    
    /*
    * Gets current channel without -
    */
    this.getSettedChannel = function() {
        Logger.write("channel="+this.settedChannel, "ChannelPicker");
        return this.settedChannel.replace("-", "");
    }
    
    /*
    * Handles num button pressing
    */
    this.numPressed = function(key){
        var num = parseInt(this.channelToSet + key, 10);
        if (num <= this.maxChannels)
        {
			this.channelToSet += key;
        }
        if (typeof(this.numTimeout) != "undefined")
        {
			clearTimeout(this.numTimeout);
        }
        
        var cb = this.setChannel;
        var self = this;
        
        this.numTimeout = setTimeout(function(){cb(self);}, 2000);   
    }

    /*
    * Set channel callback
    */
    this.setChannel = function(self){        
        channel = parseInt(self.channelToSet, 10);
        if (channel > 0 && channel <= self.maxChannels)
        {
			var valueToSet = self.channelToSet;
			var cb = function () {
				self.settedChannel = valueToSet;
			};
            self.setCallback(channel, cb);
        }
        self.setted = true;
        self.channelToSet = "";
    }
    
    /*
    * Manual set channel callback
    */
    this.setChannelManual = function(channel, self){        
        channel = parseInt(channel, 10);
        if (channel > 0 && channel <= self.maxChannels)
        {
			var valueToSet = channel + "";
			var cb = function () {
				self.settedChannel = valueToSet;
			};
            self.setCallback(channel, cb);
        }        
        self.channelToSet = "";
    }     
    
    /*
    * Sets next channel
    */
    this.setNext = function(){        
        var channel = parseInt(this.settedChannel, 10);
        if ((channel + 1) <= this.maxChannels)
        {
            channel++;
            this.channelToSet = channel + "";
            this.setChannel(this);
        }        
    }    
    
    /*
    * Sets prev channel
    */
    this.setPrev = function(){        
        var channel = parseInt(this.settedChannel, 10);
        if ((channel - 1) > 0)
        {
            channel--;
            this.channelToSet = channel + "";
            this.setChannel(this);
        }        
    }
}    

ArchProgramPicker = function (programs, setCallback, index) {
    this.count = programs.length;
    this.setCallback = setCallback || function(){};
    this.index = index || 0;
    
    /*
    * Sets next program in array
    */
    this.setNext = function () {
        if (this.index < (this.count - 1)) {
            this.index++;
            this.setCallback(this.index);
			return true;
        }
    }

    /*
    * Sets prev program in array
    */    
    this.setPrev = function () {
        if (this.index > 0) {
            this.index--;
            this.setCallback(this.index);
			return true;
        }    
    }
}