/**
 * @author VasiliyK
 */


var LanguageMap = {
	'English': 'en',
	'Russian': 'ru',
	'Korean': 'ko',
	'Albanian': 'en',
	'French': 'fr',
	'Persian': 'fa',
	'Ukrainian': 'ru',
	'German': 'de'
};

/*
    Application context data
*/
var AppContext = {
	appName: "SAMSUNGTV",
    user: {
        login: "",
        password: "",
        sid: "",
		userSystemPassword: "",
		siteId: 0,
		adultPasswordTimestamp: null
    },
    
    ClientSettings: {
		Language: "",//None or English or Russian or Korean or Albanian or French or Persian or Ukrainian or German
		shiftTimeZoneName: "",
		timeZoneName: "",
		services: []
    }, 
    
    CurrentScene: "",
	ImageUrlTemplate: "",
	StreamQualityPresets: ["SQ", "HQ"],
	MaxPinAge: 60 //in minutes
}  

    /*
    Constructor of Time or Stream Zone
    */        
    Zone = function(id, utcOffset, name)
    {
        this.id = id;
        this.utcOffset = utcOffset;
        this.name = name;
    }
    
    Language = function(name, cultureInfo, displayName, id)
    {
        this.cultureInfo = cultureInfo;
        this.name = name;
		this.displayName = displayName;
		this.id = id;
    }
    
    AppContext.Languages = new Array(
		new Language("English", "en", "English", "eng"),
		new Language("Russian", "ru", "Русский", "rus")
	);
	
	AppContext.isAdultPasswordEntered = function () {
		if (!this.user.adultPasswordTimestamp) {
			return false;
		}
		var pinAge = ((new Date()) - this.user.adultPasswordTimestamp) / 60000;
		return pinAge <= 60;
	};
	
	AppContext.loadTimeZones = function (timeZones) {
		Logger.write("AppContext.loadTimeZones()", "AppContext");
		if (!timeZones || timeZones.length == 0) {
			return;
		}
		AppContext.TimeZones = [];
		AppContext.StreamZones = [];
		for (var i = 0; i < timeZones.length; i++) {
			AppContext.TimeZones.push(timeZones[i]);
			if (timeZones[i].stream) {
				AppContext.StreamZones.push(timeZones[i]);
			}
		}
	};
	
	AppContext.getTimeZoneUtcOffset = function (name) {
		var offset = 0;
		name = name || AppContext.ClientSettings.timeZoneName;
		for (var i = 0; i < AppContext.TimeZones.length; i++) {
			if (AppContext.TimeZones[i].id == name) {
				offset = parseInt(AppContext.TimeZones[i].utcOffset);
				break;
			}
		}
		
		return offset;
	};
	
	AppContext.getNaEstUtcOffset = function () {
		return AppContext.getTimeZoneUtcOffset("NA_EST") / 60;
	}
	
	AppContext.getStreamZoneUtcOffset = function (name) {
		var offset = 0;
		name = name || AppContext.ClientSettings.shiftTimeZoneName;
		for (var i = 0; i < AppContext.StreamZones.length; i++) {
			if (AppContext.StreamZones[i].id == name) {
				offset = parseInt(AppContext.StreamZones[i].utcOffset);
				break;
			}
		}
		
		return offset;
	};
