function SceneUpdatePopUp(options) {
	this.options = options;
	

}

SceneUpdatePopUp.active = false;

SceneUpdatePopUp.prototype.initialize = function () {
	Logger.write("SceneUpdatePopUp.initialize()", "TextboxPopUp");
	//SceneUpdatePopUp.currentLang = AppContext.ClientSettings.Language;
	SceneUpdatePopUp.init();
}

SceneUpdatePopUp.init = function () {
	$('#btnClose').sfButton({text : 'OK'});
    $('#btnDetails').sfButton({text : 'Details'});
	SceneUpdatePopUp.focuses = {
		close: 1,
		details: 2
	};
	SceneUpdatePopUp.focused = 0;
}

SceneUpdatePopUp.translate = function () {
	if (SceneUpdatePopUp.currentLang != AppContext.ClientSettings.Language) {
		SceneUpdatePopUp.currentLang = AppContext.ClientSettings.Language;
		$('#btnClose').sfButton({text:Resources.getResources().Ok, width:'140px'});
		$('#btnDetails').sfButton({text:Resources.getResources().Details, width:'140px'});
	}
}

SceneUpdatePopUp.show = function (message, sender) {
	Logger.write("SceneUpdatePopUp.show('" + message + "', " + sender + ")", "UpdatePopUp", true);
	SceneUpdatePopUp.sender = sender;
	SceneUpdatePopUp.message = message;
//	$("#updateInfo").sfLabel({text: message});
	$.sfScene.show("UpdatePopUp");
	$.sfScene.focus("UpdatePopUp");
	SceneUpdatePopUp.focusDetailsButton();
}

SceneUpdatePopUp.close = function () {
	$.sfScene.hide("UpdatePopUp");
	$.sfScene.show(SceneUpdatePopUp.sender);
	$.sfScene.focus(SceneUpdatePopUp.sender);
}

SceneUpdatePopUp.handleExit = function () {
	SceneUpdatePopUp.close();
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog(SceneUpdatePopUp.sender, resultCallback);
}

SceneUpdatePopUp.showDetails = function () {
	$.sfScene.hide('UpdatePopUp');
	if (SceneUpdatePopUp.sender === "MainMenu") {
		$.sfScene.hide("MainMenuBack");
	}
	$.sfScene.hide(SceneUpdatePopUp.sender);
	$.sfScene.show('Settings');
	$.sfScene.focus('Settings');
	SceneSettings.showUpdates();
}

SceneUpdatePopUp.focusCloseButton = function () {
	$('#btnClose').sfButton("focus");
	$('#btnDetails').sfButton("blur");
	SceneUpdatePopUp.focused = SceneUpdatePopUp.focuses.close;
}

SceneUpdatePopUp.focusDetailsButton = function () {
	$('#btnClose').sfButton("blur");
	$('#btnDetails').sfButton("focus");
	SceneUpdatePopUp.focused = SceneUpdatePopUp.focuses.details;
}

SceneUpdatePopUp.handleLeft = function () {
	SceneUpdatePopUp.focusCloseButton();
}

SceneUpdatePopUp.handleRight = function () {
	SceneUpdatePopUp.focusDetailsButton();
}

SceneUpdatePopUp.handleEnter = function () {
	if (SceneUpdatePopUp.focused == SceneUpdatePopUp.focuses.details) {
		SceneUpdatePopUp.showDetails();
	} else {
		SceneUpdatePopUp.close();
	}
}

SceneUpdatePopUp.prototype.handleShow = function () {
	alert("SceneUpdatePopUp.handleShow()");
	// this function will be called when the scene manager show this scene
	SceneUpdatePopUp.translate();
}

SceneUpdatePopUp.prototype.handleHide = function () {
	alert("SceneUpdatePopUp.handleHide()");
	// this function will be called when the scene manager hide this scene  
	SceneUpdatePopUp.active = false;
}

SceneUpdatePopUp.prototype.handleFocus = function () {
	alert("SceneUpdatePopUp.handleFocus()");
	// this function will be called when the scene manager focus this scene
	$("#updateInfo").sfLabel({text: SceneUpdatePopUp.message});
	SceneUpdatePopUp.active = true;
}

SceneUpdatePopUp.prototype.handleBlur = function () {
	alert("SceneUpdatePopUp.handleBlur()");
	// this function will be called when the scene manager move focus to another scene from this scene
}

SceneUpdatePopUp.prototype.handleKeyDown = function (keyCode) {
	alert("SceneUpdatePopUp.handleKeyDown(" + keyCode + ")");
	// TODO : write an key event handler when this scene get focued
	switch (keyCode) {
		case $.sfKey.LEFT:
			SceneUpdatePopUp.handleLeft();
			break;
		case $.sfKey.RIGHT:
			SceneUpdatePopUp.handleRight();
			break;
		case $.sfKey.UP:
			break;
		case $.sfKey.DOWN:
			break;
		case $.sfKey.RETURN:
            widgetAPI.blockNavigation(event);
            SceneUpdatePopUp.close();
			break;
		case $.sfKey.ENTER:
			SceneUpdatePopUp.handleEnter();
			break;
		case $.sfKey.EXIT:
			widgetAPI.blockNavigation(event);
			 SceneUpdatePopUp.handleExit();
			break;
	}
}
