function SceneUpdateManual(options) {
	this.options = options;
	

}

SceneUpdateManual.prototype.initialize = function () {
	alert("SceneUpdateManual.initialize()");
	// this function will be called only once when the scene manager show this scene first time
	// initialize the scene controls and styles, and initialize your variables here 
	// scene HTML and CSS will be loaded before this function is called
	
}

SceneUpdateManual.translate = function () {
	if (SceneUpdateManual.currentLang != AppContext.ClientSettings.Language) {
        SceneUpdateManual.currentLang = AppContext.ClientSettings.Language;
        $("#manualTitle .text").sfLabel({text: Resources.getResources().UpdateManualTitle});
    }
}

SceneUpdateManual.setHelpBar = function () {
	$('#keysUpdateManual').sfKeyHelp({
		'return': Resources.getResources().BackToMainMenu
	});
}

SceneUpdateManual.show = function (manual, sender) {
	if (!manual) {
		return;
	}
	
	SceneUpdateManual.sender = sender;
	SceneUpdateManual.manual = manual;
	
	Logger.write("Manual: " + manual, "UpdateManual", true);
	//$("#manualContent p").html(manual);
	$.sfScene.hide(sender);
	$.sfScene.show("UpdateManual");
	$.sfScene.focus("UpdateManual");
}

SceneUpdateManual.back = function () {
	$.sfScene.hide("UpdateManual");
	$.sfScene.show(SceneUpdateManual.sender);
	$.sfScene.focus(SceneUpdateManual.sender);
	SceneSettings.showUpdates();
}

SceneUpdateManual.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("UpdateManual", resultCallback);
}

SceneUpdateManual.prototype.handleShow = function () {
	alert("SceneUpdateManual.handleShow()");
	// this function will be called when the scene manager show this scene 
}

SceneUpdateManual.prototype.handleHide = function () {
	alert("SceneUpdateManual.handleHide()");
	// this function will be called when the scene manager hide this scene  
}

SceneUpdateManual.prototype.handleFocus = function () {
	alert("SceneUpdateManual.handleFocus()");
	// this function will be called when the scene manager focus this scene
	SceneUpdateManual.translate();
	SceneUpdateManual.setHelpBar();
	$("#manualContent p").html(SceneUpdateManual.manual[AppContext.ClientSettings.Language.cultureInfo]);
}

SceneUpdateManual.prototype.handleBlur = function () {
	alert("SceneUpdateManual.handleBlur()");
	// this function will be called when the scene manager move focus to another scene from this scene
}

SceneUpdateManual.prototype.handleKeyDown = function (keyCode) {
	alert("SceneUpdateManual.handleKeyDown(" + keyCode + ")");
	// TODO : write an key event handler when this scene get focued
	switch (keyCode) {
		case $.sfKey.LEFT:
			break;
		case $.sfKey.RIGHT:
			break;
		case $.sfKey.UP:
			break;
		case $.sfKey.DOWN:
			break;
		case $.sfKey.RETURN:
			widgetAPI.blockNavigation(event);
			SceneUpdateManual.back();
			break;
		case $.sfKey.EXIT:
			widgetAPI.blockNavigation(event);
			SceneUpdateManual.handleExit();
			break;

		case $.sfKey.ENTER:
			break;
	}
}
