function SceneTextboxPopUp(options) {
	this.options = options;
    
    var ime_txtSearchText = null;
}

SceneTextboxPopUp.prototype.initialize = function () {
	Logger.write("SceneTextboxPopUp.initialize()", "TextboxPopUp");
    $('#btnOk').sfButton({text : 'OK'});
    $('#btnCancel').sfButton({text : 'Cancel'});
	SceneTextboxPopUp.currentLang = AppContext.ClientSettings.Language;
}

SceneTextboxPopUp.init = function()
{
	document.getElementById('txtSearchText').value = "";
    $('#btnCancel').sfButton('blur');
    $('#btnOk').sfButton('blur'); 
	setTimeout(function () {
		this.currentFocus = "text";
		$('#txtSearchText').focus();
	}, 0);
}

SceneTextboxPopUp.translate = function()
{
	if(SceneTextboxPopUp.currentLang != AppContext.ClientSettings.Language)
	{
		SceneTextboxPopUp.currentLang = AppContext.ClientSettings.Language;
		$('#keysPopUp').sfKeyHelp({'return':Resources.getResources().BackToMainMenu});
		$('#btnOk').sfButton({text:Resources.getResources().Ok, width:'140px'});
		$('#btnCancel').sfButton({text:Resources.getResources().Cancel, width:'140px'});
	}
	
	$('#windowTitle').sfLabel({text:this.title, width:'80px'});

	ime_txtSearchText = null;
	var lang = LanguageMap[AppContext.ClientSettings.Language.name];
	Helpers.setImeLanguage(lang);
	ime_txtSearchText = new IMEShell("txtSearchText", callback_txtSearchText, AppContext.ClientSettings.Language.cultureInfo);
}

function callback_txtSearchText(cb) {
    cb.setKeypadPos(350, 150, 9999);
    cb.setKeyFunc($.sfKey.ENTER, function() {
        try
        {
            $.sf.returnFocus();
            SceneTextboxPopUp.currentFocus = "ok";
            $('#btnOk').sfButton('focus');
        }
        catch(error)
        {
            ErrorHandler.HandleError(error,"TextboxPopUp");  
        }
    });
    cb.setKeyFunc($.sfKey.DOWN, function(){
        try
        {
            $.sf.returnFocus();
            SceneTextboxPopUp.currentFocus = "ok";
            $('#btnOk').sfButton('focus');   
        }
        catch(error)
        {
			ErrorHandler.HandleError(error,"TextboxPopUp");
        }
    });  
	cb.setKeyFunc($.sfKey.RETURN, function(){
        try
        {
			widgetAPI.blockNavigation(event);
            $.sf.returnFocus();
            SceneTextboxPopUp.currentFocus = "cancel";
            $('#btnCancel').sfButton('focus');
			SceneTextboxPopUp.close();
			SceneTextboxPopUp.cancelCallback();
        }
        catch(error)
        {
			ErrorHandler.HandleError(error,"TextboxPopUp");  
        }
    });
	cb.setKeyFunc($.sfKey.EXIT, function(){
        try
        {
			widgetAPI.blockNavigation(event);
            $.sf.returnFocus();
            SceneTextboxPopUp.currentFocus = "cancel";
            $('#btnCancel').sfButton('focus');
			SceneTextboxPopUp.handleExit();
        }
        catch(error)
        {
			ErrorHandler.HandleError(error,"TextboxPopUp");  
        }
    });
}

SceneTextboxPopUp.setCallbacks = function(okCallback, sender, title, cancelCallback)
{
	Logger.write("okCallback: " + okCallback + "; sender: " + sender + "; title: " + title, "TextboxPopUp", true);
    this.okCallback = okCallback || function(){};
	this.cancelCallback = cancelCallback || function(){};
    this.sender = sender || "MainMenu";
	this.title = title || Resources.getResources().Search;
	//$('#windowTitle').sfLabel({text: title, width:'80px'});
}

SceneTextboxPopUp.handleLeft = function()
{
    try
    {
		Logger.write("====SceneTextboxPopUp.handleLeft()", "TextboxPopUp");
		Logger.write(this.currentFocus, "TextboxPopUp");
		if (this.currentFocus.indexOf("cancel") != -1)
		{
			this.currentFocus = "ok";
			$('#btnCancel').sfButton('blur');
			$('#btnOk').sfButton('focus');
		}
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"TextboxPopUp");  
    }
}

SceneTextboxPopUp.handleRight = function()
{
    try
    {
		Logger.write("====SceneTextboxPopUp.handleRight()", "TextboxPopUp");
		Logger.write(this.currentFocus, "TextboxPopUp");
		if (this.currentFocus.indexOf("ok") != -1)
		{
			this.currentFocus = "cancel";
			$('#btnOk').sfButton('blur');
			$('#btnCancel').sfButton('focus');
		}
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"TextboxPopUp");  
    }
}

SceneTextboxPopUp.handleUp = function()
{
    try
    {
		Logger.write("====SceneTextboxPopUp.handleUp()", "TextboxPopUp");
		Logger.write(this.currentFocus, "TextboxPopUp");
		if (this.currentFocus.indexOf("cancel") != -1 || this.currentFocus.indexOf("ok") != -1)
		{
			this.currentFocus = "text";
			$('#btnOk').sfButton('blur');
			$('#btnCancel').sfButton('blur');
			$('#txtSearchText').focus();
		}
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"TextboxPopUp");  
    }
}

SceneTextboxPopUp.handleDown = function()
{
}

SceneTextboxPopUp.handleEnter = function()
{
    try
    {
		var keyword = document.getElementById('txtSearchText').value;
		if (this.currentFocus.indexOf("ok") != -1 && keyword)
		{
			this.close();
			this.okCallback(document.getElementById('txtSearchText').value);                
		}
		else if (this.currentFocus.indexOf("cancel") != -1)
		{
			this.close();
			this.cancelCallback();
		}
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"TextboxPopUp");
    }
}

SceneTextboxPopUp.show = function(password)
{
	if (!password) {
		password = false;
	}
    $.sfScene.show('TextboxPopUp');
    $.sfScene.focus('TextboxPopUp');
	
	var currentIsPassword = $("#txtSearchText").attr("type") === "password";
	if (currentIsPassword != password) {
		var txtParent = $("#txtSearchText").parent();
		var type = $("#txtSearchText").attr("type");
		var size = $("#txtSearchText").attr("size");
		var maxlength = $("#txtSearchText").attr("maxlength");
		
		$("#txtSearchText").remove();
		var newType = !password ? "text" : "password";
		var passHtml = "<input type='" + newType + "' id='txtSearchText' size='" + size + "' maxlength='" + maxlength + "' />";
		txtParent.append(passHtml);
		ime_txtSearchText = null;
		ime_txtSearchText = new IMEShell("txtSearchText", callback_txtSearchText, AppContext.ClientSettings.Language.cultureInfo);
		ime_txtSearchText.setKeypadPos(350, 150, 9999);
	}
}

SceneTextboxPopUp.close = function()
{
	$('#txtSearchText').blur();
	$.sf.returnFocus();
    $.sfScene.hide('TextboxPopUp');
    $.sfScene.show(this.sender);
    $.sfScene.focus(this.sender);
}

SceneTextboxPopUp.handleExit = function () {
	SceneTextboxPopUp.close();
	SceneTextboxPopUp.cancelCallback();
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog(SceneTextboxPopUp.sender, resultCallback);
}

SceneTextboxPopUp.prototype.handleShow = function () {
	Logger.write("SceneTextboxPopUp.handleShow()", "TextboxPopUp");
	// this function will be called when the scene manager show this scene 
     //$("#SceneTextboxPopUp").css({'z-index':'9000'});
	 
	 SceneTextboxPopUp.translate();
	 $('#txtSearchText').blur();
}

SceneTextboxPopUp.prototype.handleHide = function () {
	Logger.write("SceneTextboxPopUp.handleHide()", "TextboxPopUp");
	// this function will be called when the scene manager hide this scene  
     //$("#SceneTextboxPopUp").css({'z-index':0});
	 $('#txtSearchText').blur();
}

SceneTextboxPopUp.prototype.handleFocus = function () {
	Logger.write("SceneTextboxPopUp.handleFocus()", "TextboxPopUp");
	// this function will be called when the scene manager focus this scene
	SceneTextboxPopUp.init();
	$("#SceneTextboxPopUp").css({'z-index':'9000'});
}

SceneTextboxPopUp.prototype.handleBlur = function () {
	Logger.write("SceneTextboxPopUp.handleBlur()", "TextboxPopUp");
	// this function will be called when the scene manager move focus to another scene from this scene
    //SceneMainMenu.unfocusButton(SceneMainMenu.currentIndex);
	$('#txtSearchText').blur();
}

SceneTextboxPopUp.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneTextboxPopUp.handleKeyDown(" + keyCode + ")", "TextboxPopUp");
	// TODO : write an key event handler when this scene get focued
	try {
		switch (keyCode) {
			case $.sfKey.LEFT:
				SceneTextboxPopUp.handleLeft();
				break;
			case $.sfKey.RIGHT:
				SceneTextboxPopUp.handleRight();
				break;
			case $.sfKey.UP:
				SceneTextboxPopUp.handleUp();
				break;
			case $.sfKey.DOWN:
				SceneTextboxPopUp.handleDown();
				break;
			case $.sfKey.RETURN:
			case $.sfKey.GREEN:
				widgetAPI.blockNavigation(event);
				SceneTextboxPopUp.close();
				SceneTextboxPopUp.cancelCallback();
				break;
			case $.sfKey.ENTER:
				SceneTextboxPopUp.handleEnter();
				break;
			case $.sfKey.EXIT:
				widgetAPI.blockNavigation(event);
				SceneTextboxPopUp.handleExit();
				break;
			case $.sfKey.RED:
				
				break;
			default:
				widgetAPI.blockNavigation(event);
				break;
		}
	}
	catch(error)
	{
		ErrorHandler.HandleError(error, "TextboxPopUp");  
	}
}
