/**
 * @author EvgeniyV
 */
 
function SceneRegistration(options) {
	this.options = options;
}

SceneRegistration.handleReturn = function () {        
    $.sfScene.hide('Registration');
    $.sfScene.show('DescribeApp');
    $.sfScene.focus('DescribeApp');
}

SceneRegistration.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("Registration", resultCallback);
}

/*
* Loads content panel
*/
SceneRegistration.loadPanel = function () {
	var opts = { focusedItemClassName : "focusedElement" };
	SceneRegistration.contentPanel = new MoviesPanel(156, 132, 696, 104, 3, function(){}, "registrationContentPanel", function(){}, function(){}, 130, false, 49, opts);    
	$("#panelRegistrationContent").empty();
	$("#panelRegistrationContent").append(SceneRegistration.contentPanel.panel);
	
	this.methods = new Array;
    var elems = new Array;
	var k = 0;
	if (Registration) {
		if (Registration.methods.web && Registration.methods.web === true) {
			this.methods[k] = "web";
			elems[k++] = {
				description : Resources.getResources().RegSite,
				imgSrc : "images/registration/reg_icon_web.png",
				imgWidth : 104,
				imgHeight : 104
			};
		}
		if (Registration.methods.email && Registration.methods.email === true) {
			this.methods[k] = "email";
			elems[k++] = {
				description : Resources.getResources().RegEmail,
				imgSrc : "images/registration/reg_icon_email.png",
				imgWidth : 104,
				imgHeight : 104
			};
		}
		if (Registration.methods.sms && Registration.methods.sms === true) {
			this.methods[k] = "sms";
			elems[k++] = {
				description : Resources.getResources().RegSms,
				imgSrc : "images/registration/reg_icon_sms.png",
				imgWidth : 104,
				imgHeight : 104
			};
		}
	}
	else {
		this.methods[0] = "web";
		this.methods[1] = "email";
		this.methods[2] = "sms";
		elems[0] = {
			description : Resources.getResources().RegSite,
			imgSrc : "images/registration/reg_icon_web.png",
			imgWidth : 104,
			imgHeight : 104
		};
		elems[1] = {
			description : Resources.getResources().RegEmail,
			imgSrc : "images/registration/reg_icon_email.png",
			imgWidth : 104,
			imgHeight : 104
		};
		elems[2] = {
			description : Resources.getResources().RegSms,
			imgSrc : "images/registration/reg_icon_sms.png",
			imgWidth : 104,
			imgHeight : 104
		};
	}
	
	SceneRegistration.contentPanel.loadPanelData(elems);
	SceneRegistration.contentPanel.focus();
}

 /*
 * Sets help bar
 */
SceneRegistration.setHelpBar = function(){
     $('#textRegistration').sfLabel({text: Resources.getResources().DescribeAppTitle});
     $('#keysRegistration').sfKeyHelp({     
		 'leftright':Resources.getResources().Back + " - " + Resources.getResources().Forward,
		 'updown':Resources.getResources().MoveCursor, 
		 'enter':Resources.getResources().Select,
		 'return':Resources.getResources().BackToMainMenu
	 });   
}

/*
 * Handles key DOWN press
 */
SceneRegistration.handleDown = function(){
    SceneRegistration.contentPanel.focusNext();
}

 /*
 * Handles key UP press
 */
SceneRegistration.handleUp = function(){
   SceneRegistration.contentPanel.focusPrev();
}

 /*
 * Handles key ENTER press
 */
SceneRegistration.handleEnter = function(){
     $.sfScene.hide('Registration');
     SceneCreateAccount.show(this.methods[SceneRegistration.contentPanel.index]);
}

/*
* Translates scene
*/
SceneRegistration.translate = function(){
	if (SceneSettings.currentLang != AppContext.ClientSettings.Language) {
		SceneRegistration.setHelpBar();
		SceneRegistration.loadPanel();
		
		SceneSettings.currentLang = AppContext.ClientSettings.Language;
	}
}

SceneRegistration.prototype.initialize = function () {
	Logger.write("SceneRegistration.initialize()", "Registration");
	// this function will be called only once when the scene manager show this scene first time
	// initialize the scene controls and styles, and initialize your variables here 
	// scene HTML and CSS will be loaded before this function is called
    SceneRegistration.setHelpBar();
    SceneRegistration.loadPanel();
}

SceneRegistration.prototype.handleShow = function () {
	Logger.write("SceneRegistration.handleShow()", "Registration");
	// this function will be called when the scene manager show this scene 
    SceneRegistration.setHelpBar();
}

SceneRegistration.prototype.handleHide = function () {
	Logger.write("SceneRegistration.handleHide()", "Registration");
	// this function will be called when the scene manager hide this scene  
}

SceneRegistration.prototype.handleFocus = function () {
	Logger.write("SceneRegistration.handleFocus()", "Registration");
	// this function will be called when the scene manager focus this scene
    AppContext.CurrentScene = "Registration";
    //SceneRegistration.setHelpBar();
    //SceneRegistration.loadPanel();
	SceneRegistration.translate();
}

SceneRegistration.prototype.handleBlur = function () {
	Logger.write("SceneRegistration.handleBlur()", "Registration");
	// this function will be called when the scene manager move focus to another scene from this scene
}

SceneRegistration.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneRegistration.handleKeyDown(" + keyCode + ")", "Registration");
	// TODO : write an key event handler when this scene get focued
    try
    {
        switch (keyCode) {
            case $.sfKey.LEFT:
                SceneRegistration.handleReturn();
                break;
            case $.sfKey.RIGHT:
                SceneRegistration.handleEnter();
                break;
            case $.sfKey.UP:
                SceneRegistration.handleUp();
                break;
            case $.sfKey.DOWN:
                SceneRegistration.handleDown();
                break;
            case $.sfKey.ENTER:
                SceneRegistration.handleEnter();
                break;  
            case $.sfKey.RETURN:
                widgetAPI.blockNavigation(event);
                SceneRegistration.handleReturn();
                break;
            case $.sfKey.EXIT:
                 widgetAPI.blockNavigation(event);
			     SceneRegistration.handleExit();
                 break;
            default:
                widgetAPI.blockNavigation(event);
                break;
        }
    } 
    catch(error)
    {
          ErrorHandler.HandleError(error,"Registration");  
    }
}
