/**
 * @author EvgeniyV
 */
function ScenePopUp(options) {
	this.options = options;	

}
 /*
 Index of current button
 */
 ScenePopUp.count = 2;
 ScenePopUp.index = 0;
 ScenePopUp.zIndex = 9000;
 ScenePopUp.maxLengthOfDescription = 260;
 
 /*
Sizes of big and small images of Movie
*/
 ScenePopUp.imgWidth = "25";
 ScenePopUp.imgHeight = "25";
 ScenePopUp.imgLWidth = "30";
 ScenePopUp.imgLHeight = "30";

 /*
 * Sets help bar
 */
ScenePopUp.setHelpBar = function () {
	$('#keysPopUp').sfKeyHelp({'return':Resources.getResources().BackToMainMenu});
	$("#windowTitle").sfLabel({text : Resources.getResources().Info});
}

ScenePopUp.addFavorite = function () {
	var addCallback = function (result) {
		try {
			ScenePopUp.usebtnAddFav = false;
			ScenePopUp.item.bookmarked = true;
			ScenePopUp.favoriteChanged(true);
			ScenePopUp.checkBtn();
			switch (ScenePopUp.item.contentType) {
				case JsonServices.ContentType.DVR:
					SceneFavorites.isNew.programs = false;
					break;
				case JsonServices.ContentType.ArcPlus:
					SceneFavorites.isNew.arcPlus = false;
					break;
				case JsonServices.ContentType.VOD:
					SceneFavorites.isNew.movies = false;
					break;
			}
		} catch (error) {
			ErrorHandler.HandleError(error,"PopUp");
		}
	};
    var errorCallback = function (jqXHR, textStatus, error) {
		ErrorHandler.HandleError(error, "PopUp", true, textStatus);
	};
	
	JsonServices.content.AddFavorites(AppContext.user.sid, ScenePopUp.item.contentType, [ScenePopUp.item.id], addCallback, errorCallback);
}

ScenePopUp.deleteFavorite = function () {
	var deleteCallback = function (result) {
		try {
			ScenePopUp.item.bookmarked = false;
			ScenePopUp.favoriteChanged(false);
			switch (ScenePopUp.item.contentType) {
				case JsonServices.ContentType.DVR:
					SceneFavorites.isNew.programs = false;
					break;
				case JsonServices.ContentType.ArcPlus:
					SceneFavorites.isNew.arcPlus = false;
					break;
				case JsonServices.ContentType.VOD:
					SceneFavorites.isNew.movies = false;
					break;
			}
			if(ScenePopUp.sender == "Favorites") {
				$.sfScene.hide('PopUp');
				$.sfScene.show(ScenePopUp.sender);
				$.sfScene.focus(ScenePopUp.sender);
			} else {
				ScenePopUp.usebtnAddFav = true;
				ScenePopUp.checkBtn();
			}
		} catch (error) {
			ErrorHandler.HandleError(error, "PopUp");  
		}     
    };
    var errorCallback = function(jqXHR, textStatus, error) {
		ErrorHandler.HandleError(error, "PopUp", true, textStatus);
	};
	
	JsonServices.content.DeleteFavorites(AppContext.user.sid, ScenePopUp.item.contentType, [ScenePopUp.item.id], deleteCallback, errorCallback);
}

 /*
 Sets pop up window scene parameters
 */
ScenePopUp.setWindow = function (sender, item, favoriteChanged) {
	ScenePopUp.item = item;
	ScenePopUp.sender = sender;
	ScenePopUp.favoriteChanged = favoriteChanged || function(){};
	$("#btnFavDelete").hide();
	$("#btnAddFav").hide();
	if (item.bookmarked) {
		ScenePopUp.usebtnAddFav = false;
	} else {
		ScenePopUp.usebtnAddFav = true;
	}
	ScenePopUp.checkBtn();
}
/*
Adds imges for buttons
*/
ScenePopUp.addImages = function () {
	$("#btnAddFav img").sfImage({src: "images/icon-addfav.png"});
	$("#btnFavDelete img").sfImage({src: "images/icon-remfav.png"});
	$("#btnAddFav .lblBtnText").sfLabel({text: Resources.getResources().AddToFav});
	$("#btnFavDelete .lblBtnText").sfLabel({text: Resources.getResources().DeleteFromFav});
	$("#btnFavDelete").hide();
	$("#btnAddFav").hide();
}
/*
Translates text of buttons
*/
ScenePopUp.translate = function () {
	if (ScenePopUp.currentLang != AppContext.ClientSettings.Language)
	{
		ScenePopUp.addImages();
		ScenePopUp.setHelpBar();
		ScenePopUp.currentLang = AppContext.ClientSettings.Language;
	}
}
/*
Checks what button to show
*/
ScenePopUp.checkBtn = function () {
	if (ScenePopUp.usebtnAddFav)
	{
		$("#btnFavDelete").hide();
		$("#btnAddFav").show();
	}
	else
	{
		$("#btnAddFav").hide();
		$("#btnFavDelete").show();
	}
}
  
ScenePopUp.prototype.initialize = function () {
	
    Logger.write("ScenePopUp.initialize()", "PopUp");
    // this function will be called only once when the scene manager show this scene first time
    // initialize the scene controls and styles, and initialize your variables here 
    // scene HTML and CSS will be loaded before this function is called
    AppContext.CurrentScene = "PopUp";
    ScenePopUp.currentLang = AppContext.ClientSettings.Language;
    ScenePopUp.addImages(); 
    ScenePopUp.setHelpBar();
}

/*
Shows program or movie image
*/
ScenePopUp.showImage = function () {
	$("#lblPopUpContentName").removeClass("noimage");
	$("#imgPopUpContent img").sfImage({src: ""});
	$("#imgPopUpContent").hide();
	
	if (ScenePopUp.item.imageCount > 0) {
		var imgSrc = AppContext.ImageUrlTemplate.replace("{0}", ScenePopUp.item.id).replace("{2}", "1");
		var width, height;
		switch (ScenePopUp.item.contentType) {
			case JsonServices.ContentType.VOD:
				var isAdult = false;
				var genres = ScenePopUp.item.contentGenres;
				for (var i = 0; i < genres.length; i++) {
					if (Helpers.isAdultMovieGenre(genres[i])) {
						isAdult = true;
						break;
					}
				}
				if (isAdult && !AppContext.isAdultPasswordEntered()) {
					imgSrc = "./images/xxx_dummy_img.jpg";
				} else {
					imgSrc = imgSrc.replace("{1}", 1);
				}
				width = 90;
				height = 130;
				break;
			case JsonServices.ContentType.DVR:
				imgSrc = imgSrc.replace("{1}", 28);
				width = 160;
				height = 80;
				break;
			case JsonServices.ContentType.ArcPlus:
				imgSrc = imgSrc.replace("{1}", 16);
				width = 160;
				height = 90;
				break;
		}
		
		Logger.write("ImgSrc: " + imgSrc, "PopUp", true);
		imgSrc += "&width=" + width;
		$("#imgPopUpContent img").sfImage({src: imgSrc});
		$("#imgPopUpContent").show();
		$("#imgPopUpContent img").css({'width': width + 'px','height': height + 'px'});
	} else {
		ScenePopUp.hideImage();
	}
}

ScenePopUp.hideImage = function () {
	$("#imgPopUpContent").hide();
	$("#lblPopUpContentName").addClass("noimage");
}

ScenePopUp.show = function ()
{
    $.sfScene.show('PopUp');
    $.sfScene.focus('PopUp');
}

ScenePopUp.close = function ()
{
    $.sfScene.hide('PopUp');
    $.sfScene.show(ScenePopUp.sender);
    $.sfScene.focus(ScenePopUp.sender);
}

ScenePopUp.handleExit = function () {
	ScenePopUp.close();
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog(ScenePopUp.sender, resultCallback);
}

ScenePopUp.prototype.handleShow = function () {
	Logger.write("ScenePopUp.handleShow()", "PopUp");
	// this function will be called when the scene manager show this scene   
	AppContext.CurrentScene = "PopUp";
	ScenePopUp.showImage();
	ScenePopUp.translate();
	ScenePopUp.index = 0;
	$("#lblPopUpContentName").empty();
	$("#lblPopUpContentName").append(ScenePopUp.item.name);
	$("#lblPopUpDescription").empty();
	var description = ScenePopUp.item.description;
	description = description.length > ScenePopUp.maxDescriptionLength 
		? description.substring(0, ScenePopUp.maxDescriptionLength - 3) + "..." 
		: description;
	$("#lblPopUpDescription").append(description);
	$("#ScenePopUp").css({'z-index': ScenePopUp.zIndex});
	ScenePopUp.checkBtn();
}

ScenePopUp.prototype.handleHide = function () {
	Logger.write("ScenePopUp.handleHide()", "PopUp");
	// this function will be called when the scene manager hide this scene  
}

ScenePopUp.prototype.handleFocus = function () {   
	Logger.write("ScenePopUp.handleFocus()", "PopUp");
	// this function will be called when the scene manager focus this scene
    $("#ScenePopUp").css({'z-index': ScenePopUp.zIndex});
    AppContext.CurrentScene = "PopUp";
}

ScenePopUp.prototype.handleBlur = function () {
	Logger.write("ScenePopUp.handleBlur()", "PopUp");
	// this function will be called when the scene manager move focus to another scene from this scene
}
ScenePopUp.handleEnter = function(){
	try {
		if (ScenePopUp.usebtnAddFav) {
			ScenePopUp.addFavorite();
		} else {
			ScenePopUp.deleteFavorite();
		}
	} catch (error) {
		ErrorHandler.HandleError(error, "PopUp");  
	}
}
ScenePopUp.backToMainMenu = function(){
    try
    {
		ScenePopUp.close();
    }
    catch (error)
    {
		ErrorHandler.HandleError(error, "PopUp");  
    }
}
ScenePopUp.prototype.handleKeyDown = function (keyCode) {
	Logger.write("ScenePopUp.handleKeyDown(" + keyCode + ")", "PopUp");
	// TODO : write an key event handler when this scene get focued
	switch (keyCode) {
		case $.sfKey.LEFT:
			break;
		case $.sfKey.RIGHT:
			break;
		case $.sfKey.UP:
            ///ScenePopUp.focusPrev();
			break;
		case $.sfKey.DOWN:
           // ScenePopUp.focusNext();
			break;
		case $.sfKey.ENTER:
            ScenePopUp.handleEnter();
			break;
        case $.sfKey.RETURN:
            widgetAPI.blockNavigation(event);
            ScenePopUp.backToMainMenu();
            break;
        case $.sfKey.STOP:
            if  (ScenePlayer.isPlaying == true)
            {
                ScenePlayer.stop();
            }
            break;
		case $.sfKey.EXIT:
            try
            {
                widgetAPI.blockNavigation(event);
				ScenePopUp.handleExit();
            }
            catch(error)
            {
                ErrorHandler.HandleError(error, "PopUp");  
            }  
            break;     
        default:         
            widgetAPI.blockNavigation(event);
            break;
	}
}
