function ScenePlayer(options) {
	this.options = options;
}

/*
* Stream types
*/
StreamTypes = {live:0, shifted:1, archive:2, vod:3, radio:4, arcPlus: 5};

/*
* Service statuses
*/
ServiceStatuses = {na:0, available:1, previewAvailable:2, enabled:3};

ScenePlayer.prototype.initialize = function () {
	Logger.write("ScenePlayer.initialize()", "Player");
    ScenePlayer.time = 5000;
    ScenePlayer.setHelpBar();
    ScenePlayer.timeoutForJump = 4000;
    ScenePlayer.jumpValue = 60000;
	ScenePlayer.errorCount = 0;
}

ScenePlayer.firstTimeStart = true;
ScenePlayer.autoPlay = true;

ScenePlayer.setHelpBar = function () {
    var keys = {
		'red':Resources.getResources().LabelSettings
	};
	if (ScenePlayer.streamType != StreamTypes.radio) {
		keys['green'] = Resources.getResources().Ratio;
	}
	if (ScenePlayer.sender == "Series" || ScenePlayer.sender == "ProgramEpisodes") {
		if (ScenePlayer.autoPlay) {
			keys['yellow'] = Resources.getResources().PlayerAutoPlayOn;
		} else {
			keys['yellow'] = Resources.getResources().PlayerAutoPlayOff;
		}
	}
	keys['blue'] = Resources.getResources().Menu;
	keys['stop'] = Resources.getResources().Stop;
	keys['play'] = Resources.getResources().Play;
	if (ScenePlayer.streamType != StreamTypes.live && ScenePlayer.streamType != StreamTypes.shifted && ScenePlayer.streamType != StreamTypes.radio) {
		keys['rew'] = '';
		keys['ff'] = Resources.getResources().Jump;
	}
	keys['return'] = Resources.getResources().Back;
	$('#helpKeysPlayer').sfKeyHelp(keys);
	
	$("#radioInfo .buffering").html(Resources.getResources().Buffering);
}

/*------------------Player events-----------------*/

ScenePlayer.onConnectionFailed = function () {
	ScenePlayer.errorCount++;
    Logger.write("[player] connection failed", "Player");
	if (ScenePlayer.isNotEnoughErrors()) {
		ScenePlayer.stop();
		ScenePlayer.play();
	} else {
		ScenePlayer.stopAndReturn();
		ErrorHandler.HandleError(Resources.getResources().ConnectionFailed,"Player");
	}
	
}

ScenePlayer.onNetworkDisconnected = function () {
	ScenePlayer.errorCount++;
    Logger.write("[player] network disconnected", "Player");
	if (ScenePlayer.isNotEnoughErrors()) {
		var time = $('#svecVideo2_50Z0').sfVideo2('getPlayedTime') / 1000;
		Logger.write("Played time: " + time, "Player", true);
		$('#svecVideo2_50Z0').sfVideo2('resumePlay', time);
	} else {
		ScenePlayer.stopAndReturn();
		ErrorHandler.HandleError(Resources.getResources().NetworkDisconnected, "Player");
	}
}

ScenePlayer.onRenderError = function (error) {
	ScenePlayer.errorCount++;
	error = parseInt(error);
	switch (error) {
		case 1:
			error = "Unsupported container";
			break;
		case 2:
			error = "Unsupported video codec";
			break;
		case 3:
			error = "Unsupported audio codec";
			break;
		case 4:
			error = "Unsupported video resolution";
			break;
	}
	Logger.write("[player] render error: " + error, "Player");
	if (ScenePlayer.isNotEnoughErrors()) {
		ScenePlayer.stop();
		ScenePlayer.play();
	} else {
		ScenePlayer.stopAndReturn();
		ErrorHandler.HandleError(Resources.getResources().RenderError, "Player");
	}
}

ScenePlayer.onStreamNotFound = function() {
	ScenePlayer.errorCount++;
    Logger.write("[player] stream not found", "Player");
	if (ScenePlayer.isNotEnoughErrors()) {
		ScenePlayer.stop();
		ScenePlayer.play();
	} else {
		ScenePlayer.stopAndReturn();
		ErrorHandler.HandleError(Resources.getResources().StreamNotFound, "Player");
	}
}

ScenePlayer.isNotEnoughErrors = function () {
	Logger.write("Not enough errors", "Player", true);
	return ScenePlayer.errorCount < 3;
	
	Logger.write("Enough errors", "Player", true);
	return false;
}

/*
Function that runs when player buffering begins
*/
ScenePlayer.onBufferingStart = function () {
	if (ScenePlayer.sender == "Radio") {
		$("#radioInfo .buffering").show();
	} else {
		Logger.write("[player] Buffering start", "Player");
		$("#playerLoadingHolder").css({'visibility' : 'visible'});
		$("#imgPlayerLoading").css({'visibility' : 'visible'});
		$("#playerLoadingHolder").css({'z-index' : '1234px'});
		$("#imgPlayerLoading").css({'z-index' : '1234px'});
		
		$("#imgPlayerLoading").sfLoading('show');
	}
}


/*
Function that runs when player buffering is complete
*/
ScenePlayer.onBufferingComplete = function () {
	try {
		if (ScenePlayer.sender == "Radio") {
				$("#radioInfo .buffering").hide();
		} else {
			Logger.write("[player] Buffering complete", "Player");
			$("#imgPlayerLoading").sfLoading('hide');
			$("#loadingObject").sfLoading('hide');
		}
		
		var status = $('#svecVideo2_50Z0').sfVideo2("getStatus");
		if (status == 1) {
			$('#svecVideo2_50Z0').sfVideo2("play");
		} else if (status == 2) {
			$('#svecVideo2_50Z0').sfVideo2("play");
			$('#svecVideo2_50Z0').sfVideo2("pause");
		}
	}
	catch (ex) {
		ScenePlayer.stopAndReturn();
		ErrorHandler.HandleError(ex,"Player");
	}
}
/*
Function that runs when OnRenderingComplete event is raised
*/
ScenePlayer.onRenderingComplete = function () {
    Logger.write("[player] rendering complete called", "Player");
    if (!ScenePlayer.isPlaying)
        return;
        
    Logger.write("[player] rendering complete", "Player");
    try
	{
		ScenePlayer.stop();
		Logger.write("ScenePlayer autoPlay: " + ScenePlayer.autoPlay, "Player", true);
		if (ASXLoader.hasNext) {
			 ScenePlayer.setUrlCallback();
		} else if ((ScenePlayer.sender == "Series" || ScenePlayer.sender == "ProgramEpisodes") && ScenePlayer.autoPlay && ScenePlayer.episodePicker) {
			Logger.write("Pick next episode is possible", "Player", true);
			var result = ScenePlayer.sender == "Series" ? ScenePlayer.episodePicker.setNext() : ScenePlayer.episodePicker.setPrev();
			if (!result) {
				ScenePlayer.handleReturn();
			}
		} else {
			ScenePlayer.handleReturn();
		}
	}
	catch(ex)
	{
		ScenePlayer.stopAndReturn();
		ErrorHandler.HandleError(ex,"Player");
	}
}
/*
Runs when stream ready
*/
ScenePlayer.onPlayerStreamReady = function () {
    Logger.write("[player] stream ready", "Player");
	if (ScenePlayer.isStopped) {
		ScenePlayer.setAspectRatio(ScenePlayer.aspectRatio);
		Logger.write("[player] stream stopped", "Player");
		return;
	}
	
    try {
		ScenePlayer.errorCount = 0;
        $('#svecVideo2_controller_YQ4I').sfVideo2_controller("setFullScreen");
        $('#svecVideo2_50Z0').sfVideo2("setTotalTime");
        ScenePlayer.showControls();
        ScenePlayer.isPlaying = true;
		
		if (ScenePlayer.sender != "Radio") {
			pluginAPI.setOffScreenSaver();
		}
        
        var PlayerPlugin = document.getElementById('pluginPlayer');
        
        if (ScenePlayer.streamType == StreamTypes.radio) {
            PlayerPlugin.ClearScreen();
            PlayerPlugin.SetDisplayArea(0,0,0,0);
            $("#pluginPlayer").css('width',  '0px');
            $("#pluginPlayer").css('height', '0px');
            return;
        }
        
		//if (!ScenePlayer.ar) {
			ScenePlayer.setAspectRatio(ScenePlayer.aspectRatio);
		//}
        
        Logger.write("Content duration=" + $('#svecVideo2_50Z0').sfVideoGetContentDuration(), "Player"); 
        if (ScenePlayer.serviceStatus == ServiceStatuses.previewAvailable) {
            SceneErrorPopUp.backTo ="Player";
            ErrorHandler.HandleError(Resources.getResources().YouAreNotSubscribedToThisService, "ServicePlayer");
        }
    } catch (ex) {
          ScenePlayer.stopAndReturn();
          ErrorHandler.HandleError(ex,"Player");
    }
}


/*--------------end Player events---------------*/

/*
*Shows controls and helpbar, sets timeout to hide
*/
ScenePlayer.showControls = function () {
    if (typeof(ScenePlayer.timeout) != "undefined") {
            clearTimeout(ScenePlayer.timeout);
    }
    ScenePlayer.timeout = setTimeout(ScenePlayer.hideControls, ScenePlayer.time);
    $('#svecVideo2_controller_YQ4I').show();
    $('#helpKeysPlayer').show();
}

ScenePlayer.prototype.handleShow = function () {
	Logger.write("ScenePlayer.handleShow()", "Player");
	// this function will be called when the scene manager show this scene
}

/*
Sets name and url of video to play
*/
ScenePlayer.setContent = function (content, sender) {
	Logger.write("ScenePlayer.setContent(" + content + ", " + sender + ")");
    var url = content.url;
	ScenePlayer.contentType = content.contentType;
    Logger.write("url="+url, "Player")
	Logger.write("playlist="+content.playlist, "Player");
    if  (ScenePlayer.isPlaying === true) {
		ScenePlayer.stopPlayer();
    }
	
	if (content.ar && content.ar.x && content.ar.y) { //aspect ratio provided by services
		Logger.write("AR provided: " + content.ar.x + ":" + content.ar.y, "Player", true);
		ScenePlayer.ar = content.ar;
	} else {
		ScenePlayer.ar = null;
	}
	ScenePlayer.aspectRatio = ScenePlayer.aspectRatios.normal;

	ScenePlayer.sender = sender;
	ScenePlayer.onBufferingStart();
    ScenePlayer.contentDuration = content.duration || 0;
	Logger.write("Duration: " + content.duration, "Player", true);
    $("#radioInfo").hide();
	
	if (content.contentType == "LiveTV") {
		ScenePlayer.serviceStatus = Helpers.checkStatus(sender);
		if (AppContext.ClientSettings.shiftTimeZoneName.indexOf("EU_RST") != -1) {
			ScenePlayer.streamType = StreamTypes.live;
		} else {
			ScenePlayer.streamType = StreamTypes.shifted;
		} 
	} else  {
		if (content.contentType == "Radio") {
			ScenePlayer.streamType = StreamTypes.radio;
			$("#radioInfo").show();
			$("#radioInfo .logo img").sfImage({'src': content.imageUrl});
		} else if (content.contentType == "VOD") {
			ScenePlayer.streamType = StreamTypes.vod;
		} else if (content.contentType == "DVR") {
			ScenePlayer.streamType = StreamTypes.archive;
		} else if (content.contentType == "ArcPlus") {
			ScenePlayer.streamType = StreamTypes.arcPlus;
		}
	}
	ScenePlayer.serviceStatus = Helpers.checkStatus(content.contentType);
	
    if (!url && content.playlist.indexOf("<ASX VERSION") > -1) {
		Logger.write("===== playing playlist", "Player");
		ASXLoader.parse(content.playlist);
		if (AppContext.CurrentScene == "Favorites") {
			ScenePlayer.archProgramPicker = null;
		}
		ScenePlayer.contentDuration = 0;
		$('#svecVideo2_50Z0').sfVideo2SetDuration(ScenePlayer.contentDuration);
		var asxUrl = ASXLoader.getNextUrl();
		ScenePlayer.playUrl(asxUrl);
    } else {
		Logger.write("===== playing url", "Player");
		ASXLoader.hasNext = false;
		ASXLoader.hasPlayList = false;
		
		$('#svecVideo2_50Z0').sfVideo2SetDuration(ScenePlayer.contentDuration);
		
		ScenePlayer.playUrl(url);
    }
    ScenePlayer.playingInfo = "begin";
    Logger.write("[player] url to play="+url, "Player");
	ScenePlayer.setHelpBar();
}

/*
Sets new url from ASX
*/
ScenePlayer.setUrlCallback = function(){
    if  (ScenePlayer.isPlaying == true)
    {
           ScenePlayer.stopPlayer();
    }
    var url = ASXLoader.getNextUrl();
    Logger.write("[player] url to play="+url, "Player");
    ScenePlayer.playUrl(url);
}


/*
Runs specified url on player
*/
ScenePlayer.playUrl = function (url) {
	Logger.write("URL: " + url.toSource(), "Player", true);
    if (url == "") {
        Logger.write("[player] url not defined", "Player");
        ScenePlayer.stop();
        return;
    }    
    Logger.write("Content duration b play=" + $('#svecVideo2_50Z0').sfVideoGetContentDuration(), "Player"); 
    if (typeof(timeout) != "undefined") {
            clearTimeout(timeout);
    }
    timeout = setTimeout(ScenePlayer.hideControls, ScenePlayer.timeout);
	
	var buffers = Helpers.loadBuffers();
	if (ScenePlayer.streamType == StreamTypes.radio) {
		buffers.initialBuffer /= 4;
		buffers.totalBuffer /= 4;
		buffers.pendingBuffer /= 4;
	}
    if (ScenePlayer.firstTimeStart) {
		$('#svecVideo2_50Z0').sfVideo2({urlMedia:url, duration: ScenePlayer.contentDuration, jumpSeconds:'10', idVideo2_controller:'svecVideo2_controller_YQ4I', buffers: buffers});
		$('#svecVideo2_controller_YQ4I').sfVideo2_controller();
    } else {
		$('#svecVideo2_50Z0').sfVideo2("setBuffers", buffers);
		$('#svecVideo2_50Z0').sfVideo2SetUrl(url);
		$('#svecVideo2_50Z0').sfVideo2("play");
    }       
	if (ScenePlayer.ar) {
		ScenePlayer.setAspectRatio(ScenePlayer.aspectRatio);
	}
	$('#svecVideo2_controller_YQ4I').activateButtons();
	if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted || ScenePlayer.streamType == StreamTypes.radio) {
		$('#svecVideo2_controller_YQ4I').deactivateButton("pause");
		$('#svecVideo2_controller_YQ4I').deactivateButton("backward");
		$('#svecVideo2_controller_YQ4I').deactivateButton("forward");
	}
    Helpers.setBackgroundOpacity();
    ScenePlayer.firstTimeStart = false;
    if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted) {
        var currentChannel = ScenePlayer.channelPicker.getSettedChannel();
        Logger.write("currentChannel="+currentChannel, "Player");
        $('#svecVideo2_controller_YQ4I').setChannel(currentChannel);
    } else {
        $('#svecVideo2_controller_YQ4I').setChannel("");
    }
}

/*
Plays video
*/
ScenePlayer.play = function () {
    Helpers.setBackgroundOpacity();
    if (typeof(timeout) != "undefined") {
		clearTimeout(timeout);
    }
    timeout = setTimeout(ScenePlayer.hideControls, ScenePlayer.timeout);
    $('#svecVideo2_50Z0').sfVideo2('RCKeyDefined', $.sfKey.PLAY);
}

/*
Stops player and removes background opacity
*/
ScenePlayer.stop = function () {
    $("#imgPlayerLoading").sfLoading('hide');
    $("#loadingObject").sfLoading('hide');
    ScenePlayer.isPlaying = false;
	ScenePlayer.isStopped = true;
    Helpers.removeBackgroundOpacity();
    if (!ScenePlayer.firstTimeStart) {
        $('#svecVideo2_50Z0').sfVideo2('pause');
        $('#svecVideo2_50Z0').sfVideo2('stop');
    }
}

/*
Stops player
*/
ScenePlayer.stopPlayer=function(){
    $("#imgPlayerLoading").sfLoading('hide');
    $("#loadingObject").sfLoading('hide');
    ScenePlayer.isPlaying = false;
    $('#svecVideo2_50Z0').sfVideo2('pause');
    $('#svecVideo2_50Z0').sfVideo2('stop');
}

/*
Hides player's controls
*/
ScenePlayer.hideControls = function(){
    if (ScenePlayer.streamType == StreamTypes.radio)
        return;

    $('#svecVideo2_controller_YQ4I').hide();
    $('#helpKeysPlayer').hide();
}

/*
Stops player and returns to previous scene
*/
ScenePlayer.stopAndReturn = function(){
    ScenePlayer.stop();
    ScenePlayer.handleReturn();
}

ScenePlayer.aspectRatios = {normal:0, stretch:1, zoom:2};
ScenePlayer.aspectRatio = ScenePlayer.aspectRatios.normal;

/*
* Changes aspect ratio
*/
ScenePlayer.setAspectRatio = function(aspectRatio){
        ScenePlayer.aspectRatio = aspectRatio;
        var PlayerPlugin = document.getElementById('pluginPlayer');
        
        var oldwidth = PlayerPlugin.GetVideoWidth();
        var oldheight = PlayerPlugin.GetVideoHeight();
        
        Logger.write("[player] original width=" + oldwidth, "Player");
        Logger.write("[player] original height=" + oldheight, "Player");
        
        var height = MAX_HEIGHT_SCREEN;
        var width = MAX_WIDTH_SCREEN;
        
        switch (aspectRatio) {
            case ScenePlayer.aspectRatios.normal:
                var ar = ScenePlayer.ar ? ScenePlayer.ar.x / ScenePlayer.ar.y : oldwidth / oldheight;
				if (ar > (16 / 9)) {
					height = width / ar;
				} else if (ar < (16 / 9)) {
					width = height * ar;
				}  
                break;    
            case ScenePlayer.aspectRatios.zoom:
                if ((oldwidth > 0) || (oldheight > 0 ))
                {
                    height  = width * (oldheight/oldwidth);
                }
                    
                break;
        }
            
        var y =  MAX_HEIGHT_SCREEN/2 - height/2;
        var x =  MAX_WIDTH_SCREEN/2 - width/2;
        Logger.write("[player] width=" + width, "Player");
        Logger.write("[player] height=" + height, "Player");
        Logger.write("[player] x=" + x, "Player");
        Logger.write("[player] y=" + y, "Player");
        PlayerPlugin.ClearScreen();
        PlayerPlugin.SetDisplayArea(x,y, width, height);
        $("#pluginPlayer").css('position', 'fixed');
        $("#pluginPlayer").css('top', y+'px');
        $("#pluginPlayer").css('left', x+'px');
        
        $(this).css('top', '0px');
        $(this).css('left', '0px');
        
        $("#pluginPlayer").css('width', width + 'px');
        $("#pluginPlayer").css('height', height + 'px');
}


/*
* Handles green button pressing
*/
ScenePlayer.handleGreenButton = function () {
    switch (ScenePlayer.aspectRatio) {
            case ScenePlayer.aspectRatios.normal:
                ScenePlayer.setAspectRatio(ScenePlayer.aspectRatios.stretch);
                break;
            case ScenePlayer.aspectRatios.stretch:
                ScenePlayer.setAspectRatio(ScenePlayer.aspectRatios.normal);
                break;
    }
}

/*
Handles the press of a button return
*/
ScenePlayer.handleReturn = function(){
    $.sfScene.hide('Player');
    if (AppContext.CurrentScene=="MainMenu")
    {        
        $.sfScene.show("MainMenuBack");
    }
    $.sfScene.show(AppContext.CurrentScene);
    $.sfScene.focus(AppContext.CurrentScene);
	pluginAPI.setOnScreenSaver();
    
    if ((ScenePlayer.isPlaying != true) && (!ScenePlayer.firstTimeStart))
        ScenePlayer.stop();
}

ScenePlayer.prototype.handleHide = function () {
	Logger.write("ScenePlayer.handleHide()", "Player");
	// this function will be called when the scene manager hide this scene  
}

ScenePlayer.prototype.handleFocus = function () {
	Logger.write("ScenePlayer.handleFocus()", "Player");
	// this function will be called when the scene manager focus this scene
    $.sfScene.hide(AppContext.CurrentScene);
    ScenePlayer.setHelpBar();           
    if  (ScenePlayer.serviceStatus < ServiceStatuses.previewAvailable)
    {
        ScenePlayer.stopAndReturn();
        ErrorHandler.HandleError(Resources.getResources().YouAreNotSubscribedToThisService, "ServicePlayer");
    }
	ScenePlayer.isStopped = false;
	ScenePlayer.isFocused = true;
	if (ScenePlayer.sender != "Radio") {
		pluginAPI.setOffScreenSaver();
	}
}

ScenePlayer.prototype.handleBlur = function () {
	Logger.write("ScenePlayer.handleBlur()", "Player");
	// this function will be called when the scene manager move focus to another scene from this scene
	ScenePlayer.isFocused = false;
}

/*
* Handles num button pressing
*/
ScenePlayer.handleNumPress = function(num){
    if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted) //remove shifted, it's for tests
    {
        ScenePlayer.channelPicker.numPressed(num);
        var currentChannel = ScenePlayer.channelPicker.getCurrentChannel();
        $('#svecVideo2_controller_YQ4I').setChannel(currentChannel);
    }
}

ScenePlayer.handleUpDown = function(){
    return  ScenePlayer.streamType == StreamTypes.archive && ScenePlayer.archProgramPicker != null;
}

ScenePlayer.handlePressUp = function(){
    if (ScenePlayer.handleUpDown())
    {
        ScenePlayer.archProgramPicker.setPrev();
    }
    else if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted)//remove shifted, it's for tests
    {
        ScenePlayer.channelPicker.setPrev();
    } else if (ScenePlayer.streamType == StreamTypes.radio && SceneRadio.channelPicker) {
		SceneRadio.channelPicker.setPrev();
	}
}

ScenePlayer.handlePressDown = function(){
    if (ScenePlayer.handleUpDown()) 
    {
        ScenePlayer.archProgramPicker.setNext();
    }
    else if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted)//remove shifted, it's for tests
    {
        ScenePlayer.channelPicker.setNext();
    } else if (ScenePlayer.streamType == StreamTypes.radio && SceneRadio.channelPicker) {
		SceneRadio.channelPicker.setNext();
	}
}

ScenePlayer.handleChUp = function () {
	if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted) {
		ScenePlayer.channelPicker.setNext();
	}
}

ScenePlayer.handleChDown = function () {
	if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted) {
		ScenePlayer.channelPicker.setPrev();
	}
}

ScenePlayer.jump = {};
ScenePlayer.jump.value = 0;

/*
*
*/
ScenePlayer.handlePressJump = function(value){
	var status = $("svecVideo2_50Z0").sfVideo2("getStatus");
	/*if (status == 2) {
		return; 
	}*/
	
    ScenePlayer.jump.value += value;
    Logger.write("[Player] value to jump = " + ScenePlayer.jump.value, "Player");
    
    if (ScenePlayer.jumpPressed) {
		Logger.write("Jump pressed", "Player");
		var position = ScenePlayer.jump.time + ScenePlayer.jump.value;
		var duration = ScenePlayer.jump.duration;
		
		if (ASXLoader.hasPlayList) {
			var section = ASXLoader.getCurrentSection(position / 1000);
			if (section) {
				position -= section.start * 1000;
				duration = section.duration * 1000;
			}
		}
		
		var progress = position * 100 / duration;
		if (progress > 100) {
			progress = 100;
			if (!ASXLoader.hasPlayList) {
				ScenePlayer.jump.value = ScenePlayer.jump.duration - ScenePlayer.jump.time;
			}
		}
		
         $('#svecVideo2_controller_YQ4I').setProgress(progress);
         
         var totalTime = Helpers.intTimeToString(duration);
         var time = Helpers.intTimeToString(position);
         
         $('#svecVideo2_controller_YQ4I').setTime(time + "/" +totalTime);
         $('#svecVideo2_controller_YQ4I').changeButton((value > 0) ? "forward" : "backward");
    } else {
		Logger.write("Jump isn't pressed", "Player");
        $('#svecVideo2_50Z0').sfVideo2("_pause");
        $('#svecVideo2_controller_YQ4I').changeButton((value > 0) ? "forward" : "backward");   
        
        ScenePlayer.jump.time = $('#svecVideo2_50Z0').sfVideoGetCurrentTime();  
        ScenePlayer.jump.duration = $('#svecVideo2_50Z0').sfVideoGetContentDuration(); 
		
		if (ASXLoader.hasPlayList) {
			ScenePlayer.jump.duration = ASXLoader.getTotalDuration();
		}
		
		var position = ScenePlayer.jump.time + ScenePlayer.jump.value;
		var duration = ScenePlayer.jump.duration;
		
		if (ASXLoader.hasPlayList) {
			var section = ASXLoader.getCurrentSection(position / 1000);
			if (section) {
				position -= section.start * 1000;
				duration = section.duration * 1000;
			}
		}
        
        var progr = position * 100 / duration;
		if (progr > 100) {
			progr = 100;
		}
		
        $('#svecVideo2_controller_YQ4I').setProgress(progr);
        
        var totalTime = Helpers.intTimeToString(duration);
        var time = Helpers.intTimeToString(position);
        $('#svecVideo2_controller_YQ4I').setTime(time + "/" +totalTime);
        
        ScenePlayer.jumpPressed = true;
    }
	
	Logger.write("Clearing and setting timeout", "Player");
    if (ScenePlayer.jumpTimeout) {
        clearTimeout(ScenePlayer.jumpTimeout);
    }
    ScenePlayer.jumpTimeout = setTimeout(ScenePlayer.jump.cb, ScenePlayer.timeoutForJump);
}

ScenePlayer.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("Player", resultCallback);
}


/*
* 
*/
ScenePlayer.jump.cb = function(){
    Logger.write("[Player] jump callback; value = " + ScenePlayer.jump.value, "Player");
    $('#svecVideo2_50Z0').sfVideo2FF(ScenePlayer.jump.value / 1000);
    ScenePlayer.jump.value = 0;
    ScenePlayer.jumpPressed = false;
}


/*
* Hadles key down event
*/
ScenePlayer.prototype.handleKeyDown = function (keyCode) {
	Logger.write("ScenePlayer.handleKeyDown(" + keyCode + ")", "Player");
	// TODO : write an key event handler when this scene get focued
    try
    {
        ScenePlayer.showControls();
        
        switch (keyCode) {
            case $.sfKey.N0:
                ScenePlayer.handleNumPress("0");
                break;
            case $.sfKey.N1:
                ScenePlayer.handleNumPress("1");
                break;
            case $.sfKey.N2:
                ScenePlayer.handleNumPress("2");
                break;
            case $.sfKey.N3:
                ScenePlayer.handleNumPress("3");
                break;
            case $.sfKey.N4:
                ScenePlayer.handleNumPress("4");
                break;
            case $.sfKey.N5:
                ScenePlayer.handleNumPress("5");
                break;
            case $.sfKey.N6:
                ScenePlayer.handleNumPress("6");
                break;
            case $.sfKey.N7:
                ScenePlayer.handleNumPress("7");
                break;
            case $.sfKey.N8:
                ScenePlayer.handleNumPress("8");
                break;
            case $.sfKey.N9:
                ScenePlayer.handleNumPress("9");
                break;
            case $.sfKey.RIGHT:
                break;
            case $.sfKey.UP:
                ScenePlayer.handlePressUp();
                break;
            case $.sfKey.DOWN:
                ScenePlayer.handlePressDown();
                break;
            case $.sfKey.ENTER:
                break;
			case $.sfKey.CH_UP:
				ScenePlayer.handleChUp();
				break;
			case $.sfKey.CH_DOWN:
				ScenePlayer.handleChDown();
				break;
            case $.sfKey.RETURN:
                widgetAPI.blockNavigation(event);
                ScenePlayer.stopAndReturn();
                break;    
             case $.sfKey.PLAY:
                ScenePlayer.play();
                break;
             case $.sfKey.FF:
                Logger.write("[Player] FF", "Player");
                 if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted || ScenePlayer.streamType == StreamTypes.radio) 
                {
                    return;
                }
                ScenePlayer.handlePressJump(ScenePlayer.jumpValue);
                break;
             case $.sfKey.RW:
                Logger.write("[Player] RW", "Player");
                if (ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted || ScenePlayer.streamType == StreamTypes.radio) 
                {
                    return;
                }
                ScenePlayer.handlePressJump(-ScenePlayer.jumpValue);
                break;
             case $.sfKey.STOP:
                ScenePlayer.stopAndReturn();
                break;
            case $.sfKey.BLUE:
                ScenePlayer.handleReturn();
                break;
            case $.sfKey.GREEN:
				if (ScenePlayer.streamType == StreamTypes.radio) {
					return;
				}
                ScenePlayer.handleGreenButton();
                break;
			case $.sfKey.YELLOW:
				if (ScenePlayer.sender == "Series" || ScenePlayer.sender == "ProgramEpisodes") {
					ScenePlayer.autoPlay = !ScenePlayer.autoPlay;
					ScenePlayer.setHelpBar();
				}
                break;
            default:
            //this functionality has treatment for other basic keys in your remote control. 
            // the keys has treatment are: PLAY, STOP, PAUSE, RW, FF
                if ((ScenePlayer.streamType == StreamTypes.live || ScenePlayer.streamType == StreamTypes.shifted || ScenePlayer.streamType == StreamTypes.radio) && (keyCode == $.sfKey.RW || keyCode == $.sfKey.FF || keyCode == $.sfKey.PAUSE))
                {
                    return;
                }
                $('#svecVideo2_50Z0').sfVideo2('RCKeyDefined', keyCode);
                break;
            case $.sfKey.RED:
                $.sfScene.hide('Player');
                $.sfScene.show('Settings');
                $.sfScene.focus('Settings');
                SceneSettings.selectAccount();
                break;
            case $.sfKey.EXIT:
                widgetAPI.blockNavigation(event);
				ScenePlayer.handleExit();
                break;
        }
    }
    catch(ex)
    {
        ScenePlayer.stopAndReturn();
        ErrorHandler.HandleError(ex,"Player");
    }
}
