function SceneMoviesSearchResult(options) {
	this.options = options;    
}

SceneMoviesSearchResult.setHelpbar = function () {
	if (ScenePlayer.isPlaying) {
         $('#keysMoviesSearchResult').sfKeyHelp({
			 'red':Resources.getResources().LabelSettings,
			 'yellow':Resources.getResources().Info,
			 'blue':Resources.getResources().Player,
			 'stop':Resources.getResources().Stop,
			 'updown':'', 'leftright':Resources.getResources().MoveCursor,
			 'enter':Resources.getResources().Select, 
			 'return':Resources.getResources().BackToMainMenu
		 });
     } else {
         $('#keysMoviesSearchResult').sfKeyHelp({
			 'red':Resources.getResources().LabelSettings,
			 'yellow':Resources.getResources().Info,
			 'updown':'', 'leftright':Resources.getResources().MoveCursor,
			 'enter':Resources.getResources().Select,
			 'return':Resources.getResources().BackToMainMenu
         });
     }
}

SceneMoviesSearchResult.prototype.initialize = function () {
	Logger.write("SceneMoviesSearchResult.initialize()", "MoviesSearchResult");  
    SceneMoviesSearchResult.currentLang=AppContext.ClientSettings.Language;
    $('#lblSearchFor').sfLabel({text : Resources.getResources().ToSearch});
    $('#lblSearchResult').sfLabel({text : Resources.getResources().SearchResults});
	$("#moviesSearchResultNoData").html(Resources.getResources().NoData);
    SceneMoviesSearchResult.setHelpbar();
    SceneMoviesSearchResult.initData();
}

SceneMoviesSearchResult.translate = function () {
	if (SceneMoviesSearchResult.currentLang != AppContext.ClientSettings.Language) {
		$('#lblSearchFor').sfLabel({text : Resources.getResources().ToSearch});
		$('#lblSearchResult').sfLabel({text : Resources.getResources().SearchResults});
		$("#moviesSearchResultNoData").html(Resources.getResources().NoData);
		var sortingOrders = [ new PanelElement("item_date", Resources.getResources().Date), new PanelElement("name", Resources.getResources().Name), new PanelElement("rating", Resources.getResources().Rating)];
		this.sortingPanel.focusElement(0);
		this.sortingPanel.loadData(sortingOrders);
		this.sortingPanel.invokeSelectedChangedCallback();
		SceneMoviesSearchResult.currentLang = AppContext.ClientSettings.Language;
	}
}

SceneMoviesSearchResult.initData = function () {
	this.onPage = 50;
	this.moviesPanel = new MoviesPanel(125,80, 815, 80, 5, function() {}, "panelSearchedMovies", function() {}, function() { SceneMoviesSearchResult.hideLoading(); },130, false, 49);
	this.moviesPanel.itemPrefix = "searchedMovie";
	$(this.moviesPanel.panel).css('visibility', 'collapse');
	$('#divMoviesSearchPanel').append(this.moviesPanel.panel);
	var sortingOrders = [  new PanelElement("item_date", Resources.getResources().Date) ,new PanelElement("name", Resources.getResources().Name), new PanelElement("rating", Resources.getResources().Rating)];                      
	this.sortingPanel = new SlidingPanel(80, 80, sortingOrders, "SearchedSortBy", this.onSortingOrderChanged, 150, orientations.horizontal, false, 1000); 
	$('#SearchResultSortPanel').append(this.sortingPanel.panel);
}

SceneMoviesSearchResult.loadResults = function (searchWord, sender) {
    Logger.write("SceneMoviesSearchResult.loadResults("+searchWord+")", "MoviesSearchResult");
    SceneMoviesSearchResult.showLoading();
	$("#moviesSearchResultNoData").hide();
    sender = sender || "Movies2";
	SceneMoviesSearchResult.sender = sender;
	SceneMoviesSearchResult.searchWord = searchWord;
    $('#lblSearchFor').sfLabel({text : Resources.getResources().ToSearch+ " '"+searchWord+"'"});
	$("#divMoviesSearchPanel").hide();
	SceneMoviesSearchResult.loadMovies();
}

SceneMoviesSearchResult.onMoviesLoaded = function (result) {
	if (result.items && result.items.length > 0) {
		$("#divMoviesSearchPanel").show();
		SceneMoviesSearchResult.bindMovies(result);
		$(SceneMoviesSearchResult.moviesPanel.panel).css('visibility', 'visible');
		SceneMoviesSearchResult.focusMoviesPanel();
	} else {
		$(SceneMoviesSearchResult.moviesPanel.panel).css('visibility', 'collapse');
		SceneMoviesSearchResult.moviesPanel.clear();
		SceneMoviesSearchResult.focusSortPanel();
		$("#moviesSearchResultNoData").show();
	}
	
	SceneMoviesSearchResult.hideLoading();
}

SceneMoviesSearchResult.loadMovies = function (page) {
	SceneMoviesSearchResult.showLoading();
	page = page || 1;
	var errCallback = function(jqXHR, textStatus, error) {
		 ErrorHandler.HandleError(error,"MoviesSearchResult",true, textStatus, jqXHR);
	};
	JsonServices.content.GetClientOnDemandContent(
		AppContext.user.sid, "SearchByName", null, SceneMoviesSearchResult.searchWord, null,
		SceneMoviesSearchResult.onPage, page,
		SceneMoviesSearchResult.onMoviesLoaded, errCallback
	);
}

SceneMoviesSearchResult.bindMovies = function (movies) {
	movies.items = movies.items || [];
	var finalCount = movies.paging.totalItems;
	
    SceneMoviesSearchResult.paging = movies.paging;
    this.lastPage = movies.paging.pageNumber == movies.paging.totalPages;
	this.moviesPanel.paging = movies.paging;
	
    (movies.paging.pageNumber == 1) ? this.moviesPanel.loadData(movies.items, "", finalCount) : this.moviesPanel.addData(movies.items);    
    $(this.moviesPanel.panel).css('visibility', 'visible');
}

SceneMoviesSearchResult.onSortingOrderChanged = function (orderId) {
	if (SceneMoviesSearchResult.moviesPanel && SceneMoviesSearchResult.moviesPanel.movies && SceneMoviesSearchResult.moviesPanel.movies.length > 0) {
		SceneMoviesSearchResult.showLoading();
		
		var regex = /^\#divSearchedSortBy(\w+)/;
		var result = regex.exec(orderId);
		SceneMoviesSearchResult.moviesPanel.sortMovies(result[1]);
		
		SceneMoviesSearchResult.hideLoading();
	}
}

SceneMoviesSearchResult.show = function () {
    $.sfScene.show('MoviesSearchResult');
    $.sfScene.focus('MoviesSearchResult');
    SceneMoviesSearchResult.setHelpbar();
}

SceneMoviesSearchResult.showLoading = function () {
    SceneMoviesSearchResult.isLoading = true;
	if (AppContext.CurrentScene == "MoviesSearchResult") {
		Helpers.showLoading();
	}
}

SceneMoviesSearchResult.hideLoading = function () {
    SceneMoviesSearchResult.isLoading = false;
	if (AppContext.CurrentScene == "MoviesSearchResult") {
		Helpers.hideLoading();
	}
}

SceneMoviesSearchResult.focusSortPanel = function() {
    this.moviesPanel.blur();
    this.activePanel = "sortingPanel";
    this[this.activePanel].focusPanel();
}

SceneMoviesSearchResult.focusMoviesPanel = function () {
    this.sortingPanel.blurPanel();
    this.activePanel = "moviesPanel";
    this[this.activePanel].focus();   
}

SceneMoviesSearchResult.back = function() {
    try {
		$.sfScene.hide('MoviesSearchResult');
		$.sfScene.show(SceneMoviesSearchResult.sender);
		$.sfScene.focus(SceneMoviesSearchResult.sender); 
    } catch (error) {
		ErrorHandler.HandleError(error,"MoviesSearchResult");  
    }  
}

SceneMoviesSearchResult.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("MoviesSearchResult", resultCallback);
}

/*
Plays movie
*/
SceneMoviesSearchResult.play = function(){
    var movie = this.moviesPanel.getCurrentMovie();
	var callback = function (response) {
		try {
			$.sfScene.hide(AppContext.CurrentScene);
			$.sfScene.show('Player');
			movie.url = response.URL;
			movie.playlist = response.Playlist;
			movie.contentType = "VOD";
			ScenePlayer.setContent(movie, "MoviesSearchResult");
			SceneMoviesSearchResult.setHelpbar();
			$.sfScene.focus('Player'); 
		} catch (error) {
			ErrorHandler.HandleError(error,"MoviesSearchResult");  
		}  
    }
    var errCallback = function (jqXHR, textStatus, error) {
		ErrorHandler.HandleError(error,"MoviesSearchResult",true, textStatus, jqXHR);  
	} 
    
	JsonServices.media.GetClientStreamUri(AppContext.user.sid, "VOD", movie.id,
		AppContext.ClientSettings.bAId, AppContext.ClientSettings.cdnId,
		AppContext.ClientSettings.qualityPreset, AppContext.ClientSettings.shiftTimeZoneName,
		callback, errCallback
	);
}


SceneMoviesSearchResult.handleEnter = function () {
    try {
		if (this.activePanel.indexOf("moviesPanel") != -1) {
			var movie = this.moviesPanel.getCurrentMovie();
			var hasSeries = movie.isContainer && movie.episodeNum === 1 || movie.episodeNum > 1;
			if (hasSeries) {
				$.sfScene.hide(AppContext.CurrentScene);
				SceneSeries.setMovie(movie, "MoviesSearchResult");
			} else {
				SceneMoviesSearchResult.play();
			}
		}
    } catch (error) {
		ErrorHandler.HandleError(error,"MoviesSearchResult");  
    }  
}

SceneMoviesSearchResult.handleYellow = function(){
	if (SceneMoviesSearchResult.isLoading) {
		return;
	}
	if (this.activePanel.indexOf("moviesPanel") != -1) {
		var movie = this.moviesPanel.getCurrentMovie();
		ScenePopUp.setWindow("MoviesSearchResult", movie);          
		ScenePopUp.show();
	}
}

SceneMoviesSearchResult.handleLeft = function()
{
	if (SceneMoviesSearchResult.isLoading) {
		return;
	}
    try {
		if (this.activePanel.indexOf("sortingPanel") != -1) {
			this.sortingPanel.focusPrev();
		}
    } catch (error) {
		ErrorHandler.HandleError(error,"MoviesSearchResult");  
    }  
}

SceneMoviesSearchResult.handleRight = function()
{
	if (SceneMoviesSearchResult.isLoading) {
		return;
	}
    try {
		if (this.activePanel.indexOf("sortingPanel") != -1) {
			this.sortingPanel.focusNext();
		}
    } catch (error) {
		ErrorHandler.HandleError(error,"MoviesSearchResult");  
    }  
}

SceneMoviesSearchResult.handleUp = function()
{
	if (SceneMoviesSearchResult.isLoading) {
		return;
	}
    try {
		if (this.activePanel.indexOf("moviesPanel") != -1) {
			if (this.moviesPanel.index > 0) {
				this.moviesPanel.focusPrev();
			} else {
				this.focusSortPanel();
			}
		}
    } catch (error) {
		ErrorHandler.HandleError(error,"MoviesSearchResult");  
    }  
}

SceneMoviesSearchResult.handleDown = function()
{
	if (SceneMoviesSearchResult.isLoading) {
		return;
	}
    try {
		if (this.activePanel.indexOf("moviesPanel") != -1) {
			var page = this.paging.pageNumber;
			var total = this.paging.totalPages;
			if (this.moviesPanel.isLastItem() && page < total) {
				this.loadMovies(page + 1);
			} else {
				this.moviesPanel.focusNext();
			}
		} else if (this.moviesPanel.movies && this.moviesPanel.movies.length > 0) {
			this.focusMoviesPanel();
		}
    } catch(error) {
		ErrorHandler.HandleError(error,"MoviesSearchResult");  
    }  
}

SceneMoviesSearchResult.prototype.handleShow = function () {
	Logger.write("SceneMoviesSearchResult.handleShow()", "MoviesSearchResult");
	// this function will be called when the scene manager show this scene 
      SceneMoviesSearchResult.translate();    
}

SceneMoviesSearchResult.prototype.handleHide = function () {
	Logger.write("SceneMoviesSearchResult.handleHide()", "MoviesSearchResult");
	// this function will be called when the scene manager hide this scene  
	Helpers.hideLoading();
}

SceneMoviesSearchResult.prototype.handleFocus = function () {
	Logger.write("SceneMoviesSearchResult.handleFocus()", "MoviesSearchResult");
	// this function will be called when the scene manager focus this scene
    AppContext.CurrentScene = "MoviesSearchResult";
    if  (ScenePlayer.isPlaying == true)
    {
            Helpers.setBackgroundOpacity();
    } 
    SceneMoviesSearchResult.setHelpbar();
	if (SceneMoviesSearchResult.isLoading) {
		Helpers.showLoading();
	}
}

SceneMoviesSearchResult.prototype.handleBlur = function () {
	Logger.write("SceneMoviesSearchResult.handleBlur()", "MoviesSearchResult");
	// this function will be called when the scene manager move focus to another scene from this scene
   SceneMainMenu.unfocusButton(SceneMainMenu.currentIndex);    
}

SceneMoviesSearchResult.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneMoviesSearchResult.handleKeyDown(" + keyCode + ")", "MoviesSearchResult");
	// TODO : write an key event handler when this scene get focued
	if (Helpers.handleGlobalKeys(keyCode)) {
		return;
	}
	switch (keyCode) {
		case $.sfKey.LEFT:
            SceneMoviesSearchResult.handleLeft();
			break;
		case $.sfKey.RIGHT:
            SceneMoviesSearchResult.handleRight();
			break;
		case $.sfKey.UP:
            SceneMoviesSearchResult.handleUp();
			break;
		case $.sfKey.DOWN:
            SceneMoviesSearchResult.handleDown();
			break;
		case $.sfKey.ENTER:
            SceneMoviesSearchResult.handleEnter();
			break;
        case $.sfKey.RETURN:
            widgetAPI.blockNavigation(event);
            SceneMoviesSearchResult.back();
			break;
        case $.sfKey.STOP:
            if  (ScenePlayer.isPlaying == true)
            {
				ScenePlayer.stop();
				SceneMoviesSearchResult.setHelpbar();
            }
            break;		
        case $.sfKey.BLUE:
            if  (ScenePlayer.isPlaying == true)
            {
				$.sfScene.hide('MoviesSearchResult');
				$.sfScene.show('Player');
				$.sfScene.focus('Player');
            }
            break;
        case $.sfKey.YELLOW:
            try
            {
                SceneMoviesSearchResult.handleYellow();
            }
            catch (error)
            {
				ErrorHandler.HandleError(error,"MoviesSearchResult");
            }
            finally
            {
				break;
            }
		case $.sfKey.RED:
            try
            {
                $.sfScene.hide('MoviesSearchResult');
                $.sfScene.show('Settings');
                $.sfScene.focus('Settings');
                SceneSettings.selectAccount();
            }
            catch(error)
            {
                ErrorHandler.HandleError(error,"MoviesSearchResult");  
            }
            break;
		case $.sfKey.EXIT:
            try
            {
                widgetAPI.blockNavigation(event);
				SceneMoviesSearchResult.handleExit();
            }
            catch(error)
            {
                ErrorHandler.HandleError(error,"MoviesSearchResult");  
            }
            break;
        default:
            widgetAPI.blockNavigation(event);
            break;
	}
}
