function SceneMainMenu(options) {
	this.options = options;
}
    /*
        Translates labels to current language
    */ 
SceneMainMenu.translate = function() {
	$('.lblLiveTv').sfLabel({text: Resources.getResources().LabelLiveTv});
	$('.lblArchTv').sfLabel({text: Resources.getResources().LabelArchTv});
	$('.lblArchPlus').sfLabel({text: Resources.getResources().LabelArchPlus});
	$('.lblMovies2').sfLabel({text: Resources.getResources().LabelMovies});
	$('.lblFavMovies').sfLabel({text: Resources.getResources().LabelFavMovies});
	$('.lblFavorites').sfLabel({text: Resources.getResources().LabelFavorites});
	$('.lblRadio').sfLabel({text: Resources.getResources().LabelRadio});
	$('#lblMainMenuTitle').sfLabel({text:Resources.getResources().LabelMainMenu.toLowerCase()});
	$('#lblSettings').empty();
	$('#lblSettings').append(Resources.getResources().LabelSettings); 
	SceneMainMenu.setHelpBar();
}

SceneMainMenu.prototype.initialize = function () {
	Logger.write("SceneMainMenu.initialize()", "MainMenu");   
	// this function will be called only once when the scene manager show this scene first time
	// initialize the scene controls and styles, and initialize your variables here 
	// scene HTML and CSS will be loaded before this function is called 
	$('#imgSettings').sfImage({src:'images/icon-settings.png'});
	SceneMainMenu.loadMenu();
}

SceneMainMenu.setHelpBar = function(){
    if (ScenePlayer.isPlaying)
    {
            $('#keysMainMenu').sfKeyHelp({
            'return': Resources.getResources().Quit,
			'red':Resources.getResources().LabelSettings, 
			'blue':Resources.getResources().Player, 
			'stop':Resources.getResources().Stop, 
			'updown':'', 'leftright':Resources.getResources().MoveCursor, 
			'enter':Resources.getResources().Select});                
    }
    else
    {
            $('#keysMainMenu').sfKeyHelp({
            'return': Resources.getResources().Quit,
			'red':Resources.getResources().LabelSettings, 
			'updown':'', 'leftright':Resources.getResources().MoveCursor, 
			'enter':Resources.getResources().Select});                
    }
}

SceneMainMenu.loadMenu = function () {
	$('#loadingObject').sfLoading('show');
	SceneMainMenu.currentLang = null;
        
    SceneMainMenu.scenes = new Array('LiveTv', 'ArchTv', 'ArchPlus', 'Movies2'/*, 'FavMovies'*/, 'Favorites', 'Radio'); 
    var scenesArray = new Array;
    SceneMainMenu.buttons = new Array;
    htmlMenu = "<div id='menu'>";
    SceneMainMenu.servicesCount = 0;
    for (key in SceneMainMenu.scenes) {
        if (Helpers.checkScene(SceneMainMenu.scenes[key], "NA", false)) {
            scenesArray.push(SceneMainMenu.scenes[key]);
            SceneMainMenu.buttons.push("#img"+ SceneMainMenu.scenes[key]);
            Logger.write("[Main Menu] added "+ SceneMainMenu.scenes[key] + " scene", "MainMenu");
            htmlMenu += "<img width = '"+256+"px' height = '"+360+"px' style='opacity:0.5' id='img"+SceneMainMenu.scenes[key]+"' title="+SceneMainMenu.scenes[key]+"></img>";
            SceneMainMenu.servicesCount++;
        }
    }
    htmlMenu += "</div>";
    $("#mmenu").html(htmlMenu);
    SceneMainMenu.scenes = scenesArray;

    SceneMainMenu.currentIndex = 0;
    SceneMainMenu.maxWidth = 960;
	$('#imgLiveTv').sfImage({src:'images/Live.png'});
    $('#imgArchTv').sfImage({src:'images/Replay.png'});
    $('#imgArchPlus').sfImage({src:'images/Archive.png'});
    $('#imgMovies2').sfImage({src:'images/Kinozal.png'});
    //$('#imgFavMovies').sfImage({src:'images/VOD_fav.png'});
    $('#imgFavorites').sfImage({src:'images/Favorites.png'});
    $('#imgRadio').sfImage({src:'images/Radio.png'});
    $("#mmenu").hide();
    var dockOptions =
      { align: 'middle'
      , size: 180 
      , bias: '20px'
      , labels:'mc'
      , setLabel: function(t, i, el){
          $('<div align="center" class="lbl'+t+'  theDockLabel"></div>')
            .appendTo($(el).show());
          return false;
        }
        , onReady: function(){
				SceneMainMenu.translate();
				SceneMainMenu.changeButtonFocus(-1, 0);
				$("#mmenu").css({"margin-left": (70*(6 - SceneMainMenu.servicesCount) + 30).toString()+"px"});
				$("#mmenu").show();
				$('#loadingObject').sfLoading('hide');
            }
      };
	  
  $('#menu').jqDock(dockOptions);
}


/*
    Slides MainMenuScene if focused element is not visible
*/
SceneMainMenu.slideMenu = function()
{
    var left = parseInt($(this.buttons[this.currentIndex]).css('left'));
    var imgName = "#img" + this.buttons[this.currentIndex].substring(4);
    var width = parseInt($(imgName).css('width'));
    var menuLeft = parseInt($('#SceneMainMenu').css('left'));
    
    var result = left + width;
    Logger.write(imgName, "MainMenu");
    Logger.write("width:"+width, "MainMenu");
    
    if ((result + menuLeft > this.maxWidth))
    {
        $('#SceneMainMenu').animate({ left: (this.maxWidth-result-100) }, 300);
    }
    else if (left + menuLeft < 0)
    {
        $('#SceneMainMenu').animate({ left: -left+100 }, 300);
    }
}

/*
    Focuses next element in menu
*/
SceneMainMenu.focusNextButton = function()
{
    try
    {
		var curInd = this.currentIndex;
		if (curInd < (this.buttons.length - 1))
		{
			this.currentIndex++;
			
			this.changeButtonFocus(curInd, this.currentIndex);
		}
		else
		{
			this.currentIndex = 0;
			this.changeButtonFocus(curInd, this.currentIndex);
		}
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"MainMenu");  
    }
}

/*
    Focuses previous element in menu
*/
SceneMainMenu.focusPrevButton = function()
{
    try
    {
		var curInd = this.currentIndex;
		if (curInd > 0)
		{
			this.currentIndex--;
			
			this.changeButtonFocus(curInd, this.currentIndex);
		}
		else
		{
			this.currentIndex = this.buttons.length - 1;
			this.changeButtonFocus(curInd, this.currentIndex);
		}
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"MainMenu");  
    }
}

/*
    Focuses element with "newFocusIndex" and blurs one with "currentFocusIndex"
    
    *currentFocusIndex - index of the element to blur
    *newFocusIndex - index of the element to focus
*/
SceneMainMenu.changeButtonFocus = function(currentFocusIndex, newFocusIndex)
{
    Logger.write("SceneMainMenu.changeButtonFocus()", "MainMenu");
    try
    {
        $("#mmenu .lbl"+SceneMainMenu.scenes[newFocusIndex]).hide();
        $("#mmenu .lbl"+SceneMainMenu.scenes[currentFocusIndex]).removeClass("theMenuItemLabel");
        $('#menu img').eq(newFocusIndex).jqDock('expand');
        this.unfocusButton(currentFocusIndex);
        this.focusButton(newFocusIndex);
        
       $("#mmenu .lbl"+SceneMainMenu.scenes[newFocusIndex]).addClass("theMenuItemLabel");
       $("#mmenu .lbl"+SceneMainMenu.scenes[newFocusIndex]).fadeIn();
    }
    catch(error)
    {
            ErrorHandler.HandleError(error,"MainMenu");  
    }
}

/*
    Focuses element with index "buttonIndex"
    
    *buttonIndex - index of the element to focus
*/
SceneMainMenu.focusButton = function(buttonIndex)
{
    try
    {
		$(this.buttons[buttonIndex]).css('opacity', '1');
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"MainMenu");  
    }
}

/*
    Blurs element with index "buttonIndex"
    
    *buttonIndex - index of the element to blur
*/
SceneMainMenu.unfocusButton = function(buttonIndex)
{
    try
    {
		$(this.buttons[buttonIndex]).css('opacity', '0.5');
     }
    catch(error)
    {
		ErrorHandler.HandleError(error,"MainMenu");  
    }
}

/*
    Opens current selected element
*/
SceneMainMenu.openMenuItem = function()
{
    try
    {
		$.sfScene.hide('MainMenuBack');
		$.sfScene.hide('MainMenu');
		var scene = this.scenes[this.currentIndex];
		$.sfScene.show(scene);
		$.sfScene.focus(scene);
    }
    catch(error)
    {
		ErrorHandler.HandleError(error,"MainMenu");  
    }
}

SceneMainMenu.show = function()
{
    $.sfScene.show('MainMenu');
    $.sfScene.focus('MainMenu');
}

SceneMainMenu.focusMenu = function () {
	Logger.write("Focusing menu", "MainMenu");
	$("#panelSettings").css({'opacity':'0.5'});
    $("#lblSettings").css({'color':'#72C6F8'});
    $("#lblSettings").animate({'font-size':'16pt'},200);
	SceneMainMenu.focusButton(SceneMainMenu.currentIndex);
	SceneMainMenu.focused = "menu";
	Logger.write("Menu focused", "MainMenu");
}

SceneMainMenu.focusSettings = function () {
	Logger.write("Focusing settings", "MainMenu");
	SceneMainMenu.unfocusButton(SceneMainMenu.currentIndex);
	$("#panelSettings").css({'opacity':'1'});
	$("#lblSettings").css({'color':'#fff'});
	$("#lblSettings").animate({'font-size':'18pt'},200);
	SceneMainMenu.focused = "settings";
	Logger.write("Settings focused", "MainMenu");
}

SceneMainMenu.handleUpDown = function () {
	if (SceneMainMenu.focused === "settings") {
		SceneMainMenu.focusMenu();
	} else {
		SceneMainMenu.focusSettings();
	}
}

SceneMainMenu.handleLeft = function () {
	if (SceneMainMenu.focused === "menu") {
		SceneMainMenu.focusPrevButton();
	}
}

SceneMainMenu.handleRight = function () {
	if (SceneMainMenu.focused === "menu") {
		SceneMainMenu.focusNextButton();
	}
}

SceneMainMenu.handleEnter = function () {
	if (SceneMainMenu.focused === "menu") {
		ErrorHandler.NeedToRefresh["LiveTv"] = true;
		SceneMainMenu.openMenuItem();
	} else {
		$.sfScene.hide('MainMenu');
		$.sfScene.show("Settings");
		$.sfScene.focus("Settings");
	}
}


SceneMainMenu.handleReturn = function () {
	var resultCallback = function (result) {
		if (result) {
			$("#loadingObject").sfLoading("show");
			widgetAPI.sendReturnEvent();
		}
	};
	SceneDialogPopUp.showExitDialog("MainMenu", resultCallback);
}

SceneMainMenu.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("MainMenu", resultCallback);
}

SceneMainMenu.prototype.handleShow = function () {
	Logger.write("SceneMainMenu.handleShow()", "MainMenu");
	// this function will be called when the scene manager show this scene 
    SceneMainMenu.translate();
    SceneMainMenu.showed = true;
}

SceneMainMenu.prototype.handleHide = function () {
	Logger.write("SceneMainMenu.handleHide()", "MainMenu");
	// this function will be called when the scene manager hide this scene  
    SceneMainMenu.showed = false;
}

SceneMainMenu.prototype.handleFocus = function () {
	Logger.write("SceneMainMenu.handleFocus()", "MainMenu");
	// this function will be called when the scene manager focus this scene
     SceneMainMenu.focusButton(SceneMainMenu.currentIndex);
	 if (ErrorHandler.NeedToRefresh["MainMenu"]) {
		ErrorHandler.NeedToRefresh["MainMenu"] = false;
		SceneMainMenu.loadMenu();
	 }
	 if (SceneUpdatePopUp.active) {
		/*$.sfScene.show("UpdatePopUp");
		$.sfScene.focus("UpdatePopUp");*/
		SceneUpdatePopUp.show(Updater.message, "MainMenu");
	 }
	 AppContext.CurrentScene = "MainMenu";
	 
	SceneMainMenu.setHelpBar();
	SceneMainMenu.focusMenu();
}

SceneMainMenu.prototype.handleBlur = function () {
	Logger.write("SceneMainMenu.handleBlur()", "MainMenu");
	// this function will be called when the scene manager move focus to another scene from this scene
    SceneMainMenu.unfocusButton(SceneMainMenu.currentIndex);
}

SceneMainMenu.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneMainMenu.handleKeyDown(" + keyCode + ")", "MainMenu");
	// TODO : write an key event handler when this scene get focued
	if (Helpers.handleGlobalKeys(keyCode)) {
		return;
	}
	switch (keyCode) {
		case $.sfKey.LEFT:
            SceneMainMenu.handleLeft();
			break;
		case $.sfKey.RIGHT:
            SceneMainMenu.handleRight();
			break;
		case $.sfKey.UP:
            SceneMainMenu.handleUpDown();
			break;
		case $.sfKey.DOWN:
            SceneMainMenu.handleUpDown();
			break;
		case $.sfKey.RETURN:
            widgetAPI.blockNavigation(event);
			SceneMainMenu.handleReturn();
			break;
        case $.sfKey.STOP:
            if  (ScenePlayer.isPlaying == true)
            {
                    ScenePlayer.stop();
                    SceneMainMenuBack.setHelpBar();
            }
            break;
		case $.sfKey.ENTER:
            SceneMainMenu.handleEnter();
			break;
		case $.sfKey.BLUE:
            if  (ScenePlayer.isPlaying == true)
            {
                    $.sfScene.hide('MainMenuBack');
                    $.sfScene.show('Player');
                    $.sfScene.focus('Player');
            }
            break;
		case $.sfKey.RED:
            try
            {
                $.sfScene.hide('MainMenuBack');
                $.sfScene.hide('MainMenu');
                $.sfScene.show('Settings');
                $.sfScene.focus('Settings');
                SceneSettings.selectAccount();
            }
            catch(error)
            {
                ErrorHandler.HandleError(error,"MainMenu");  
            }  
            break;
		case $.sfKey.EXIT:
            try
            {
                widgetAPI.blockNavigation(event);
                SceneMainMenu.handleExit();
            }
            catch(error)
            {
                ErrorHandler.HandleError(error,"MainMenu");  
            }  
            break;        
        default:         
            widgetAPI.blockNavigation(event);
            break;
	}
}