/**
 * @author Samsung
 */
function SceneErrorPopUp(options) {
	this.options = options;
}

SceneErrorPopUp.prototype.initialize = function () {
	Logger.write("SceneErrorPopUp.initialize()", "ErrorPopUp");
   // $("#CloseImage").sfImage({src:"images/Close.png"});
    $("#OkButton").sfButton({text:"Ok"});    
    $("#OkButton").sfButton("focus");   
 }
 
 SceneErrorPopUp.backTo = null;
 
/*
    Closes error scene
*/
SceneErrorPopUp.close = function(){ 
    $.sfScene.hide('ErrorPopUp');
    var sender = $('#SceneErrorPopUp').data("sender");
    
    $('#SceneErrorPopUp').data(null);
    sender = sender.replace("Service","");
	if ((sender == "Player") && (SceneErrorPopUp.backTo == null))
	{
       $.sfScene.focus(AppContext.CurrentScene); 	
	}
	else
	{
        if (SceneErrorPopUp.backTo != null)
        {
            sender = SceneErrorPopUp.backTo;
            SceneErrorPopUp.backTo = null;
        }
        
		$.sfScene.hide(AppContext.CurrentScene);
		if(sender != "MainMenu")
		{
			$.sfScene.show(sender);
			$.sfScene.focus(sender); 
		}
		else
		{
            SceneMainMenu.show();
		}
	}
    Logger.write("----hiding error pop up", "ErrorPopUp");
}

SceneErrorPopUp.handleExit = function () {
	SceneErrorPopUp.close();
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog(AppContext.CurrentScene, resultCallback);
}

SceneErrorPopUp.prototype.handleShow = function () {
	Logger.write("SceneErrorPopUp.handleShow()", "ErrorPopUp");
	// this function will be called when the scene manager show this scene 
    $("#ErrorPopUpTitle").sfLabel({text:Resources.getResources().Error});   
}

SceneErrorPopUp.prototype.handleHide = function () {
	Logger.write("SceneErrorPopUp.handleHide()", "ErrorPopUp");
	// this function will be called when the scene manager hide this scene     

}

SceneErrorPopUp.prototype.handleFocus = function () {
	Logger.write("SceneErrorPopUp.handleFocus()", "ErrorPopUp");
	// this function will be called when the scene manager focus this scene 
    $("#SceneErrorPopUp").css({'z-index':9999});
  var errorMessage= $('#SceneErrorPopUp').data("error");
  Logger.write("------err="+errorMessage, "ErrorPopUp");
    $("#ErrorPopUpDescription").sfLabel({text:errorMessage});   
}

SceneErrorPopUp.prototype.handleBlur = function () {
	Logger.write("SceneErrorPopUp.handleBlur()", "ErrorPopUp");
	// this function will be called when the scene manager move focus to another scene from this scene    
    $("#SceneErrorPopUp").css({'z-index':-1});    
}

SceneErrorPopUp.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneErrorPopUp.handleKeyDown(" + keyCode + ")", "ErrorPopUp");
	// TODO : write an key event handler when this scene get focued
	switch (keyCode) {
        case $.sfKey.LEFT:
			break;
		case $.sfKey.RIGHT:
			break;
		case $.sfKey.UP:
			break;
		case $.sfKey.DOWN:
			break;
		case $.sfKey.ENTER:
            SceneErrorPopUp.close();
			break;
		case $.sfKey.RETURN:        
            widgetAPI.blockNavigation(event);
            SceneErrorPopUp.close();
			break;
        case $.sfKey.EXIT:
			widgetAPI.blockNavigation(event);
            SceneErrorPopUp.handleExit();      
            break;         
        default:         
            widgetAPI.blockNavigation(event);
            break;
	}
}
