function SceneDialogPopUp(options) {
	this.options = options;
	

}

SceneDialogPopUp.active = false;

SceneDialogPopUp.prototype.initialize = function () {
	Logger.write("SceneDialogPopUp.initialize()", "TextboxPopUp");
	SceneDialogPopUp.init();
}

SceneDialogPopUp.init = function () {
	$('#btnDialogYes').sfButton({text : 'Yes'});
    $('#btnDialogNo').sfButton({text : 'No'});
	SceneDialogPopUp.focuses = {
		yes: 1,
		no: 2
	};
	SceneDialogPopUp.focused = 0;
}

SceneDialogPopUp.translate = function () {
	if (SceneDialogPopUp.currentLang != AppContext.ClientSettings.Language) {
		SceneDialogPopUp.currentLang = AppContext.ClientSettings.Language;
		$('#btnDialogYes').sfButton({text:Resources.getResources().DialogYes, width:'140px'});
		$('#btnDialogNo').sfButton({text:Resources.getResources().DialogNo, width:'140px'});
	}
}

SceneDialogPopUp.show = function (message, sender, resultCallback) {
	Logger.write("SceneDialogPopUp.show('" + message + "', " + sender + ")", "DialogPopUp", true);
	SceneDialogPopUp.sender = sender;
	SceneDialogPopUp.message = message;
	$.sfScene.show("DialogPopUp");
	$.sfScene.focus("DialogPopUp");
	SceneDialogPopUp.focusNoButton();
	SceneDialogPopUp.resultCallback = resultCallback || function () {};
}

SceneDialogPopUp.showExitDialog = function (sender, resultCallback) {
	var message = Resources.getResources().DialogExitMessage;
	SceneDialogPopUp.show(message, sender, resultCallback);
}

SceneDialogPopUp.close = function () {
	$.sfScene.hide("DialogPopUp");
	$.sfScene.show(SceneDialogPopUp.sender);
	$.sfScene.focus(SceneDialogPopUp.sender);
}

SceneDialogPopUp.focusYesButton = function () {
	$('#btnDialogYes').sfButton("focus");
	$('#btnDialogNo').sfButton("blur");
	SceneDialogPopUp.focused = SceneDialogPopUp.focuses.yes;
}

SceneDialogPopUp.focusNoButton = function () {
	$('#btnDialogYes').sfButton("blur");
	$('#btnDialogNo').sfButton("focus");
	SceneDialogPopUp.focused = SceneDialogPopUp.focuses.no;
}

SceneDialogPopUp.handleLeft = function () {
	SceneDialogPopUp.focusYesButton();
}

SceneDialogPopUp.handleRight = function () {
	SceneDialogPopUp.focusNoButton();
}

SceneDialogPopUp.handleEnter = function () {
	if (SceneDialogPopUp.focused == SceneDialogPopUp.focuses.yes) {
		SceneDialogPopUp.close();
		SceneDialogPopUp.resultCallback(true);
	} else {
		SceneDialogPopUp.close();
		SceneDialogPopUp.resultCallback(false);
	}
}

SceneDialogPopUp.prototype.handleShow = function () {
	alert("SceneDialogPopUp.handleShow()");
	// this function will be called when the scene manager show this scene
	SceneDialogPopUp.translate();
}

SceneDialogPopUp.prototype.handleHide = function () {
	alert("SceneDialogPopUp.handleHide()");
	// this function will be called when the scene manager hide this scene  
	SceneDialogPopUp.active = false;
}

SceneDialogPopUp.prototype.handleFocus = function () {
	alert("SceneDialogPopUp.handleFocus()");
	// this function will be called when the scene manager focus this scene
	$("#dialogMessage").sfLabel({text: SceneDialogPopUp.message});
	SceneDialogPopUp.active = true;
}

SceneDialogPopUp.prototype.handleBlur = function () {
	alert("SceneDialogPopUp.handleBlur()");
	// this function will be called when the scene manager move focus to another scene from this scene
}

SceneDialogPopUp.prototype.handleKeyDown = function (keyCode) {
	alert("SceneDialogPopUp.handleKeyDown(" + keyCode + ")");
	// TODO : write an key event handler when this scene get focued
	switch (keyCode) {
		case $.sfKey.LEFT:
			SceneDialogPopUp.handleLeft();
			break;
		case $.sfKey.RIGHT:
			SceneDialogPopUp.handleRight();
			break;
		case $.sfKey.UP:
			break;
		case $.sfKey.DOWN:
			break;
		case $.sfKey.RETURN:
            widgetAPI.blockNavigation(event);
            SceneDialogPopUp.close();
			break;
		case $.sfKey.ENTER:
			SceneDialogPopUp.handleEnter();
			break;
	}
}
