/**
 * @author EvgeniyV
 */
 
function SceneDescribeApp(options) {
	this.options = options;
}


SceneDescribeApp.handleReturn = function () {
    $.sfScene.hide('DescribeApp');
    $.sfScene.show('Login');
    $.sfScene.focus('Login');
}

SceneDescribeApp.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("DescribeApp", resultCallback);
}

/*
* Sets current button
*/
SceneDescribeApp.loadPanel = function () {
	var opts = { focusedItemClassName : "" };
	SceneDescribeApp.contentPanel = new MoviesPanel(156,132,696,104,3, function(){}, "describeAppContentPanel",function(){},function(){},130, false, 49, opts);
	$("#panelDescribeAppContent").append(SceneDescribeApp.contentPanel.panel);
	
	var elems = new Array;
	try {
		if (Registration) {
			for (key in Registration.services) {
				var service = Registration.services[key];
				if (service.enabled) {
					var resourceName = "Registration" + service.name + "Description";
					var imgSrc = "images/registration/reg_icon_" + service.name.toLowerCase() + ".png";
					elems.push({
						description: Resources.getResources()[resourceName],
						imgSrc: imgSrc,
						imgWidth: 104,
						imgHeight: 104
					});
				}
			}
		} else {
			elems[0] = {
				description : Resources.getResources().RegistrationTVDescription,
				imgSrc : "images/registration/reg_icon_tv.png",
				imgWidth : 104,
				imgHeight : 104
			};
			elems[1] = {
				description : Resources.getResources().RegistrationVODDescription,
				imgSrc : "images/registration/reg_icon_vod.png",
				imgWidth : 104,
				imgHeight : 104
			};
		}
	} catch (ex) {
		Logger.write("=====Exception: " + ex.toSource(), "DescribeApp");
	}

	SceneDescribeApp.contentPanel.loadPanelData(elems);
}

 /*
 * Sets help bar
 */
SceneDescribeApp.setHelpBar = function(){
	$('#textDescribeApp').sfLabel({text: Resources.getResources().DescribeAppTitle});
	$('#keysDescribeApp').sfKeyHelp({
		'leftright':Resources.getResources().Back + " - " + Resources.getResources().Forward,
		'return':Resources.getResources().BackToMainMenu
	});
}
 
SceneDescribeApp.forward = function(){
    $.sfScene.hide("DescribeApp");
    $.sfScene.show("Registration");
    $.sfScene.focus("Registration");
}

/*
 * Handles key RIGHT press
 */
SceneDescribeApp.handleRight = function(){
    SceneDescribeApp.forward();
}

/*
 * Handles key LEFT press
 */
SceneDescribeApp.handleLeft = function(){
     SceneDescribeApp.handleReturn();
}

/*
* Translates scene
*/
SceneDescribeApp.translate = function () {
    SceneDescribeApp.setBtns();
    SceneDescribeApp.loadPanel();
    SceneDescribeApp.setHelpBar();
}

SceneDescribeApp.prototype.initialize = function () {
	Logger.write("SceneDescribeApp.initialize()", "DescribeApp");
	// this function will be called only once when the scene manager show this scene first time
	// initialize the scene controls and styles, and initialize your variables here 
	// scene HTML and CSS will be loaded before this function is called
    SceneDescribeApp.setHelpBar();
    //SceneDescribeApp.loadPanel();
	Registration = null;
}

SceneDescribeApp.prototype.handleShow = function () {
	Logger.write("SceneDescribeApp.handleShow()", "DescribeApp");
	// this function will be called when the scene manager show this scene 
}

SceneDescribeApp.prototype.handleHide = function () {
	Logger.write("SceneDescribeApp.handleHide()", "DescribeApp");
	// this function will be called when the scene manager hide this scene  
}

SceneDescribeApp.prototype.handleFocus = function () {
	Logger.write("SceneDescribeApp.handleFocus()", "DescribeApp");
	// this function will be called when the scene manager focus this scene
    AppContext.CurrentScene = "DescribeApp";
    SceneDescribeApp.setHelpBar();
	if (!Registration) {
		var callback = function () {
			SceneDescribeApp.loadPanel();
		};
		$.sf.loadJS(["registration.json"], callback)
	}
	else {
		SceneDescribeApp.loadPanel();
	}
}

SceneDescribeApp.prototype.handleBlur = function () {
	Logger.write("SceneDescribeApp.handleBlur()", "DescribeApp");
	// this function will be called when the scene manager move focus to another scene from this scene
}

SceneDescribeApp.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneDescribeApp.handleKeyDown(" + keyCode + ")", "DescribeApp");
	// TODO : write an key event handler when this scene get focued
    try {
        switch (keyCode) {
            case $.sfKey.LEFT:
                SceneDescribeApp.handleLeft();
                break;
            case $.sfKey.RIGHT:
                SceneDescribeApp.handleRight();
                break;
			case $.sfKey.ENTER:
				SceneDescribeApp.handleRight();
				break;
            case $.sfKey.RETURN:
                widgetAPI.blockNavigation(event);
                SceneDescribeApp.handleReturn();
                break;
            case $.sfKey.EXIT:
				widgetAPI.blockNavigation(event);
				SceneDescribeApp.handleExit();
				break;
            default:
                widgetAPI.blockNavigation(event);
                break;
        }
    } catch(error) {
		ErrorHandler.HandleError(error, "DescribeApp");
    }
}
