/**
 * @author EvgeniyV
 */
function SceneCreateAccount(options) {
	this.options = options;
	var ime_txtEmail = null;
	var ime_txtEmail2 = null;
	var ime_txtSms = null;
	var ime_txtPin = null;
}

SceneCreateAccount.modes = {
	viaSite: 'web',
	viaEmail: 'email',
	viaSms: 'sms'
};

SceneCreateAccount.setBtns = function () {
	$("#confirmButton").sfButton({
		text: "OK"
	});
	$("#confirmButton").sfButton("focus");

	$("#lblCreateAccountTitle").sfLabel({
		text: Resources.getResources().CreateAccount.toLowerCase()
	});
	$("#viaSite .regDescription").sfLabel({
		text: Resources.getResources().RegSiteDesc
	});
	var DUID = Helpers.getDUID();
	var viaSiteDescr = Resources.getResources().RegSiteDesc2 + DUID;
	$("#viaSite p").sfLabel({
		text: viaSiteDescr
	});
	$("#viaEmail .regDescription").sfLabel({
		text: Resources.getResources().RegEmailDesc
	});
	$("#viaEmail p").sfLabel({
		text: Resources.getResources().RegEmailDesc2
	});
	$("#viaSms .regDescription").sfLabel({
		text: Resources.getResources().RegSmsDesc
	});
	$("#viaSms p").sfLabel({
		text: Resources.getResources().RegSmsDesc2
	});

	$(".confirm .regDescription").sfLabel({
		text: Resources.getResources().RegConfirmDescription
	});
	$(".confirm p").sfLabel({
		text: Resources.getResources().RegConfirmText
	});

	$("#lblDUID").html(Helpers.getDUID());
}

/*
 * Sets help bar
 */
SceneCreateAccount.setHelpBar = function () {
	$('#keysCreateAccount').sfKeyHelp({
		'leftright': Resources.getResources().MoveCursor,
		'enter': Resources.getResources().Select,
		'return': Resources.getResources().BackToMainMenu
	});
}

/*
 *
 */
SceneCreateAccount.show = function (mode) {
	SceneCreateAccount.mode = mode;
	$.sfScene.show('CreateAccount');
	$.sfScene.focus('CreateAccount');
	$(".lblErrorCreateAccount").sfLabel({
		text: ""
	});
	SceneCreateAccount.showRegPanel(mode);
}

SceneCreateAccount.showRegPanel = function (mode) {
	$("#confirmButton").sfButton('blur');
	$("#SceneCreateAccount .create").hide();
	$("#SceneCreateAccount .confirm").hide();
	switch (mode) {
		case SceneCreateAccount.modes.viaSite:
			$("#viaSite").show();
			$("#confirmButton").sfButton("focus");
			break;
		case SceneCreateAccount.modes.viaEmail:
			$("#viaEmail").show();
			SceneCreateAccount.focusIMEEmail();
			break;
		case SceneCreateAccount.modes.viaSms:
			$("#viaSms").show();
			SceneCreateAccount.focusIMESms();
			break;
	}

	SceneCreateAccount.isConfirmation = false;
}

SceneCreateAccount.showConfirmation = function () {
	$("#confirmButton").sfButton('blur');
	$("#SceneCreateAccount .create").hide();
	$("#SceneCreateAccount .confirm").show();
	SceneCreateAccount.focusIMEPin();
	SceneCreateAccount.isConfirmation = true;
}

SceneCreateAccount.createAccount = function (email, phone, cb, errCb) {
	SceneCreateAccount.showLoading();
	var DUID = Helpers.getDUID();
	email = email || "";
	if (phone) {
		phone = "+" + phone;
	} else {
		phone = "";
	}
	var tmpCallback = function (result) {
			cb(result);
			SceneCreateAccount.hideLoading();
		};
	
	JsonServices.client.RegisterClient("Activate", AppContext.appName, email, phone, DUID, null, tmpCallback, errCb);
}

SceneCreateAccount.createViaEmail = function () {
	Logger.write("SceneCreateAccount.createViaEmail", "CreateAccount");

	var callback = function (result) {
			Logger.write("registration results: " + result.toSource(), "CreateAccount", true);
			if (result.Result) {
				SceneCreateAccount.showConfirmation();
			} else {
				$("#viaEmail .lblErrorCreateAccount").sfLabel({
					text: result.Description
				});
	            SceneCreateAccount.focusIMEEmail();
	            SceneCreateAccount.hideLoading();
			}
		}
	var errCallback = function (error) {
			$("#viaEmail .lblErrorCreateAccount").sfLabel({
				text: error
			});
			SceneCreateAccount.hideLoading();
			SceneCreateAccount.focusIMEEmail();
		}

	var emailValue = document.getElementById('txtEmail').value + "@" + document.getElementById('txtEmail2').value;
	(emailValue == "@") ? errCallback(Resources.getResources().EmptyEmail) : SceneCreateAccount.createAccount(emailValue, "", callback, errCallback);

}

SceneCreateAccount.createViaSms = function () {
	Logger.write("SceneCreateAccount.createViaEmail", "CreateAccount");

	var callback = function (result) {
			if (result.Result) {
				Logger.write("Confirmation code sent", "CreateAccount");
				SceneCreateAccount.showConfirmation();
			} else {
				$("#viaSms .lblErrorCreateAccount").sfLabel({
					text: result.description
				});
	            SceneCreateAccount.focusIMESms();
	            SceneCreateAccount.hideLoading();
			}
		}

	var errCallback = function (error) {
			$("#viaSms .lblErrorCreateAccount").sfLabel({
				text: error
			});
			SceneCreateAccount.hideLoading();
			SceneCreateAccount.focusIMESms();
		}

	var phoneValue = document.getElementById('txtSms').value;
	!phoneValue ? errCallback(Resources.getResources().EmptyPhone) : SceneCreateAccount.createAccount("", phoneValue, callback, errCallback);

}

SceneCreateAccount.confirmData = function () {
	SceneCreateAccount.showLoading();
	var callback = function (result) {
			if (result.Result) {
				Logger.write("Confirmation success", "CreateAccount", true);

				var success = function () {
						SceneCreateAccount.hideLoading();
						$.sfScene.hide("CreateAccount");
						SceneMainMenu.show();
					};

		            var errCb = function () {
		                $.sfScene.hide("CreateAccount");
						$.sfScene.show('Login');
						$.sfScene.focus('Login');
						SceneCreateAccount.hideLoading();
					};

				var loginData = Helpers.getLoginData(window.location.search);
				var DUID = Helpers.getDUID();

				Login.completeLogin(DUID, loginData[0], loginData[1], success, errCb);
			} else {
				Logger.write("Confirmation failed!", "CreateAccount", true);
				$("#confirm .lblErrorCreateAccount").sfLabel({
					text: result.description
				});
				SceneCreateAccount.focusIMEPin();
				SceneCreateAccount.hideLoading();
			}
		};

	var errCallback = function (error) {
			$("#confirm .lblErrorCreateAccount").sfLabel({
				text: error
			});
			SceneCreateAccount.focusIMEPin();
		};

	var DUID = Helpers.getDUID();
	var pin = document.getElementById('txtPin').value;
	
	if (pin.length > 0) {
		JsonServices.client.RegisterClient("Confirm", AppContext.appName, null, null, DUID, pin, callback, errCallback);
	} else {
		$("#confirm .lblErrorCreateAccount").sfLabel({
			text: Resources.getResources().RegConfirmError
		});
		SceneCreateAccount.focusIMEPin();
		SceneCreateAccount.hideLoading();
	}
}

SceneCreateAccount.handleReturn = function () {
	if (SceneCreateAccount.isConfirmation) {
		SceneCreateAccount.showRegPanel(SceneCreateAccount.mode);
	} else {
		$.sfScene.hide('CreateAccount');
		$.sfScene.show('Registration');
		$.sfScene.focus('Registration');
	}
}

SceneCreateAccount.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("CreateAccount", resultCallback);
}

/*
 * Handles key DOWN press
 */
SceneCreateAccount.handleDown = function () {
	switch (SceneCreateAccount.mode) {
		case SceneCreateAccount.modes.viaEmail:
			$("#confirmButton").sfButton("blur");
			SceneCreateAccount.focusIMEEmail();
			break;
		case SceneCreateAccount.modes.viaSms:
			$("#confirmButton").sfButton("blur");
			SceneCreateAccount.focusIMESms();
			break;
	}
}

/*
 * Handles key UP press
 */
SceneCreateAccount.handleUp = function () {
	if (SceneCreateAccount.isConfirmation) {
		$("#confirmButton").sfButton("blur");
		SceneCreateAccount.focusIMEPin();
	} else {
		switch (SceneCreateAccount.mode) {
		case SceneCreateAccount.modes.viaEmail:
			$("#confirmButton").sfButton("blur");
			SceneCreateAccount.focusIMEEmail();
			break;
		case SceneCreateAccount.modes.viaSms:
			$("#confirmButton").sfButton("blur");
			SceneCreateAccount.focusIMESms();
			break;
		}
	}
}

/*
 * Handles key ENTER press
 */
SceneCreateAccount.handleEnter = function () {
	if (SceneCreateAccount.isConfirmation) {
		SceneCreateAccount.confirmData();
	} else {
		switch (SceneCreateAccount.mode) {
			case SceneCreateAccount.modes.viaSite:
				SceneCreateAccount.showConfirmation();
				break;
			case SceneCreateAccount.modes.viaEmail:
				SceneCreateAccount.createViaEmail();
				break;
			case SceneCreateAccount.modes.viaSms:
				SceneCreateAccount.createViaSms();
				break;
		}
	}
}

/*
 * Navigates to Login Scene
 */
SceneCreateAccount.navigateToLogin = function () {
	$.sfScene.hide('CreateAccount');
	$.sfScene.show('Login');
	$.sfScene.focus('Login');
}

SceneCreateAccount.focusIMEEmail = function () {
	$("#confirmButton").sfButton("blur");
	$('#txtEmail').focus();
	ime_txtEmail._inputModeChange();
}

SceneCreateAccount.focusIMEEmail2 = function () {
	$("#confirmButton").sfButton("blur");
	$('#txtEmail2').focus();
	ime_txtEmail2._inputModeChange();
}

SceneCreateAccount.focusIMESms = function () {
	$("#confirmButton").sfButton("blur");
	$('#txtSms').focus();
	ime_txtSms._inputModeChange();
	ime_txtSms._inputModeChange();
	ime_txtSms._inputModeChange();
}

SceneCreateAccount.focusIMEPin = function () {
	$("#confirmButton").sfButton("blur");
	$('#txtPin').focus();
	ime_txtPin._inputModeChange();
	ime_txtPin._inputModeChange();
	ime_txtPin._inputModeChange();
}

SceneCreateAccount.showLoading = function () {
	$('#loadingObject').sfLoading('show');
	$(".inputs").hide();
}

SceneCreateAccount.hideLoading = function () {
	$('#loadingObject').sfLoading('hide');
	$(".inputs").show();
}

function callback_txtEmail2(cb) {
	try {
		cb.setKeypadPos(555, 100, 9);
		cb.setKeyFunc($.sfKey.RETURN, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleReturn();
		});
		cb.setKeyFunc($.sfKey.EXIT, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleExit();
		});
		cb.setKeyFunc($.sfKey.UP, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.DOWN, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.ENTER, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
	} catch (error) {
		ErrorHandler.HandleError(error, "CreateAccount");
	}
}

function callback_txtEmail(cb) {
	try {
		cb.setKeypadPos(555, 100, 9);
		if (SceneCreateAccount.mode == SceneCreateAccount.modes.viaEmail) {
			SceneCreateAccount.focusIMEEmail();
		}
		cb.setKeyFunc($.sfKey.RETURN, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleReturn();
		});
		cb.setKeyFunc($.sfKey.EXIT, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleExit();
		});
		cb.setKeyFunc($.sfKey.UP, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.DOWN, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.ENTER, function () {
			$.sf.returnFocus();
			SceneCreateAccount.focusIMEEmail2();
		});
	} catch (error) {
		ErrorHandler.HandleError(error, "CreateAccount");
	}
}

function callback_txtSms(cb) {
	try {
		cb.setKeypadPos(500, 100, 9);
		if (SceneCreateAccount.mode == SceneCreateAccount.modes.viaSms) {
			SceneCreateAccount.focusIMESms();
		}
		cb.setKeyFunc($.sfKey.RETURN, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleReturn();
		});
		cb.setKeyFunc($.sfKey.EXIT, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleExit();
		});
		cb.setKeyFunc($.sfKey.UP, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.DOWN, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.ENTER, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
	} catch (error) {
		ErrorHandler.HandleError(error, "CreateAccount");
	}
}

function callback_txtPin(cb) {
	try {
		cb.setKeypadPos(500, 100, 9);
		cb.setKeyFunc($.sfKey.RETURN, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleReturn();
		});
		cb.setKeyFunc($.sfKey.EXIT, function () {
			$.sf.returnFocus();
			SceneCreateAccount.handleExit();
		});
		cb.setKeyFunc($.sfKey.UP, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.DOWN, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
		cb.setKeyFunc($.sfKey.ENTER, function () {
			$.sf.returnFocus();
			$("#confirmButton").sfButton("focus");
		});
	} catch (error) {
		ErrorHandler.HandleError(error, "CreateAccount");
	}
}

SceneCreateAccount.prototype.initialize = function () {
	Logger.write("SceneCreateAccount.initialize()", "CreateAccount");
	// this function will be called only once when the scene manager show this scene first time
	// initialize the scene controls and styles, and initialize your variables here 
	// scene HTML and CSS will be loaded before this function is called
	ime_txtEmail = new IMEShell("txtEmail", callback_txtEmail);
	ime_txtEmail2 = new IMEShell("txtEmail2", callback_txtEmail2);
	ime_txtSms = new IMEShell("txtSms", callback_txtSms);
	ime_txtPin = new IMEShell("txtPin", callback_txtPin);
}

SceneCreateAccount.prototype.handleShow = function () {
	Logger.write("SceneCreateAccount.handleShow()", "CreateAccount");
	// this function will be called when the scene manager show this scene 
	SceneCreateAccount.setBtns();
	SceneCreateAccount.setHelpBar();
}

SceneCreateAccount.prototype.handleHide = function () {
	Logger.write("SceneCreateAccount.handleHide()", "CreateAccount");
	// this function will be called when the scene manager hide this scene  
}

SceneCreateAccount.prototype.handleFocus = function () {
	Logger.write("SceneCreateAccount.handleFocus()", "CreateAccount");
	// this function will be called when the scene manager focus this scene
	AppContext.CurrentScene = "CreateAccount";
}

SceneCreateAccount.prototype.handleBlur = function () {
	Logger.write("SceneCreateAccount.handleBlur()", "CreateAccount");
	// this function will be called when the scene manager move focus to another scene from this scene
}

SceneCreateAccount.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneCreateAccount.handleKeyDown(" + keyCode + ")", "CreateAccount");
	// TODO : write an key event handler when this scene get focued
	try {
		switch (keyCode) {
		case $.sfKey.LEFT:
			SceneCreateAccount.handleReturn();
			break;
		case $.sfKey.RIGHT:
			break;
		case $.sfKey.UP:
			SceneCreateAccount.handleUp();
			break;
		case $.sfKey.DOWN:
			SceneCreateAccount.handleDown();
			break;
		case $.sfKey.ENTER:
			SceneCreateAccount.handleEnter();
			break;
		case $.sfKey.RETURN:
			widgetAPI.blockNavigation(event);
			SceneCreateAccount.handleReturn();
			break;
		case $.sfKey.EXIT:
			widgetAPI.blockNavigation(event);
			SceneCreateAccount.handleExit();
			break;
		default:
			widgetAPI.blockNavigation(event);
			break;
		}
	} catch (error) {
		ErrorHandler.HandleError(error, "CreateAccount");
	}
}
