function SceneArchTv(options) {
	this.options = options;
}

SceneArchTv.prototype.initialize = function () {
	Logger.write("SceneArchTv.initialize()", "ArchTv");
	// this function will be called only once when the scene manager show this scene first time
	// initialize the scene controls and styles, and initialize your variables here 
	// scene HTML and CSS will be loaded before this function is called
	ErrorHandler.NeedToRefresh["ArchTv"] = false;
    SceneArchTv.hideImage();    
    SceneArchTv.currentLang = AppContext.ClientSettings.Language;
    SceneArchTv.initData();
    SceneArchTv.maxName = 52;
    $('#scrollArchTvPrograms').sfScroll({page:'1'});
    $('#lblArchProgramDescription').sfLabel({text:''});
    $('#imgTvSearch').sfImage({src:'images/Search.png'});    
    $('#lblArchTvTitle').sfLabel({text:Resources.getResources().LabelArchTv.toLowerCase()});
    $('#divTvSearch').sfLabel({text:Resources.getResources().Search});
    SceneArchTv.loadPanels();
    SceneArchTv.setHelpBar();
}
/*
    Refreshes data on secene
*/
 SceneArchTv.refresh = function() {
	SceneArchTv.uninitialize();
    SceneArchTv.initData();
	Logger.write("Panels: " + $('#SceneArchTv #panelsArchTv').html(), "ArchTv", true);
    $('#SceneArchTv #panelsArchTv').empty();
	$('#SceneArchTv #panelsArchTv').css("opacity", "0");
	Logger.write("Panels: " + $('#SceneArchTv #panelsArchTv').html(), "ArchTv", true);
    $('#scrollArchTvPrograms').sfScroll({page:'1'});
	$('#scrollArchTvPrograms').css({'visibility':'hidden'});
    $('#lblArchProgramDescription').sfLabel({text:'', width:'710px'});
    $('#imgTvSearch').sfImage({src:'images/Search.png'});
    SceneArchTv.hideImage();
    $('#lblArchTvTitle').sfLabel({text:Resources.getResources().LabelArchTv.toLowerCase()});
    $('#divTvSearch').sfLabel({text:Resources.getResources().Search});
	$("#lbArchTvPrograms").css({'visibility': 'hidden'});
	$("#panelsArchTv").css({'visibility': 'hidden'});
	$('#lblArchProgramDescription').empty();
	$("#SceneArchTv .programImage").hide();
    SceneArchTv.loadPanels();
 }
/*
    Initialize default variables
*/
SceneArchTv.initData = function()
{
    this.daysFor = 14;
    this.programsPerPage = 6;
}

SceneArchTv.showLoading = function () {
	SceneArchTv.isLoading = true;
	if (AppContext.CurrentScene == "ArchTv") {
		Helpers.showLoading();
	}
}

SceneArchTv.hideLoading = function () {
	SceneArchTv.isLoading = false;
	if (AppContext.CurrentScene == "ArchTv") {
		Helpers.hideLoading();
	}
}

SceneArchTv.uninitialize = function()
{
	if (this.datesPanel) {
		this.datesPanel.unload();
		this.datesPanel = null;
	}
	if (this.channelsPanel) {
		this.channelsPanel.unload();
		this.channelsPanel = null;
	}
    $('#lbArchTvPrograms').sfList('clear');
    SceneArchTv.activePrograms = null;
	SceneArchTv.channels = null;
    Logger.write("======== Uninitialized", "ArchTv");
}

SceneArchTv.loadDates = function (callback) {
	var getTimeCallback = function (result) {
		var tmpDate = result;
		var shift = 0;
		for (var i = 0; i < AppContext.TimeZones.length; i++) {
			if (AppContext.ClientSettings.timeZoneName == AppContext.TimeZones[i].id) {
				shift = parseInt(AppContext.TimeZones[i].utcOffset);
				break;
			}
		}
		tmpDate.setMinutes(tmpDate.getMinutes() + shift);
		var time = Helpers.getUtcTime(tmpDate);
		
		tmpDate.setHours(0, 0, 0, 0);
		var elements = [];
		for (var i = 0; i < SceneArchTv.daysFor; i++) {
			var dateId = DateHelper.convertToString(tmpDate).replace(/\-/g, "").substr(0, 8);
			elements[i] = new PanelElement(dateId, DateHelper.getArchDate(tmpDate));
			tmpDate.setDate(tmpDate.getDate()-1);
		}
		SceneArchTv.datesPanel.focusElement(0);
		SceneArchTv.datesPanel.loadData(elements);

		if (!!callback) {
			callback();
		}
	};

	var errCallback = function (jqXHR, textStatus, error) {
		ErrorHandler.HandleError(error, "LiveTv", true, textStatus, jqXHR);
	};
	
	JsonServices.media.GetCurrentUtcTime(getTimeCallback, errCallback);
}

SceneArchTv.checkLoadDataCompleted = function () {
	if (!!SceneArchTv.datesPanel && !!SceneArchTv.channelsPanel) {
		SceneArchTv.onLoadPanelsCompleted();
	}
}

/*
    Occurs when the panels are loaded
*/
SceneArchTv.onLoadPanelsCompleted = function () {
    this.isDataLoaded = true;
	if (this.channelsPanel.elements.length > 0) {
		Logger.write("[Arch Tv] Data loaded!", "ArchTv");
		$('#SceneArchTv #panelsArchTv').css('visibility', 'visible');
		$('#SceneArchTv #panelsArchTv').css("opacity", "1");
		this.focusedPanel = "channelsPanel";
		this[this.focusedPanel].focusPanel();
		this.loadPrograms();
		this.showCounter();
	} else {
		$('#SceneArchTv #panelsArchTv').css('visibility', 'hidden');
		$('#SceneArchTv #panelsArchTv').css("opacity", "0");
		$('#lbArchTvPrograms').css({'visibility':'visible'});
		$('#lbArchTvPrograms').empty();
		$("#lbArchTvPrograms").append("<div class='noData'>" + Resources.getResources().NoData + "</div>");
		SceneArchTv.hideLoading();
	}
}

/*
    
*/
SceneArchTv.selectedChangedCallback = function(elementId)
{
    if (typeof(SceneArchTv.channelsPanel) != "undefined" && typeof(SceneArchTv.datesPanel) != "undefined")
    {
        SceneArchTv.loadPrograms();
    }
}

SceneArchTv.hideImage = function(){
        $("#imgArchProgram").sfImage({src:""});
        $("#SceneArchTv .programImage").hide();
}

SceneArchTv.onProgramsLoaded = function (result) {
	Logger.write("SceneArchTv.onProgramsLoaded()", "ArchTv", true);
    try {
		var programs = result.items.length > 0 ? result.items : null;
        if (programs) {
			var dateId = SceneArchTv.datesPanel.elements[SceneArchTv.datesPanel.index].replace("#divDate", "");
			var date = new Date(parseInt(dateId.substr(0, 4), 10), parseInt(dateId.substr(4, 2), 10)-1, parseInt(dateId.substr(6, 2), 10));
			var dateLocaleFormat = date.toLocaleFormat("%Y-%m-%d");
			date = null;
			dateId = null;
			var resultPrograms = [];
			var progs = [];
			var j = 0;
			for (var i = 0; i < programs.length; i++) {
				programs[i].recentAirTime.startTime.setHours(programs[i].recentAirTime.startTime.getHours() + SceneArchTv.offset - AppContext.deviceOffset/60);
				var programDate = programs[i].recentAirTime.startTime;
				var watchable = programs[i].recentAirTime.archived;
				if ((programDate.toLocaleFormat("%Y-%m-%d") == dateLocaleFormat) && watchable) {
					var time = programs[i].recentAirTime.startTime.toLocaleFormat("%H : %M");
					resultPrograms[j] = programs[i];
					var programName = programs[i].name;
					programName = programName.length > 60 ? programName.substring(0, 57) + "..." : programName;
					progs[j++] = "<span class='programTime'>" + time + "</span><span class='programTitle'>" + Helpers.decodeHtml(programName + "</span>");
				}
				programDate = null;
			}
			dateLocaleFormat = null;

			SceneArchTv.activePrograms = resultPrograms;
			$("#lbArchTvPrograms").empty();
			$('#lbArchTvPrograms').sfList({data: progs, index: '0', itemsPerPage: SceneArchTv.programsPerPage});
			$('#lbArchTvPrograms').sfList('blur');
			var page = Math.ceil(progs.length/SceneArchTv.programsPerPage);
			$('#scrollArchTvPrograms').sfScroll({page: page});
			$('#scrollArchTvPrograms').sfScroll('focus');
			$('#scrollArchTvPrograms').css({'visibility':'visible'});
			$('#lbArchTvPrograms').css({'visibility':'visible'});
			if (progs.length > 0)
				  $('#lbArchTvPrograms').sfList('show');
        } else {
			SceneArchTv.hideLoading();
        }
    } catch (error) {
            ErrorHandler.HandleError(error,"ArchTv");  
    }
    SceneArchTv.hideLoading();
    programms = null;
    SceneArchTv.isDataLoaded = true;
}

/*
    Getting and load programs data (async)
*/
SceneArchTv.loadPrograms = function()
{
    this.isDataLoaded = false;
    $('#divPrograms').css('visibility', 'hidden');
    SceneArchTv.showLoading();
    channelId = $(this.channelsPanel.getFocused()).attr('id').replace("divChannel", "");

    var dateId = this.datesPanel.elements[this.datesPanel.index].replace("#divDate", "");
    var date = new Date(parseInt(dateId.substr(0, 4), 10), parseInt(dateId.substr(4, 2), 10)-1, parseInt(dateId.substr(6, 2), 10));
	date.setHours(date.getHours() - SceneArchTv.offset + AppContext.deviceOffset/60);
	var dateTill = new Date(date.getTime());
	dateTill.setDate(dateTill.getDate() + 1);
	Logger.write("Selected date: " + date, "ArchTv", true);
    var perPage = this.programsPerPage;
    var errCallback = function(jqXHR, textStatus, error) {
		ErrorHandler.HandleError(error, "ArchTv", true, textStatus, jqXHR);
	};
	//that stream zone == time zone isn't a bug
	JsonServices.content.GetClientProgramGuide(AppContext.user.sid, "DVR", "AllItems", channelId, 
			null, date, dateTill, null, null, null, 50, 1, AppContext.ClientSettings.shiftTimeZoneName, 
			AppContext.ClientSettings.shiftTimeZoneName, SceneArchTv.onProgramsLoaded, errCallback, 1);
}

SceneArchTv.onChannelsLoaded = function (result) {
    try {
        var elements = [];
		var channels = result.items;
		SceneArchTv.channels = {};
        for (var i = 0; i < channels.length; i++) {
			if (channels[i].readyForDvr) {
				var channelName = channels[i].name;
				channelName = channelName.length > 27 ? channelName.substring(0,27) + "..." : channelName;
				var id = channels[i].id;
				var imageUrl = AppContext.ImageUrlTemplate.replace("{0}", id).replace("{1}", 10).replace("{2}", 1) + "&width=32";
				elements.push(new PanelElement(id, channelName, imageUrl));
				if (channels[i].arX && channels[i].arY) {
					SceneArchTv.channels[id] = {
						ar: {
							x: channels[i].arX,
							y: channels[i].arY
						}
					};
				}
			}
        }
        SceneArchTv.channelsPanel = new SlidingPanel(80, 80, elements, "Channel", SceneArchTv.selectedChangedCallback, 300, orientations.horizontal, true, null, null, 1000, true, 3, 3);
        $('#SceneArchTv #panelsArchTv').append(SceneArchTv.channelsPanel.panel);
        SceneArchTv.checkLoadDataCompleted();
    } catch (error) {
		ErrorHandler.HandleError(error,"ArchTv");
    }  
}

/*
    Getting and load data to panels
*/
SceneArchTv.loadPanels = function()
{
	this.focusedPanel = null;
	$('#SceneArchTv #panelsArchTv').css('visibility', 'hidden');
	SceneArchTv.showLoading();
	var errCallback = function(jqXHR, textStatus, error) {
		ErrorHandler.HandleError(error, "ArchTv", true, textStatus, jqXHR);  
	};
	this.offset = AppContext.getNaEstUtcOffset();
	
	JsonServices.content.GetClientChannels(AppContext.user.sid, "DVR", 200, 1, SceneArchTv.onChannelsLoaded, errCallback);
	
	this.datesPanel = new SlidingPanel(120, 80, [], "Date", this.selectedChangedCallback, 170, orientations.horizontal, true, null, null, 1000, true, 4, 4);
	$('#SceneArchTv #panelsArchTv').append(this.datesPanel.panel);
	
	SceneArchTv.loadDates(function () {
		SceneArchTv.checkLoadDataCompleted();
	});
}

SceneArchTv.getChannelAr = function (channelId) {
	if (!SceneArchTv.channels || !SceneArchTv.channels[channelId]) {
		if (channelId == 1 || channelId == 300473) {
			return {
				x: 16,
				y: 9
			};
		}
		return null;
	}
	
	return SceneArchTv.channels[channelId].ar;
}

SceneArchTv.focusSearch = function()
{
    this.focusedPanel = "search";
    $('#divTvSearch').animate({'font-size' : '20px'}, 200);   
     
     var cssObj = {
     'filter': 'alpha(opacity=100)',
	'opacity': '1',
	'-moz-opacity':'1'
    }
    
    $('#divTvSearch').css(cssObj);


}

SceneArchTv.blurSearch = function()
{
    $('#divTvSearch').animate({'font-size' : '16px'}, 200);   
     
     var cssObj = {
     'filter': 'alpha(opacity=50)',
	'opacity': '0.5',
	'-moz-opacity':'0.5'
    }
    
    $('#divTvSearch').css(cssObj);

}

/*
    Changes focused panel
*/
SceneArchTv.changePanelFocus = function(newPanel)
{
    this[this.focusedPanel].blurPanel();
    this.focusedPanel = newPanel;
    this[this.focusedPanel].focusPanel();
}

SceneArchTv.showCounter = function () {
	Logger.write("SceneArchTv.showCounter()", "ArchTv");
	var index = SceneArchTv.channelsPanel.index + 1;
	var total = SceneArchTv.channelsPanel.elements.length;
	$("#archTvChannelCounter").empty();
	$("#archTvChannelCounter").append(index + " | " + total);
}

/*
    Handles left button press
*/
SceneArchTv.handleLeft = function ()
{
    try
    {
		if (this.focusedPanel) {
			if ((this.focusedPanel != "programsPanel") && (this.focusedPanel != "search"))
			{
				if (this.isDataLoaded)
				{
					this[this.focusedPanel].focusPrev();
					SceneArchTv.showCounter();
				}
			}
			else if (this.focusedPanel == "programsPanel") 
			{
				$('#lbArchTvPrograms').sfList('blur');
				this.focusedPanel = "datesPanel";
				this[this.focusedPanel].focusPanel();
				SceneArchTv.hideImage();
				$('#lblArchProgramDescription').sfLabel({text: ''});
			}
		}
    }
    catch (error)
    {
		ErrorHandler.HandleError(error,"ArchTv");
    }
}

/*
    Handles right button press
*/
SceneArchTv.handleRight = function ()
{
    try
    {
		if (this.focusedPanel) {
			if ((this.focusedPanel != "programsPanel") && (this.focusedPanel != "search"))
			{
				if (this.isDataLoaded)
				{
					this[this.focusedPanel].focusNext();
					SceneArchTv.showCounter();
				}
			}
			else if (this.focusedPanel == "programsPanel") 
			{
				$('#lbArchTvPrograms').sfList('blur');
				this.focusedPanel = "datesPanel";
				this[this.focusedPanel].focusPanel();   
				SceneArchTv.hideImage();
				$('#lblArchProgramDescription').sfLabel({text: ''});
			}
		}
    }
    catch (error)
    {
		ErrorHandler.HandleError(error,"ArchTv");  
    }  
}

/*
    Handles down button press
*/
SceneArchTv.handleDown = function()
{
    try
    {
        if (this.isDataLoaded)
        {
            if (this.focusedPanel == "channelsPanel")
            {
                this.changePanelFocus("datesPanel");
            }
            else if (this.focusedPanel == "datesPanel" && this.activePrograms.length > 0)
            {
                this[this.focusedPanel].blurPanel();
                this.focusedPanel = "programsPanel";
                $('#lbArchTvPrograms').sfList('focus');
                this.showDescription(this.activePrograms[$('#lbArchTvPrograms').sfList('getIndex')]);
            }
            else if (this.focusedPanel == "programsPanel")
            {
                var idx = $('#lbArchTvPrograms').sfList('getIndex');
                if (((idx+1) % this.programsPerPage) == 0)
                {
                    var moveTo = Math.ceil(idx/this.programsPerPage);
                    $('#scrollArchTvPrograms').sfScroll('move', moveTo);
                }              
              
                if (idx == (this.activePrograms.length - 1))
                {            
					return;
                }    
                
                $('#lbArchTvPrograms').sfList('next');
                this.showDescription(this.activePrograms[$('#lbArchTvPrograms').sfList('getIndex')]);
            }
            else if (this.focusedPanel == "search")
            {
                this.blurSearch();
                this.focusedPanel = "channelsPanel";
                this[this.focusedPanel].focusPanel();
            }
        }
    }
    catch(error)
    {
        ErrorHandler.HandleError(error,"ArchTv");  
    }  
}

/*
    Handles up button press
*/
SceneArchTv.handleUp = function()
{
    try
    {
            if (this.isDataLoaded)
            {
                if (this.focusedPanel == "datesPanel")
                {
                    this.changePanelFocus("channelsPanel");
                }
                else if(this.focusedPanel == "programsPanel")
                {
                    var idx = $('#lbArchTvPrograms').sfList('getIndex');
                    if (idx == 0)
                    {
                        $('#lbArchTvPrograms').sfList('blur');
                        this.focusedPanel = "datesPanel";
                        this[this.focusedPanel].focusPanel();                
                        SceneArchTv.hideImage();
                        $('#lblArchProgramDescription').sfLabel({text: ''});
                    }
                    else
                    {
                        if (((idx+1) % this.programsPerPage) == 1)
                        {
                            var moveTo = Math.ceil(idx/this.programsPerPage)-1;
                            $('#scrollArchTvPrograms').sfScroll('move', moveTo);
                        }
                        $('#lbArchTvPrograms').sfList('prev');
                        this.showDescription(this.activePrograms[$('#lbArchTvPrograms').sfList('getIndex')]);
                    }
                }
            }
    }
    catch(error)
    {
            ErrorHandler.HandleError(error,"ArchTv");  
    }  
}

/*
    Showes description for selected program
*/
SceneArchTv.showDescription = function(programData)
{
	setTimeout(function () {
		if (!programData) {
			return;
		}
		var name = Helpers.decodeHtml(Helpers.escapeHTML(programData.TvProgramName));
		name = name.length > SceneArchTv.maxName ? name.substring(0,SceneArchTv.maxName) + "..." : name;
		var description = "";
		if (programData.description) {
			var desc =  Helpers.decodeHtml(Helpers.escapeHTML(programData.description)) ;        
			description += desc;
		}
		description = Helpers.removeQuotes(description);
		$('#lblArchProgramDescription').empty();
		$("#imgArchProgram").sfImage({src: ""});
		$('#lblArchProgramDescription').append(description);
		if (programData.imageCount > 0) {
			$("#SceneArchTv #lblArchProgramDescription").removeClass("noImage");
			var imageUrl = AppContext.ImageUrlTemplate.replace("{0}", programData.id).replace("{1}", 28).replace("{2}", 1) + "&width=152";
			$("#imgArchProgram").sfImage({src: imageUrl});
			$("#SceneArchTv .programImage").show();
		} else {
			$("#SceneArchTv .programImage").hide();
			$("#SceneArchTv #lblArchProgramDescription").addClass("noImage");
		}
	}, 1);
}

/*
    Plays selected program
*/
SceneArchTv.play = function () {
    var idx = $('#lbArchTvPrograms').sfList('getIndex');
	if (ScenePlayer.isPlaying && ScenePlayer.contentType == "DVR" && ScenePlayer.archProgramPicker) {
		if (ScenePlayer.archProgramPicker.index == idx) {
			$.sfScene.hide(AppContext.CurrentScene);
			$.sfScene.show('Player');
			$.sfScene.focus('Player');
			return;
		}
	}
	
    SceneArchTv.playProgram(idx);
}
             
/*
    Plays specified program 
*/
SceneArchTv.playProgram = function (programIndex) {
	var program = SceneArchTv.activePrograms[programIndex];
	
	var callback = function (response) {
		try {
			ScenePlayer.archProgramPicker = new ArchProgramPicker(SceneArchTv.activePrograms, SceneArchTv.playProgram, programIndex);
			$('#lbArchTvPrograms').sfList('move', programIndex);
			SceneArchTv.showDescription(SceneArchTv.activePrograms[$('#lbArchTvPrograms').sfList('getIndex')]);
			var tmpPrograms = SceneArchTv.activePrograms.slice(programIndex);
			ASXLoader.loadProgramsDuration(tmpPrograms);
			Logger.write("Program duration: " + program.Duration, "ArchTv", true);
			$.sfScene.hide(AppContext.CurrentScene);
			$.sfScene.show('Player');
			var video = program;
			var ar = SceneArchTv.getChannelAr(program.recentAirTime.channelID);
			if (ar) {
				Logger.write("AR gotten: " + ar.x + ":" + ar.y, "ArchTv", true);
				video.ar = ar;
			}
			video.currentTime = 0;
			video.cbPlay = SceneArchTv.playProgram;
			video.duration = program.length;
			video.playlist = response.Playlist;
			video.url = response.URL;
			video.contentType = "DVR";
			ScenePlayer.setContent(video, "ArchTv");
			$.sfScene.focus('Player');
		} catch (error) {
			ErrorHandler.HandleError(error, "ArchTv");
		}
	}
	
	var errCallback = function (jqXHR, textStatus, error) {
		ErrorHandler.HandleError(error, "ArchTv", true, textStatus, jqXHR);
	}
	
	try {
		JsonServices.media.GetClientStreamUri(
			AppContext.user.sid, "DVR", program.id,
			AppContext.ClientSettings.bAId, AppContext.ClientSettings.cdnId,
			AppContext.ClientSettings.qualityPreset, AppContext.ClientSettings.shiftTimeZoneName,
			callback, errCallback
		);

	} catch (error) {
		ErrorHandler.HandleError(error, "ArchTv");
	}
}

/*
    Handles enter button press
*/
SceneArchTv.handleEnter = function()
{
	try {
		if (this.focusedPanel == "programsPanel") {
			SceneArchTv.play();
		}
	} catch (error) {
		ErrorHandler.HandleError(error, "ArchTv");
	}
}

/*
    Handles yellow button press
*/
SceneArchTv.handleYellow = function ()
{
    try {
		if (this.focusedPanel == "programsPanel") {
			var idx = $('#lbArchTvPrograms').sfList('getIndex');
			var actProgram = this.activePrograms[idx];
			ScenePopUp.setWindow("ArchTv", actProgram);
			$.sfScene.show('PopUp');
			$.sfScene.focus('PopUp');
		}
    } catch (error) {
		ErrorHandler.HandleError(error, "ArchTv");
    }
}

SceneArchTv.handleNum = function (number) {
	Logger.write("handling num: " + number, "ArchTv", false);
	var num = parseInt(this.newChannel + number, 10);
	if (num <= this.channelsPanel.getTotal()) {
		this.newChannel += number;
	
		if (SceneArchTv.channelTimeout) {
			clearTimeout(SceneArchTv.channelTimeout);
		}
		
		var total = SceneArchTv.channelsPanel.elements.length;
		$("#archTvChannelCounter").empty();
		$("#archTvChannelCounter").append(this.newChannel + "- | " + total);

		var callback = function () {
			var num = parseInt(SceneArchTv.newChannel);
			SceneArchTv.channelsPanel.setIndex(num - 1);
			SceneArchTv.showCounter();
			SceneArchTv.newChannel = "";
		};
		SceneArchTv.channelTimeout = setTimeout(callback, 2000);
	}
}

/*    
  Moves focus back to MainMenu scene
*/
SceneArchTv.backToMainMenu = function ()
{
    try
    {
		$.sfScene.hide('ArchTv');
		SceneMainMenu.show();
     }
    catch (error)
    {
		ErrorHandler.HandleError(error,"ArchTv");
    }  
}

SceneArchTv.handleExit = function () {
	var resultCallback = function (result) {
		if (result) {
			AppEvents.Exit();
		}
	};
	SceneDialogPopUp.showExitDialog("ArchTv", resultCallback);
}

SceneArchTv.setHelpBar = function () {
    if (ScenePlayer.isPlaying)
    {
		$('#keysArchTv').sfKeyHelp({
			'number': Resources.getResources().ChangeChannel,
			'red':Resources.getResources().LabelSettings, 
			'green':Resources.getResources().Search,
			'yellow':Resources.getResources().Info, 
			'blue':Resources.getResources().Player, 
			'stop':Resources.getResources().Stop,
			'updown':'', 'leftright':Resources.getResources().MoveCursor,
			'enter':Resources.getResources().Select, 
			'return':Resources.getResources().BackToMainMenu
		});
     }
     else
     {
		$('#keysArchTv').sfKeyHelp({
			'number': Resources.getResources().ChangeChannel,
			'red':Resources.getResources().LabelSettings,
			'green':Resources.getResources().Search, 
			'yellow':Resources.getResources().Info,
			'updown':'', 'leftright':Resources.getResources().MoveCursor,
			'enter':Resources.getResources().Select,
			'return':Resources.getResources().BackToMainMenu
		});
     }
}

SceneArchTv.prototype.handleShow = function () {
	Logger.write("SceneArchTv.handleShow()", "ArchTv");
	// this function will be called when the scene manager show this scene 
    if(SceneArchTv.currentLang != AppContext.ClientSettings.Language) {
		$('#lblArchTvTitle').sfLabel({text:Resources.getResources().LabelArchTv.toLowerCase()});
		$('#divTvSearch').sfLabel({text:Resources.getResources().Search});
		SceneArchTv.setHelpBar();
		SceneArchTv.loadDates(function () {
			SceneArchTv.currentLang = AppContext.ClientSettings.Language;
			SceneArchTv.onLoadPanelsCompleted();
		});
    }
    SceneArchTv.newChannel = "";
}

SceneArchTv.prototype.handleHide = function () {
	Logger.write("SceneArchTv.handleHide()", "ArchTv");
	// this function will be called when the scene manager hide this scene  
	Helpers.hideLoading();
}

SceneArchTv.prototype.handleFocus = function () {
    Logger.write("SceneArchTv.handleFocus()", "ArchTv");
    // this function will be called when the scene manager focus this scene
     AppContext.CurrentScene="ArchTv";
     if  (ScenePlayer.isPlaying == true)
     {
            Helpers.setBackgroundOpacity();
     }
    if (ErrorHandler.NeedToRefresh[AppContext.CurrentScene])
    {
            SceneArchTv.refresh();
            ErrorHandler.NeedToRefresh[AppContext.CurrentScene] = false;
    } else if (SceneArchTv.isLoading) {
		Helpers.showLoading();
	}
    SceneArchTv.setHelpBar();
}

SceneArchTv.prototype.handleBlur = function () {
	Logger.write("SceneArchTv.handleBlur()", "ArchTv");
	// this function will be called when the scene manager move focus to another scene from this scene
    //SceneArchTv.uninitialize();
}

SceneArchTv.prototype.handleKeyDown = function (keyCode) {
	Logger.write("SceneArchTv.handleKeyDown(" + keyCode + ")", "ArchTv");
	// TODO : write an key event handler when this scene get focued
	if (Helpers.handleGlobalKeys(keyCode)) {
		return;
	}
	switch (keyCode) {
		case $.sfKey.N0:
			if (SceneArchTv.newChannel) {
				SceneArchTv.handleNum("0");
			}
			break;
		case $.sfKey.N1:
			SceneArchTv.handleNum("1");
			break;
		case $.sfKey.N2:
			SceneArchTv.handleNum("2");
			break;
		case $.sfKey.N3:
			SceneArchTv.handleNum("3");
			break;
		case $.sfKey.N4:
			SceneArchTv.handleNum("4");
			break;
		case $.sfKey.N5:
			SceneArchTv.handleNum("5");
			break;
		case $.sfKey.N6:
			SceneArchTv.handleNum("6");
			break;
		case $.sfKey.N7:
			SceneArchTv.handleNum("7");
			break;
		case $.sfKey.N8:
			SceneArchTv.handleNum("8");
			break;
		case $.sfKey.N9:
			SceneArchTv.handleNum("9");
			break;
		case $.sfKey.LEFT:
            SceneArchTv.handleLeft();
			break;
		case $.sfKey.RIGHT:
            SceneArchTv.handleRight();
			break;
		case $.sfKey.UP:
            SceneArchTv.handleUp();
			break;
		case $.sfKey.DOWN:
            SceneArchTv.handleDown();
			break;
		case $.sfKey.ENTER:
            SceneArchTv.handleEnter();
			break;            
        case $.sfKey.RETURN:            
            widgetAPI.blockNavigation(event);
            SceneArchTv.backToMainMenu();
            break;
        case $.sfKey.STOP:
            if  (ScenePlayer.isPlaying == true)
            {
                    ScenePlayer.stop();
                    SceneArchTv.setHelpBar();
            }
            break;		
        case $.sfKey.BLUE:
            if  (ScenePlayer.isPlaying == true)
            {
                    $.sfScene.hide('ArchTv');
                    $.sfScene.show('Player');
                    $.sfScene.focus('Player');
            }
            break;
        case $.sfKey.YELLOW:
            try
            {
                SceneArchTv.handleYellow();
            }
            catch(error)
            {
				ErrorHandler.HandleError(error,"ArchTv");
            }    
            finally
            {
				break;
            }
        case $.sfKey.GREEN:
            try
            {
                var okFunc = function(result)
                {
					$.sfScene.hide('ArchTv');
                    SceneSearchChannels.show();
                    SceneSearchChannels.loadResults(result, "ArchTv");
                }
                SceneTextboxPopUp.setCallbacks(okFunc, "ArchTv");
                SceneTextboxPopUp.show();
            }
            catch(error)
            {
                 ErrorHandler.HandleError(error,"ArchTv");
            }    
            finally
            {
				break;
            }
		case $.sfKey.RED:
            try
            {
                $.sfScene.hide('ArchTv');
                $.sfScene.show('Settings');
                $.sfScene.focus('Settings');
                SceneSettings.selectAccount();
            }
            catch(error)
            {
                ErrorHandler.HandleError(error,"ArchTv");  
            }  
            break;		
        case $.sfKey.EXIT:
            try
            {
                widgetAPI.blockNavigation(event);
				SceneArchTv.handleExit();
            }
            catch(error)
            {
                ErrorHandler.HandleError(error,"ArchTv");  
            }  
            break;
         default:         
            widgetAPI.blockNavigation(event);
            break;
	}
}
