/**
 *@file           Widget.js
 *@brief         일반 Widget 에서 사용할 API 함수를 구현
 *@author     삼성 SDS, ESDM개발, 김성태선임
 *@date         2009.02.17
 */
if (this.Common == null) {
    this.Common = new Object();
}
if (this.Common.API == null) {
    this.Common.API = new Object();
}

if (Common.API.EVENT_ENUM === undefined || Common.API.EVENT_ENUM === null) {
    // Define event enumeration
    Common.API.EVENT_ENUM = {
    	// Widget Event
    	WIDGET_READY : "10",
    	WIDGET_EXIT : "11",
    	WIDGET_RETURN : "12",
    	
    	// Key Event
    	KEY_REGIST : "20",
    	KEY_UNREGIST : "21",
    	KEY_IME_MODE : "22",
    	KEY_REGIST_ALL : "23",
    	KEY_UNREGIST_ALL : "24",
    	KEY_REGIST_FULL_WIDGET : "25",
    	KEY_REGIST_PART_WIDGET : "26"
    }
}

if (Common.API.Widget === undefined || Common.API.Widget === null) {
    Common.API.Widget = function(){
        var $THIS$ = this;
        this.sendReadyEvent = (function () {curWidget.setPreference("ready", "true");});
        this.sendExitEvent = (function () {curWidget.setPreference("exit", "true");});
        this.sendReturnEvent = (function () {curWidget.setPreference("return", "true");});
        this.blockNavigation = (function (event) {event.preventDefault();});
        this.putInnerHTML = (function (pDiv, pContents) {if (pDiv != null) {while (pDiv.firstChild) {if (pDiv.deleteChild) {pDiv.deleteChild(pDiv.firstChild);} else {pDiv.removeChild(pDiv.firstChild);}}pDiv.innerHTML = pContents;}});
        this.getSearchWidgetListPath = (function () {var type = Common.API.EVENT_ENUM.GET_SEARCH_WIDGET_LIST;var data = curWidget.id;var widgetEvent = new WidgetEvent(type, data);sendWidgetEvent("", widgetEvent, true);return "file://localhost/mtd_down/common/WidgetMgr/searchWidgetList.xml";});
        this.runSearchWidget = (function (pWidgetID, pKeyWord) {var type = Common.API.EVENT_ENUM.RUN_SEARCH_WIDGET;var data = curWidget.id + "?" + pWidgetID + "?" + pKeyWord;var widgetEvent = new WidgetEvent(type, data);sendWidgetEvent("", widgetEvent, false);});
        this.getChannelWidgetListPath = (function () {var type = Common.API.EVENT_ENUM.GET_CHANNEL_WIDGET_LIST;var data = curWidget.id;var widgetEvent = new WidgetEvent(type, data);sendWidgetEvent("", widgetEvent, true);return "file://localhost/mtd_down/common/WidgetMgr/channelWidgetList.xml";});
        this.addLog = (function (pName, pContents) {var type = Common.API.EVENT_ENUM.ADD_LOG;var data = pName + "?" + btoa(pContents);var widgetEvent = new WidgetEvent(type, data);sendWidgetEvent("", widgetEvent, false);});

        /**
         * @brief            Regist Key
         * @remarks       Let the widget manager regist specific key
         */    
    	this.registKey = function(pNumKeyCode) {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_REGIST, pNumKeyCode);
    		sendWidgetEvent("", widgetEvent, true);
    	}
    	
        /**
         * @brief            Unregist Key
         * @remarks       Let the widget manager unregist specific key
         */    
    	this.unregistKey = function(pNumKeyCode) {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_UNREGIST, pNumKeyCode);
    		sendWidgetEvent("", widgetEvent, true);
    	}

        /**
         * @brief            Regist IME Key
         * @remarks       Let the widget manager regist IME key
         */    
    	this.registIMEKey = function() {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_IME_MODE, "true");
    		sendWidgetEvent("", widgetEvent, true);
    	}

        /**
         * @brief            Regist IME Key
         * @remarks       Let the widget manager regist IME key
         */    
    	this.unregistIMEKey = function() {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_IME_MODE, "true");
    		sendWidgetEvent("", widgetEvent, true);
    	}

        /**
         * @brief            
         * @remarks       
         */    
    	this.registAllKey = function() {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_REGIST_ALL, "false");
    		sendWidgetEvent("", widgetEvent, true);
    	}

        /**
         * @brief            
         * @remarks       
         */    
    	this.unregistAllKey = function() {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_UNREGIST_ALL, "false");
    		sendWidgetEvent("", widgetEvent, true);
    	}

        /**
         * @brief            
         * @remarks       
         */    
    	this.registFullWidgetKey = function() {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_REGIST_FULL_WIDGET, "false");
    		sendWidgetEvent("", widgetEvent, true);
    	}

        /**
         * @brief            
         * @remarks       
         */    
    	this.registPartWidgetKey = function() {
    		var widgetEvent = new WidgetEvent(Common.API.EVENT_ENUM.KEY_REGIST_PART_WIDGET, "false");
    		sendWidgetEvent("", widgetEvent, true);
    	}
    }
}
