/*!
 * Crypto-JS v2.0.0
 * http://code.google.com/p/crypto-js/
 * Copyright (c) 2009, Jeff Mott. All rights reserved.
 * http://code.google.com/p/crypto-js/wiki/License
 *  
 * mode for AES: CBC with PKCS7 padding.
 * 
 * adapted by nick from Crypto.mode.CBC.  DONT USE ENCRYPT()
 */
$htv.Libs.Crypto.mode.CBC7 = {

	encrypt: function (cipher, m, iv) {

	},

	decrypt: function (cipher, c, iv, use_pkcs7) {

		var blockSizeInBytes = cipher._blocksize * 4;
		
		// Decrypt each block
		for (var offset = 0; offset < c.length; offset += blockSizeInBytes) {

			// Save this crypted block
			var thisCryptedBlock = c.slice(offset, offset + blockSizeInBytes);

			// Decrypt block
			cipher._decryptblock(c, offset);

			if (offset == 0) {
				// XOR first block using IV
				for (var i = 0; i < blockSizeInBytes; i++)
					c[i] ^= iv[i];
			}
			else {
				// XOR decrypted block using previous crypted block
				for (var i = 0; i < blockSizeInBytes; i++)
					c[offset + i] ^= prevCryptedBlock[i];
			}

			// This crypted block is the new previous crypted block
			var prevCryptedBlock = thisCryptedBlock;

		}
		if (use_pkcs7) {
            // strip off PKCS7 patch.
            var padLength = c[c.length - 1];
            for (var i = 0; i < padLength; i++) {
                c.pop();
            }
        }
	}

};
