//  HULU CONFIDENTIAL MATERIAL. DO NOT DISTRIBUTE.
//  Copyright (C) 2009-2010 Hulu, LLC
//  All Rights Reserved
/**
 *
 * htvControlPool.js
 *
 * This class defines a mechanism for creating, releasing, and maintaining
 * controls, to reduce the overhead required for creation/deletion.
 */

/*jslint maxerr: 1000, nomen: false, evil: false, immed: true, plusplus: false */
/*global LOG, describe */

var $htv;

$htv.ControlPool = (function () {

    var _pool = {};
 
    function _getObject(type) {
        var control = null;
        if (_pool[type] && _pool[type].length > 0) {
            control = _pool[type].pop();
            return control;
        }
        // 
        
        // Map controls not in the format $htv.Controls.type
        /*
        switch (type) {
        case "ControlAlias": 
            control = new $htv.Controls.RealControl();
            break;
        default:
            break;
        }
        */
        
        // If the control type isn't explicitly mapped, try finding the type in $htv.Controls 
        if (!control) {
            try {
                if ($htv.Controls[type]) {
                    control = new $htv.Controls[type]();
                }
            }
            catch (e) {
                
            }
        }
        
        if (!control) {
            
        }
        
        return control;
    }
    
    function _releaseObject(obj) {
        var type = obj.className;
        // 
        if (!_pool[type]) {
            _pool[type] = [];
        }
        _pool[type].push(obj);
        // obj.hide();
        obj.dispose(); // sanitize state before initializing
        // temp: reset size
        obj.x = 0;
        obj.y = 0;
        obj.z = 0;
        obj.height = 0;
        obj.width = 0;
        obj.node = null;
        
    }
    
    
    return {
        releaseObject: _releaseObject,
        getObject: _getObject
    };

}());