/**
 * @author EvgeniyV (Profit-Labs Ltd.)
 */

/**
 * @class Class that describes Updater entity and provides work with application update.
 */
Updater = {};

/**
 * Update Info xml
 */
Updater.updateUrl = "http://178.238.92.30/Samsung/update.xml";
/**
 * Changes Info xml
 */
Updater.changesUrl = "http://178.238.92.30/Samsung/changes.xml";
/**
 * Manual (FAQ) Info xml
 */
Updater.manualUrl = "http://178.238.92.30/Samsung/manual.xml";

/**
 * Current version of App
 * @default "2.0.0"
 */
Updater.currentVersion = "2.0.0";

/**
 * Flag whether update is available.
 * @default false
 */
Updater.updateAvailable = false;

/**
 * @function
 * @description Checks updates of App.
 */
Updater.checkUpdate = function() {
    var cb = function(xml) {
		var versionNumber = 0;
		var upgradeUrl = "";
		var message = "";
			  
		$(xml).find('ViaMediaSamsung').each(function () {
			$(this).find('version').each(function () {
				versionNumber = $(this).text();
			});
			$(this).find('url').each(function () {
				upgradeUrl = $(this).text();
			});
			$(this).find('message').each(function () {
				message = $(this).text();
			});
		});    
					
		if (Updater.currentVersion != versionNumber) {
			Logger.write("[Updater] Update available", "Update");
			Updater.updateAvailable = true;
			SceneUpdatePopUp.active = true;
			Updater.message = message;
			if (AppContext.CurrentScene === "MainMenu") {
				SceneUpdatePopUp.show(message, "MainMenu");
			}
		}
    };
    
    var errCb = function() {
        Logger.write("[Updater] Error while checking update", "Update");
    };
    
    Helpers.loadXML(Updater.updateUrl, cb, errCb);
};

/**
 * @function
 * @description load list of change from {@link Updater.manualUrl}
 * @param {function} completeCallback - event occurs when loading success.
 */
Updater.loadChangesList = function (completeCallback) {
	var cb = function (xml) {
		var versionNumber = 0;
		var changes = {};
			  
		$(xml).find('ViaMediaSamsung').each(function () {
			$(this).find('version').each(function () {
				versionNumber = $(this).text();
			});
			$(this).find('changes').each(function () {
				for (var i = 0; i < AppContext.Languages.length; i++) {
					var culture = AppContext.Languages[i].cultureInfo;
					$(this).find(culture).each(function () {
						changes[culture] = $(this).text();
					});
				}
			});
		});    
		
		Logger.write("changes: " + changes, "Update", true);
		if (Updater.currentVersion != versionNumber) {
			completeCallback(changes);
		}
	};
	
	var errCb = function () {
        Logger.write("[Updater] Error while checking changes list", "Update");
    };
	
	Helpers.loadXML(Updater.changesUrl, cb, errCb);
};

/**
 * @function
 * @description load manual from {@link Updater.changesUrl}.
 * @param {function} completeCallback - event occurs when loading success.
 */
Updater.loadManual = function (completeCallback) {
	var cb = function (xml) {
		var manual = {};
			  
		$(xml).find('ViaMediaSamsung').each(function () {
			$(this).find('manual').each(function () {
				for (var i = 0; i < AppContext.Languages.length; i++) {
					var culture = AppContext.Languages[i].cultureInfo;
					$(this).find(culture).each(function () {
						manual[culture] = $(this).text();
					});
				}
			});
		});    
		
		Logger.write("manual: " + manual, "Update", true);
		completeCallback(manual);
	};
	
	var errCb = function () {
        Logger.write("[Updater] Error while checking manual", "Update");
    };
	
	Helpers.loadXML(Updater.manualUrl, cb, errCb);
};