var widgetAPI = new Common.API.Widget();
var pluginAPI = new Common.API.Plugin();
var tvKey = new Common.API.TVKeyValue();
var ExternalWidgetInterface = null;
var password = "asd151cesQr"; // Random typing by aturek@amazon.com

var Main =
{
    player : null,
    asin : null,
    firmware : null,
    datamap : null
}

Main.onLoad = function()
{
    widgetAPI.sendReadyEvent();
    
    window.onShow = Main.initKeys;
    Main.player = window["AmazonVOD"];
        ExternalWidgetInterface = document.getElementById("pluginObject");
        //making sure we have External Widget Interface
        window.alert("external widget = " + ExternalWidgetInterface);

    var params = location.search.substring(1).split("&");
    for(var p in params)
    {
        window.alert("Parameter");
        window.alert(params[p]);
        var split = params[p].split('=');
        var key = split[0];
        var val = split[1];
        window.alert("key = " + key + ", val = " + val);
        
        if(key == "data")
        {
            // This should probably use a JSON parser, but I don't think Samsung comes with one
            var bits = val.split("%22");
            this.asin = bits[bits.length - 2];
            window.alert("found asin - " + this.asin);
         }
         else if(key == "firmware")
         {
            this.firmware = val;
            window.alert("found firmware - " + this.firmware);
         }
    }
    
    // Cache a key-value map in JS. This map will be write-on-change.
    Main.datamap = _readMapFromFile(password, ExternalWidgetInterface) || {};
}

Main.onUnload = function()
{
    Main.deinit();
}

Main.deinit = function()
{      
        //Utils.debug("Main.deinit");
        if (Main.pluginAPI && (Main.originalSource != null) )
        {
            /* Restore original TV source before closing the widget */
            Main.pluginAPI.SetSource(Main.originalSource);
            Utils.debug("Restore source to " + Main.originalSource);
        }
        Utils.widgetAPI.sendReturnEvent();
}

Main.initKeys = function()
{
    pluginAPI.SetBannerState(1);
    var nnaviPlugin = document.getElementById("pluginObjectNNavi");
    nnaviPlugin.SetBannerState(2);

    // For volume OSD   
    pluginAPI.unregistKey(tvKey.KEY_VOL_UP);
    pluginAPI.unregistKey(tvKey.KEY_VOL_DOWN);
    pluginAPI.unregistKey(tvKey.KEY_MUTE);
    
    // For Menu key, Info.L key 
    pluginAPI.unregistKey(tvKey.KEY_MENU);
    pluginAPI.unregistKey(tvKey.KEY_INFOLINK);
}

Main.getAsin = function()
{
    return this.asin;
}

Main.getFirmware = function()
{
    // This should be uncommented when the firmware is passed in as a query parameter to this application. 
    //  Right now MediaHub doesn't do that, though, so we'll use a hard-coded value.
    //return this.firmware;
    
    return "SamsungFirmware";
}

// Called from Actionscript
function getAsin()
{
    return Main.getAsin();
}

// Called from Actionscript
function exitApplication()
{
    // Either this or sendExitEvent
    widgetAPI.sendReturnEvent();
}

// Called from Actionscript
function getMacAddress()
{
    // Use the wired MAC address
    var networkPlugin = document.getElementById("pluginObjectNetwork");
    window.alert("mac address == " + networkPlugin.GetMAC(1));
    return networkPlugin.GetMAC(1);
}

// Called from Actionscript
function getDeviceUniqueId()
{
    var nnaviPlugin = document.getElementById("pluginObjectNNavi");
    window.alert("DUID == " + nnaviPlugin.GetDUID(getMacAddress()));
    return nnaviPlugin.GetDUID(getMacAddress());
}

// Called from Actionscript
function getFirmware()
{
    // This comes in with the call to this application.
    window.alert("firmware == " + Main.getFirmware());
    return Main.getFirmware();
}

// Called from Actionscript
function setScreensaver(on)
{
}

// Hopefully neither of these strings are in our DST or search results...
var _KV_SEP = "KEYVALUE";
var _PAIR_SEP = "NEXTPAIR";

function _deserialize(flatFile) {
    if(!flatFile) return {};
    
    var pairs = flatFile.split(_PAIR_SEP);
    var keyValues = {};
    for(var i = 0; i < pairs.length; i++) {
        var pair = pairs[i];
        var kv = pair.split(_KV_SEP);
        var k = kv[0];
        var v = kv[1];
        keyValues[k] = v;
    }   
    return keyValues;
}

function _serialize(keyValues) {
    var list = [];
    for(key in keyValues) {
        var nwpair = key + _KV_SEP + keyValues[key];
        list.push(nwpair);
    }
    var flat = list.join(_PAIR_SEP);
    return flat;
}

/** Serializes a key-value map and writes it to secure storage.
@param keyValues A Javascript object
@param pw The password to encrypt data with
@param widgetInterface The widget plugin to write to*/
function _writeMapToFile(keyValues, pw, widgetInterface) {
    var flat = _serialize(keyValues);
    widgetInterface.WriteWidgetData(pw, flat, flat.length);
    window.alert("WROTE TO FILE");
}

/** @return key-value map*/
function _readMapFromFile(pw, widgetInterface) {
    var flatfile = widgetInterface.ReadWidgetData(pw);
    window.alert(typeof flatfile);
    var map = _deserialize(flatfile);
    window.alert("READ FROM FILE");
    return map;
}

// Called from Actionscript
function writeSecureStorage(key, v) {
    if(Main.datamap[key] === v) return;
    window.alert("WROTE TO MAP: " + key + " == " + v);
    Main.datamap[key] = v;
    updateStorage();
}

// Called from Actionscript
function readSecureStorage(key) {
    window.alert("READ FROM MAP: " + key + " == " + Main.datamap[key]);
    return Main.datamap[key] || null;
}

// Called from Actionscript
function deleteSecureStorage(key) {
    if(Main.datamap[key] === undefined) return;
    delete Main.datamap[key];
    updateStorage();
}

function updateStorage() {
    _writeMapToFile(Main.datamap, password, ExternalWidgetInterface);
}

// Called from Actionscript
function grabFocus() {
    document.getElementById("AmazonVOD").focus();
}